/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.domtree;

import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.domtree.Node;

public final class NoPresort
extends NonDominatedSorting {
    private Node[] nodes;
    private Node[] rankMergeArray;
    private final boolean useRecursiveMerge;

    public NoPresort(int n, int n2, boolean bl) {
        super(n, n2);
        this.nodes = new Node[n];
        this.rankMergeArray = new Node[n];
        this.useRecursiveMerge = bl;
        for (int i = 0; i < n; ++i) {
            this.nodes[i] = new Node(i);
        }
    }

    @Override
    protected void closeImpl() {
        this.nodes = null;
        this.rankMergeArray = null;
    }

    @Override
    public String getName() {
        return "Dominance Tree (no presort, " + (this.useRecursiveMerge ? "recursive merge" : "sequential merge") + ")";
    }

    private static Node merge(Node node, Node node2) {
        if (node == null) {
            return node2;
        }
        assert (node2 != null);
        Node node3 = null;
        Node node4 = node;
        while (node4 != null) {
            boolean bl = false;
            Node node5 = null;
            Node node6 = node2;
            while (node6 != null) {
                Node node7;
                int n = Node.dominanceComparison(node4, node6);
                if (n > 0) {
                    node7 = node4;
                    node4 = node4.next;
                    if (node3 == null) {
                        node = node4;
                    } else {
                        node3.next = node4;
                    }
                    node7.next = null;
                    node6.child = NoPresort.merge(node6.child, node7);
                    bl = true;
                    break;
                }
                if (n < 0) {
                    node7 = node6;
                    node6 = node6.next;
                    if (node5 == null) {
                        node2 = node6;
                    } else {
                        node5.next = node6;
                    }
                    node7.next = null;
                    node4.child = NoPresort.merge(node4.child, node7);
                    continue;
                }
                node5 = node6;
                node6 = node6.next;
            }
            if (bl) continue;
            node3 = node4;
            node4 = node4.next;
        }
        if (node == null) {
            return node2;
        }
        node3.next = node2;
        return node;
    }

    @Override
    protected void sortChecked(double[][] dArray, int[] nArray, int n) {
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            Node.initialize(this.nodes[i], dArray[i]);
        }
        Node node = NoPresort.mergeAllRecursively(this.nodes, 0, n2);
        int n3 = 0;
        while (node != null) {
            int n4 = this.rankAndPutChildrenToMergeArray(node, nArray, n3);
            node = NoPresort.mergeAll(this.rankMergeArray, n4, this.useRecursiveMerge);
            ++n3;
        }
    }

    private int rankAndPutChildrenToMergeArray(Node node, int[] nArray, int n) {
        int n2 = 0;
        while (node != null) {
            nArray[node.index] = n;
            if (node.child != null) {
                this.rankMergeArray[n2] = node.child;
                ++n2;
            }
            node = node.next;
        }
        return n2;
    }

    private static Node mergeAll(Node[] nodeArray, int n, boolean bl) {
        if (n == 0) {
            return null;
        }
        if (bl) {
            return NoPresort.mergeAllRecursively(nodeArray, 0, n);
        }
        Node node = nodeArray[0];
        for (int i = 1; i < n; ++i) {
            node = NoPresort.merge(node, nodeArray[i]);
        }
        return node;
    }

    private static Node mergeAllRecursively(Node[] nodeArray, int n, int n2) {
        if (n + 1 == n2) {
            return nodeArray[n];
        }
        int n3 = n + n2 >>> 1;
        return NoPresort.merge(NoPresort.mergeAllRecursively(nodeArray, n, n3), NoPresort.mergeAllRecursively(nodeArray, n3, n2));
    }
}

