/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.fnds;

import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.DominanceHelper;

public class LinearMemory
extends NonDominatedSorting {
    private double[][] testedPoints;
    private int[] testedPointRanks;

    public LinearMemory(int n, int n2) {
        super(n, n2);
        this.testedPoints = new double[n][];
        this.testedPointRanks = new int[n];
    }

    @Override
    public String getName() {
        return "Fast Non-Dominated Sorting (with linear memory)";
    }

    @Override
    protected void closeImpl() {
        this.testedPoints = null;
        this.testedPointRanks = null;
    }

    @Override
    protected void sortChecked(double[][] dArray, int[] nArray, int n) {
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = n3 - 1;
        ArrayHelper.fillIdentity(this.indices, n2);
        this.sorter.lexicographicalSort(dArray, this.indices, 0, n2, n3);
        int n5 = this.indices[0];
        nArray[n5] = 0;
        double[] dArray2 = dArray[n5];
        int n6 = 0;
        this.testedPoints[0] = dArray2;
        this.testedPointRanks[0] = 0;
        int n7 = 1;
        for (int i = 1; i < n2; ++i) {
            int n8;
            int n9 = this.indices[i];
            double[] dArray3 = dArray[n9];
            if (ArrayHelper.equal(dArray2, dArray3, n3)) {
                nArray[n9] = n6;
                continue;
            }
            int n10 = 0;
            for (int j = n7 - 1; !(j < 0 || n10 <= (n8 = this.testedPointRanks[j]) && DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.testedPoints[j], dArray3, n4) && (n10 = n8 + 1) > n); --j) {
            }
            nArray[n9] = n10;
            if (n10 <= n) {
                this.testedPointRanks[n7] = n10;
                this.testedPoints[n7] = dArray3;
                ++n7;
            }
            dArray2 = dArray3;
            n6 = n10;
        }
    }
}

