/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.jfb;

import java.util.Arrays;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.RecursiveTask;
import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.jfb.HybridAlgorithmWrapper;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.ArraySorter;
import ru.ifmo.nds.util.DominanceHelper;
import ru.ifmo.nds.util.SplitMergeHelper;

public abstract class JFBBase
extends NonDominatedSorting {
    private static final int FORK_JOIN_THRESHOLD = 400;
    int[] ranks;
    private double[][] points;
    double[][] transposedPoints;
    int maximalMeaningfulRank;
    private double[] temporary;
    private SplitMergeHelper splitMerge;
    private HybridAlgorithmWrapper.Instance hybrid;
    private ForkJoinPool pool;
    private final int allowedThreads;
    private final String nameAddend;

    JFBBase(int n, int n2, int n3, HybridAlgorithmWrapper hybridAlgorithmWrapper, String string) {
        super(n, n2);
        if (!hybridAlgorithmWrapper.supportsMultipleThreads()) {
            n3 = 1;
        }
        this.nameAddend = string + ", hybrid: " + hybridAlgorithmWrapper.getName();
        this.pool = n3 != 1 && this.makesSenseRunInParallel(n, n2) ? (n3 > 1 ? new ForkJoinPool(n3) : new ForkJoinPool()) : null;
        this.allowedThreads = n3 > 0 ? n3 : -1;
        this.temporary = new double[n];
        this.ranks = new int[n];
        if (n2 > 2) {
            this.points = new double[n][];
            this.transposedPoints = new double[n2][n];
            this.splitMerge = new SplitMergeHelper(n);
            this.hybrid = hybridAlgorithmWrapper.create(this.ranks, this.indices, this.points, this.transposedPoints);
        }
    }

    @Override
    protected void closeImpl() {
        this.temporary = null;
        this.ranks = null;
        this.points = null;
        this.transposedPoints = null;
        this.splitMerge = null;
        if (this.pool != null) {
            this.pool.shutdown();
            this.pool = null;
        }
        this.hybrid = null;
    }

    @Override
    public String getName() {
        return "Jensen-Fortin-Buzdalov, " + this.getThreadDescription() + ", " + this.nameAddend;
    }

    @Override
    protected final void sortChecked(double[][] dArray, int[] nArray, int n) {
        int n2 = dArray.length;
        final int n3 = dArray[0].length;
        Arrays.fill(nArray, 0);
        ArrayHelper.fillIdentity(this.indices, n2);
        this.sorter.lexicographicalSort(dArray, this.indices, 0, n2, n3);
        this.maximalMeaningfulRank = n;
        if (n3 == 2) {
            this.twoDimensionalCase(dArray, nArray);
        } else {
            final int n4 = ArraySorter.retainUniquePoints(dArray, this.indices, this.points, nArray);
            Arrays.fill(this.ranks, 0, n4, 0);
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    this.transposedPoints[j][i] = this.points[i][j];
                }
            }
            this.postTransposePointHook(n4);
            ArrayHelper.fillIdentity(this.indices, n4);
            if (this.pool != null && this.makesSenseRunInParallel(n2, n3)) {
                RecursiveAction recursiveAction = new RecursiveAction(){

                    @Override
                    protected void compute() {
                        JFBBase.this.helperA(0, n4, n3 - 1);
                    }
                };
                this.pool.invoke(recursiveAction);
            } else {
                this.helperA(0, n4, n3 - 1);
            }
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.ranks[nArray[i]];
                this.points[i] = null;
            }
        }
    }

    public static int kickOutOverflowedRanks(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4 = n2;
        for (int i = n2; i < n3; ++i) {
            int n5 = nArray[i];
            if (nArray2[n5] > n) continue;
            nArray[n4] = n5;
            ++n4;
        }
        return n4;
    }

    protected void postTransposePointHook(int n) {
    }

    protected abstract int sweepA(int var1, int var2);

    protected abstract int sweepB(int var1, int var2, int var3, int var4, int var5);

    private int helperA(int n, int n2, int n3) {
        int n4 = n2 - n;
        if (n4 <= 2) {
            int n5;
            int n6;
            int n7;
            if (n4 == 2 && this.ranks[n7 = this.indices[n + 1]] <= (n6 = this.ranks[n5 = this.indices[n]]) && DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.points[n5], this.points[n7], n3)) {
                this.ranks[n7] = 1 + n6;
                if (n6 >= this.maximalMeaningfulRank) {
                    return n + 1;
                }
            }
            return n2;
        }
        while (n3 > 1) {
            int n8 = this.hybrid.helperAHook(n, n2, n3, this.maximalMeaningfulRank);
            if (n8 >= 0) {
                return n8;
            }
            if (ArrayHelper.transplantAndCheckIfSame(this.transposedPoints[n3], this.indices, n, n2, this.temporary, n)) {
                --n3;
                continue;
            }
            double d = ArrayHelper.destructiveMedian(this.temporary, n, n2);
            long l = this.splitMerge.splitInThree(this.transposedPoints[n3], this.indices, n, n, n2, d);
            int n9 = SplitMergeHelper.extractMid(l);
            int n10 = SplitMergeHelper.extractRight(l);
            int n11 = this.helperA(n, n9, n3);
            int n12 = this.helperB(n, n11, n9, n10, --n3, n);
            n12 = this.helperA(n9, n12, n3);
            int n13 = this.helperB(n, n11, n10, n2, n3, n);
            n13 = this.helperB(n9, n12, n10, n13, n3, n);
            n13 = this.helperA(n10, n13, ++n3);
            return this.splitMerge.mergeThree(this.indices, n, n, n11, n9, n12, n10, n13);
        }
        return this.sweepA(n, n2);
    }

    public static int updateByPoint(int[] nArray, int[] nArray2, double[][] dArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = nArray[n2];
        if (n6 == n) {
            return JFBBase.updateByPointCritical(nArray, nArray2, dArray, n, n2, n3, n4, n5);
        }
        JFBBase.updateByPointNormal(nArray, nArray2, dArray, n2, n6, n3, n4, n5);
        return n4;
    }

    private static void updateByPointNormal(int[] nArray, int[] nArray2, double[][] dArray, int n, int n2, int n3, int n4, int n5) {
        double[] dArray2 = dArray[n];
        for (int i = n3; i < n4; ++i) {
            int n6 = nArray2[i];
            if (nArray[n6] > n2 || !DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(dArray2, dArray[n6], n5)) continue;
            nArray[n6] = n2 + 1;
        }
    }

    private static int updateByPointCritical(int[] nArray, int[] nArray2, double[][] dArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = n4;
        double[] dArray2 = dArray[n2];
        for (int i = n3; i < n4; ++i) {
            int n7 = nArray2[i];
            if (!DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(dArray2, dArray[n7], n5)) continue;
            nArray[n7] = n + 1;
            if (n6 <= i) continue;
            n6 = i;
        }
        return JFBBase.kickOutOverflowedRanks(nArray2, nArray, n, n6, n4);
    }

    private int helperBWeak1Generic(int n, int n2, int n3, int n4, int n5, double[] dArray, int n6, int n7) {
        for (int i = n7; i >= n6; --i) {
            int n8 = this.indices[i];
            int n9 = this.ranks[n8];
            if (n4 > n9 || !DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.points[n8], dArray, n3) || (n4 = n9 + 1) <= this.maximalMeaningfulRank) continue;
            this.ranks[n2] = n4;
            return n;
        }
        if (n4 != n5) {
            this.ranks[n2] = n4;
        }
        return n + 1;
    }

    private int helperBWeak1Rank0(int n, int n2, int n3, double[] dArray, int n4, int n5) {
        for (int i = n5; i >= n4; --i) {
            int n6 = this.indices[i];
            if (!DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.points[n6], dArray, n3)) continue;
            int n7 = this.ranks[n6] + 1;
            if (n7 > this.maximalMeaningfulRank) {
                this.ranks[n2] = n7;
                return n;
            }
            return this.helperBWeak1Generic(n, n2, n3, n7, 0, dArray, n4, i - 1);
        }
        return n + 1;
    }

    private int helperBWeak1(int n, int n2, int n3, int n4) {
        int n5 = this.indices[n3];
        int n6 = this.ranks[n5];
        double[] dArray = this.points[n5];
        if (n6 == 0) {
            return this.helperBWeak1Rank0(n3, n5, n4, dArray, n, n2 - 1);
        }
        return this.helperBWeak1Generic(n3, n5, n4, n6, n6, dArray, n, n2 - 1);
    }

    private RecursiveTask<Integer> helperBAsync(final int n, final int n2, final int n3, final int n4, final int n5, final int n6) {
        return new RecursiveTask<Integer>(){

            @Override
            protected Integer compute() {
                return JFBBase.this.helperB(n, n2, n3, n4, n5, n6);
            }
        };
    }

    private int helperB(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n2 - n > 0 && n4 - n3 > 0) {
            n2 = ArrayHelper.findLastWhereNotGreater(this.indices, n, n2, this.indices[n4 - 1]);
            n3 = ArrayHelper.findWhereNotSmaller(this.indices, n3, n4, this.indices[n]);
        }
        int n7 = n2 - n;
        int n8 = n4 - n3;
        if (n7 > 0 && n8 > 0) {
            if (n7 == 1) {
                return JFBBase.updateByPoint(this.ranks, this.indices, this.points, this.maximalMeaningfulRank, this.indices[n], n3, n4, n5);
            }
            if (n8 == 1) {
                return this.helperBWeak1(n, n2, n3, n5);
            }
            while (n5 > 1) {
                int n9 = this.hybrid.helperBHook(n, n2, n3, n4, n5, n6, this.maximalMeaningfulRank);
                if (n9 >= 0) {
                    return n9;
                }
                double[] dArray = this.transposedPoints[n5];
                switch (ArrayHelper.transplantAndDecide(dArray, this.indices, n, n2, n3, n4, this.temporary, n6)) {
                    case 0: {
                        --n5;
                        break;
                    }
                    case 1: {
                        return n4;
                    }
                    case 2: {
                        double d = ArrayHelper.destructiveMedian(this.temporary, n6, n6 + n2 - n + n4 - n3);
                        long l = this.splitMerge.splitInThree(dArray, this.indices, n6, n, n2, d);
                        int n10 = SplitMergeHelper.extractMid(l);
                        int n11 = SplitMergeHelper.extractRight(l);
                        long l2 = this.splitMerge.splitInThree(dArray, this.indices, n6, n3, n4, d);
                        int n12 = SplitMergeHelper.extractMid(l2);
                        int n13 = SplitMergeHelper.extractRight(l2);
                        int n14 = n6 + (n2 - n + n4 - n3 >>> 1);
                        int n15 = this.helperB(n, n10, n13, n4, --n5, n6);
                        n15 = this.helperB(n10, n11, n13, n15, n5, n6);
                        int n16 = this.helperB(n, n10, n12, n13, n5, n6);
                        n16 = this.helperB(n10, n11, n12, n16, n5, n6);
                        ++n5;
                        ForkJoinTask forkJoinTask = null;
                        if (this.pool != null && n10 - n + n12 - n3 > 400) {
                            forkJoinTask = this.helperBAsync(n, n10, n3, n12, n5, n6).fork();
                        }
                        n15 = this.helperB(n11, n2, n13, n15, n5, n14);
                        int n17 = forkJoinTask != null ? ((Integer)forkJoinTask.join()).intValue() : this.helperB(n, n10, n3, n12, n5, n6);
                        this.splitMerge.mergeThree(this.indices, n6, n, n10, n10, n11, n11, n2);
                        return this.splitMerge.mergeThree(this.indices, n6, n3, n17, n12, n16, n13, n15);
                    }
                }
            }
            return this.sweepB(n, n2, n3, n4, n6);
        }
        return n4;
    }

    private void twoDimensionalCase(double[][] dArray, int[] nArray) {
        int n = 1;
        int n2 = nArray.length;
        double[] dArray2 = dArray[this.indices[0]];
        double d = dArray2[0];
        double d2 = dArray2[1];
        int n3 = 0;
        double d3 = d2;
        for (int i = 1; i < n2; ++i) {
            int n4 = this.indices[i];
            double[] dArray3 = dArray[n4];
            double d4 = dArray3[0];
            double d5 = dArray3[1];
            if (d4 == d && d5 == d2) {
                nArray[n4] = n3;
            } else if (d5 < d3) {
                d3 = d5;
                n3 = 0;
            } else {
                int n5;
                int n6;
                if (d5 < d2) {
                    n6 = 0;
                    n5 = n3;
                } else {
                    n6 = n3;
                    n5 = n;
                }
                while (n5 - n6 > 1) {
                    int n7 = n6 + n5 >>> 1;
                    double d6 = this.temporary[n7];
                    if (d5 < d6) {
                        n5 = n7;
                        continue;
                    }
                    n6 = n7;
                }
                nArray[n4] = n3 = n5;
                this.temporary[n5] = d5;
                if (n5 == n && n <= this.maximalMeaningfulRank) {
                    ++n;
                }
            }
            d = d4;
            d2 = d5;
        }
    }

    private boolean makesSenseRunInParallel(int n, int n2) {
        return n > 400 && n2 > 3;
    }

    private String getThreadDescription() {
        return this.allowedThreads == -1 ? "unlimited threads" : this.allowedThreads + " thread(s)";
    }
}

