/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.ndt;

import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.ndt.Split;
import ru.ifmo.nds.ndt.SplitBuilder;
import ru.ifmo.nds.ndt.TreeRankNode;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.ArraySorter;

public class ENS_NDT_OneTree
extends NonDominatedSorting {
    private SplitBuilder splitBuilder;
    private int[] ranks;
    private double[][] transposedPoints;
    private double[][] points;
    private final int threshold;

    public ENS_NDT_OneTree(int n, int n2, int n3) {
        super(n, n2);
        this.threshold = n3;
        this.ranks = new int[n];
        this.transposedPoints = new double[n2][];
        for (int i = 1; i < n2; ++i) {
            this.transposedPoints[i] = new double[n];
        }
        this.splitBuilder = new SplitBuilder(this.transposedPoints, n, n3);
        this.points = new double[n][];
    }

    @Override
    public String getName() {
        return "ENS-NDT OneTree (Objects, threshold = " + this.threshold + ")";
    }

    @Override
    protected void closeImpl() {
        this.splitBuilder = null;
        this.ranks = null;
        this.transposedPoints = null;
        this.points = null;
    }

    @Override
    protected void sortChecked(double[][] dArray, int[] nArray, int n) {
        int n2;
        int n3;
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        ArrayHelper.fillIdentity(this.indices, n4);
        this.sorter.lexicographicalSort(dArray, this.indices, 0, n4, n5);
        int n6 = ArraySorter.retainUniquePoints(dArray, this.indices, this.points, nArray);
        this.ranks[0] = 0;
        TreeRankNode treeRankNode = this.threshold == 1 ? TreeRankNode.EMPTY_1 : TreeRankNode.EMPTY;
        for (int i = 0; i < n6; ++i) {
            for (n3 = 1; n3 < n5; ++n3) {
                this.transposedPoints[n3][i] = this.points[i][n3];
            }
        }
        Split split = this.splitBuilder.result(n6, n5);
        treeRankNode = treeRankNode.add(this.points[0], 0, split, this.threshold);
        n3 = n5 - 1;
        for (n2 = 1; n2 < n6; ++n2) {
            int n7;
            double[] dArray2 = this.points[n2];
            this.ranks[n2] = n7 = treeRankNode.evaluateRank(dArray2, 0, split, n3);
            if (n7 > n) continue;
            treeRankNode = treeRankNode.add(dArray2, n7, split, this.threshold);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = this.ranks[nArray[n2]];
            this.points[n2] = null;
        }
    }
}

