/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.ndt;

import ru.ifmo.nds.ndt.Split;
import ru.ifmo.nds.util.DominanceHelper;

public abstract class TreeNode {
    static final TreeNode EMPTY = new EmptyNode();
    static final TreeNode EMPTY_1 = new EmptyNode1();

    public abstract TreeNode add(double[] var1, Split var2, int var3);

    public abstract boolean dominates(double[] var1, Split var2);

    private static class BranchingNode
    extends TreeNode {
        private TreeNode good;
        private TreeNode weak;

        private BranchingNode(TreeNode treeNode, TreeNode treeNode2) {
            this.weak = treeNode2;
            this.good = treeNode;
        }

        @Override
        public TreeNode add(double[] dArray, Split split, int n) {
            if (dArray[split.coordinate] >= split.value) {
                this.weak = this.weak.add(dArray, split.weak, n);
            } else {
                this.good = this.good.add(dArray, split.good, n);
            }
            return this;
        }

        @Override
        public boolean dominates(double[] dArray, Split split) {
            return this.good != null && this.good.dominates(dArray, split.good) || this.weak != null && dArray[split.coordinate] >= split.value && this.weak.dominates(dArray, split.weak);
        }
    }

    private static class TerminalNode1
    extends TreeNode {
        private double[] point = null;

        private TerminalNode1() {
        }

        @Override
        public TreeNode add(double[] dArray, Split split, int n) {
            if (this.point != null) {
                TerminalNode1 terminalNode1 = new TerminalNode1();
                Split split2 = split.good;
                int n2 = split.coordinate;
                double d = split.value;
                if (this.point[n2] < d) {
                    terminalNode1.add(this.point, split2, n);
                    this.point = null;
                }
                return new BranchingNode(terminalNode1, this).add(dArray, split, n);
            }
            this.point = dArray;
            return this;
        }

        @Override
        public boolean dominates(double[] dArray, Split split) {
            return this.point != null && DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.point, dArray, dArray.length - 1);
        }
    }

    private static class TerminalNode
    extends TreeNode {
        private int size = 0;
        private double[][] points = null;

        private TerminalNode() {
        }

        @Override
        public TreeNode add(double[] dArray, Split split, int n) {
            if (this.points == null) {
                this.points = new double[n][];
            }
            if (this.size == this.points.length) {
                TerminalNode terminalNode = new TerminalNode();
                Split split2 = split.good;
                int n2 = split.coordinate;
                double d = split.value;
                int n3 = this.size;
                this.size = 0;
                for (int i = 0; i < n3; ++i) {
                    double[] dArray2 = this.points[i];
                    if (dArray2[n2] < d) {
                        terminalNode.add(dArray2, split2, n);
                        continue;
                    }
                    this.points[this.size] = dArray2;
                    ++this.size;
                }
                return new BranchingNode(terminalNode, this).add(dArray, split, n);
            }
            this.points[this.size++] = dArray;
            return this;
        }

        @Override
        public boolean dominates(double[] dArray, Split split) {
            int n = dArray.length - 1;
            for (int i = 0; i < this.size; ++i) {
                if (!DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.points[i], dArray, n)) continue;
                return true;
            }
            return false;
        }
    }

    private static class EmptyNode1
    extends TreeNode {
        private EmptyNode1() {
        }

        @Override
        public TreeNode add(double[] dArray, Split split, int n) {
            return new TerminalNode1().add(dArray, split, n);
        }

        @Override
        public boolean dominates(double[] dArray, Split split) {
            return false;
        }
    }

    private static class EmptyNode
    extends TreeNode {
        private EmptyNode() {
        }

        @Override
        public TreeNode add(double[] dArray, Split split, int n) {
            return new TerminalNode().add(dArray, split, n);
        }

        @Override
        public boolean dominates(double[] dArray, Split split) {
            return false;
        }
    }
}

