/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.util;

public final class ArrayHelper {
    public static final int TRANSPLANT_LEFT_NOT_GREATER = 0;
    public static final int TRANSPLANT_RIGHT_SMALLER = 1;
    public static final int TRANSPLANT_GENERAL_CASE = 2;

    private ArrayHelper() {
    }

    public static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public static boolean equal(double[] dArray, double[] dArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (dArray[i] == dArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static void fillIdentity(int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
    }

    public static void fillIdentity(int[] nArray, int n, int n2) {
        int n3 = n2;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n3++;
        }
    }

    public static double destructiveMedian(double[] dArray, int n, int n2) {
        int n3 = n + n2 >>> 1;
        int n4 = n2 - 1;
        while (n < n4) {
            double d;
            double d2 = dArray[n + n4 >>> 1];
            if (n + 4 < n4) {
                d = (dArray[n] + dArray[n4]) / 2.0;
                d2 = (d2 + d) / 2.0;
            }
            int n5 = n;
            int n6 = n4;
            while (true) {
                double d3;
                double d4;
                d = dArray[n5];
                if (d4 < d2) {
                    ++n5;
                    continue;
                }
                while (true) {
                    double d5;
                    d3 = dArray[n6];
                    if (!(d5 > d2)) break;
                    --n6;
                }
                if (n5 <= n6) {
                    dArray[n5] = d3;
                    dArray[n6] = d;
                    ++n5;
                    --n6;
                }
                if (n5 > n6) break;
            }
            if (n3 < n6) {
                n4 = n6;
                continue;
            }
            if (n5 < n3) {
                n = n5;
                continue;
            }
            if (n6 == n3) {
                return ArrayHelper.max(dArray, n, n6 + 1);
            }
            if (n5 == n3) {
                return ArrayHelper.min(dArray, n5, n4 + 1);
            }
            return dArray[n3];
        }
        return dArray[n3];
    }

    public static void transplant(double[] dArray, int[] nArray, int n, int n2, double[] dArray2, int n3) {
        int n4 = n;
        while (n4 < n2) {
            dArray2[n3] = dArray[nArray[n4]];
            ++n4;
            ++n3;
        }
    }

    private static boolean transplantAndCheckIfNotSmaller(double[] dArray, int[] nArray, int n, int n2, double[] dArray2, int n3, double d) {
        int n4 = n;
        while (n4 < n2) {
            double d2;
            dArray2[n3] = d2 = dArray[nArray[n4]];
            if (d2 < d) {
                ArrayHelper.transplant(dArray, nArray, n4 + 1, n2, dArray2, n3 + 1);
                return false;
            }
            ++n4;
            ++n3;
        }
        return true;
    }

    private static boolean transplantAndCheckIfNotGreater(double[] dArray, int[] nArray, int n, int n2, double[] dArray2, int n3, double d) {
        int n4 = n;
        while (n4 < n2) {
            double d2;
            dArray2[n3] = d2 = dArray[nArray[n4]];
            if (d2 > d) {
                ArrayHelper.transplant(dArray, nArray, n4 + 1, n2, dArray2, n3 + 1);
                return false;
            }
            ++n4;
            ++n3;
        }
        return true;
    }

    private static boolean transplantAndCheckIfSmaller(double[] dArray, int[] nArray, int n, int n2, double[] dArray2, int n3, double d) {
        int n4 = n;
        while (n4 < n2) {
            double d2;
            dArray2[n3] = d2 = dArray[nArray[n4]];
            if (d2 >= d) {
                ArrayHelper.transplant(dArray, nArray, n4 + 1, n2, dArray2, n3 + 1);
                return false;
            }
            ++n4;
            ++n3;
        }
        return true;
    }

    private static boolean transplantAndCheckIfGreater(double[] dArray, int[] nArray, int n, int n2, double[] dArray2, int n3, double d) {
        int n4 = n;
        while (n4 < n2) {
            double d2;
            dArray2[n3] = d2 = dArray[nArray[n4]];
            if (d2 <= d) {
                ArrayHelper.transplant(dArray, nArray, n4 + 1, n2, dArray2, n3 + 1);
                return false;
            }
            ++n4;
            ++n3;
        }
        return true;
    }

    private static int transplantAndDecideLeftBased(double[] dArray, int[] nArray, int n, int n2, int n3, int n4, double[] dArray2, int n5) {
        double d;
        double d2;
        double d3 = d2 = dArray[nArray[n]];
        dArray2[n5] = d2;
        ++n5;
        while (++n < n2) {
            d = dArray[nArray[n]];
            if (d2 > d) {
                d2 = d;
            }
            if (d3 < d) {
                d3 = d;
            }
            dArray2[n5] = d;
            ++n5;
        }
        dArray2[n5] = d = dArray[nArray[n3]];
        ++n5;
        ++n3;
        if (d3 <= d) {
            return ArrayHelper.transplantAndCheckIfNotSmaller(dArray, nArray, n3, n4, dArray2, n5, d3) ? 0 : 2;
        }
        if (d < d2) {
            return ArrayHelper.transplantAndCheckIfSmaller(dArray, nArray, n3, n4, dArray2, n5, d2) ? 1 : 2;
        }
        ArrayHelper.transplant(dArray, nArray, n3, n4, dArray2, n5);
        return 2;
    }

    private static int transplantAndDecideRightBased(double[] dArray, int[] nArray, int n, int n2, int n3, int n4, double[] dArray2, int n5) {
        double d;
        double d2;
        double d3 = d2 = dArray[nArray[n3]];
        dArray2[n5] = d2;
        ++n5;
        while (++n3 < n4) {
            d = dArray[nArray[n3]];
            if (d2 > d) {
                d2 = d;
            }
            if (d3 < d) {
                d3 = d;
            }
            dArray2[n5] = d;
            ++n5;
        }
        dArray2[n5] = d = dArray[nArray[n]];
        ++n5;
        ++n;
        if (d > d3) {
            return ArrayHelper.transplantAndCheckIfGreater(dArray, nArray, n, n2, dArray2, n5, d3) ? 1 : 2;
        }
        if (d2 >= d) {
            return ArrayHelper.transplantAndCheckIfNotGreater(dArray, nArray, n, n2, dArray2, n5, d2) ? 0 : 2;
        }
        ArrayHelper.transplant(dArray, nArray, n, n2, dArray2, n5);
        return 2;
    }

    public static int transplantAndDecide(double[] dArray, int[] nArray, int n, int n2, int n3, int n4, double[] dArray2, int n5) {
        if (n2 - n < n4 - n3) {
            return ArrayHelper.transplantAndDecideLeftBased(dArray, nArray, n, n2, n3, n4, dArray2, n5);
        }
        return ArrayHelper.transplantAndDecideRightBased(dArray, nArray, n, n2, n3, n4, dArray2, n5);
    }

    public static boolean transplantAndCheckIfSame(double[] dArray, int[] nArray, int n, int n2, double[] dArray2, int n3) {
        double d;
        dArray2[n3] = d = dArray[nArray[n]];
        ++n3;
        while (++n < n2) {
            double d2;
            dArray2[n3] = d2 = dArray[nArray[n]];
            ++n3;
            if (d2 == d) continue;
            ArrayHelper.transplant(dArray, nArray, n + 1, n2, dArray2, n3);
            return false;
        }
        return true;
    }

    private static double transplantMin(double[] dArray, int[] nArray, int n, int n2, double[] dArray2, int n3, double d) {
        int n4 = n;
        while (n4 < n2) {
            double d2 = dArray[nArray[n4]];
            if (d > d2) {
                d = d2;
            }
            dArray2[n3] = d2;
            ++n4;
            ++n3;
        }
        return d;
    }

    public static double transplantAndReturnMinIfNotSameElseNaN(double[] dArray, int[] nArray, int n, int n2, double[] dArray2, int n3) {
        double d;
        dArray2[n3] = d = dArray[nArray[n]];
        ++n3;
        while (++n < n2) {
            double d2;
            dArray2[n3] = d2 = dArray[nArray[n]];
            ++n3;
            if (d2 == d) continue;
            return ArrayHelper.transplantMin(dArray, nArray, n + 1, n2, dArray2, n3, Math.min(d2, d));
        }
        return Double.NaN;
    }

    public static int findWhereNotSmaller(int[] nArray, int n, int n2, int n3) {
        while (n < n2 && nArray[n] < n3) {
            ++n;
        }
        return n;
    }

    public static int findLastWhereNotGreater(int[] nArray, int n, int n2, int n3) {
        while (n < n2 && nArray[--n2] > n3) {
        }
        return n2 + 1;
    }

    public static double max(double[] dArray, int n, int n2) {
        if (n >= n2) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = dArray[n];
        for (int i = n + 1; i < n2; ++i) {
            double d2 = dArray[i];
            if (!(d < d2)) continue;
            d = d2;
        }
        return d;
    }

    public static double min(double[] dArray, int n, int n2) {
        if (n >= n2) {
            return Double.POSITIVE_INFINITY;
        }
        double d = dArray[n];
        for (int i = n + 1; i < n2; ++i) {
            double d2 = dArray[i];
            if (!(d > d2)) continue;
            d = d2;
        }
        return d;
    }
}

