/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.util;

import java.util.Arrays;
import ru.ifmo.nds.util.RankQueryStructureDouble;

public final class FenwickRankQueryStructureDouble
extends RankQueryStructureDouble {
    private final double[] keys;
    private final int[] values;

    public FenwickRankQueryStructureDouble(int n) {
        this.keys = new double[n];
        this.values = new int[n];
    }

    @Override
    public String getName() {
        return "Fenwick Tree for non-compressed coordinates";
    }

    @Override
    public int maximumPoints() {
        return this.keys.length;
    }

    @Override
    public boolean supportsMultipleThreads() {
        return true;
    }

    @Override
    public RankQueryStructureDouble.RangeHandle createHandle(int n, int n2, int n3, int[] nArray, double[] dArray) {
        return new RangeHandleImpl(n, n2, n3, nArray, dArray);
    }

    private final class RangeHandleImpl
    extends RankQueryStructureDouble.RangeHandle {
        private final int size;
        private final int offset;

        private RangeHandleImpl(int n, int n2, int n3, int[] nArray, double[] dArray) {
            this.offset = n;
            int n4 = n2;
            int n5 = this.offset;
            while (n4 < n3) {
                ((FenwickRankQueryStructureDouble)FenwickRankQueryStructureDouble.this).keys[n5] = dArray[nArray[n4]];
                ++n4;
                ++n5;
            }
            n4 = n + n3 - n2;
            Arrays.sort(FenwickRankQueryStructureDouble.this.keys, n, n4);
            n5 = this.offset + 1;
            double d = FenwickRankQueryStructureDouble.this.keys[this.offset];
            for (int i = n + 1; i < n4; ++i) {
                double d2 = FenwickRankQueryStructureDouble.this.keys[i];
                if (d2 == d) continue;
                ((FenwickRankQueryStructureDouble)FenwickRankQueryStructureDouble.this).keys[n5] = d = d2;
                ++n5;
            }
            Arrays.fill(FenwickRankQueryStructureDouble.this.values, this.offset, n5, -1);
            this.size = n5 - this.offset;
        }

        private int indexFor(double d) {
            int n = this.offset - 1;
            int n2 = this.offset + this.size;
            while (n2 - n > 1) {
                int n3 = n + n2 >>> 1;
                if (FenwickRankQueryStructureDouble.this.keys[n3] <= d) {
                    n = n3;
                    continue;
                }
                n2 = n3;
            }
            return n - this.offset;
        }

        @Override
        public RankQueryStructureDouble.RangeHandle put(double d, int n) {
            for (int i = this.indexFor(d); i < this.size; i |= i + 1) {
                int n2 = this.offset + i;
                ((FenwickRankQueryStructureDouble)FenwickRankQueryStructureDouble.this).values[n2] = Math.max(FenwickRankQueryStructureDouble.this.values[n2], n);
            }
            return this;
        }

        @Override
        public int getMaximumWithKeyAtMost(double d, int n) {
            int n2 = this.indexFor(d);
            int n3 = -1;
            while (n2 >= 0) {
                n3 = Math.max(n3, FenwickRankQueryStructureDouble.this.values[this.offset + n2]);
                n2 = (n2 & n2 + 1) - 1;
            }
            return n3;
        }
    }
}

