/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.UnassignedClassException;
import weka.core.Utils;
import weka.core.WekaEnumeration;
import weka.core.converters.ArffLoader;
import weka.core.converters.ConverterUtils;
import weka.experiment.Stats;

public class Instances
extends AbstractList<Instance>
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = -19412345060742748L;
    public static final String FILE_EXTENSION = ".arff";
    public static final String SERIALIZED_OBJ_FILE_EXTENSION = ".bsi";
    public static final String ARFF_RELATION = "@relation";
    public static final String ARFF_DATA = "@data";
    protected String m_RelationName;
    protected ArrayList<Attribute> m_Attributes;
    protected HashMap<String, Integer> m_NamesToAttributeIndices;
    protected ArrayList<Instance> m_Instances;
    protected int m_ClassIndex;
    protected int m_Lines = 0;

    public Instances(Reader reader) throws IOException {
        Instance inst;
        ArffLoader.ArffReader arff = new ArffLoader.ArffReader(reader, 1000, false);
        this.initialize(arff.getData(), 1000);
        arff.setRetainStringValues(true);
        while ((inst = arff.readInstance(this)) != null) {
            this.m_Instances.add(inst);
        }
        this.compactify();
    }

    @Deprecated
    public Instances(Reader reader, int capacity) throws IOException {
        ArffLoader.ArffReader arff = new ArffLoader.ArffReader(reader, 0);
        Instances header = arff.getStructure();
        this.initialize(header, capacity);
        this.m_Lines = arff.getLineNo();
    }

    public Instances(Instances dataset) {
        this(dataset, dataset.numInstances());
        dataset.copyInstances(0, this, dataset.numInstances());
    }

    public Instances(Instances dataset, int capacity) {
        this.initialize(dataset, capacity);
    }

    protected void initialize(Instances dataset, int capacity) {
        if (capacity < 0) {
            capacity = 0;
        }
        this.m_ClassIndex = dataset.m_ClassIndex;
        this.m_RelationName = dataset.m_RelationName;
        this.m_Attributes = dataset.m_Attributes;
        this.m_NamesToAttributeIndices = dataset.m_NamesToAttributeIndices;
        this.m_Instances = new ArrayList(capacity);
    }

    public Instances(Instances source, int first, int toCopy) {
        this(source, toCopy);
        if (first < 0 || first + toCopy > source.numInstances()) {
            throw new IllegalArgumentException("Parameters first and/or toCopy out of range");
        }
        source.copyInstances(first, this, toCopy);
    }

    public Instances(String name, ArrayList<Attribute> attInfo, int capacity) {
        HashSet<String> names = new HashSet<String>();
        StringBuffer nonUniqueNames = new StringBuffer();
        for (Attribute att : attInfo) {
            if (names.contains(att.name())) {
                nonUniqueNames.append("'" + att.name() + "' ");
            }
            names.add(att.name());
        }
        if (names.size() != attInfo.size()) {
            throw new IllegalArgumentException("Attribute names are not unique! Causes: " + nonUniqueNames.toString());
        }
        names.clear();
        this.m_RelationName = name;
        this.m_ClassIndex = -1;
        this.m_Attributes = attInfo;
        this.m_NamesToAttributeIndices = new HashMap((int)((double)this.numAttributes() / 0.75));
        for (int i = 0; i < this.numAttributes(); ++i) {
            this.attribute(i).setIndex(i);
            this.m_NamesToAttributeIndices.put(this.attribute(i).name(), i);
        }
        this.m_Instances = new ArrayList(capacity);
    }

    public Instances stringFreeStructure() {
        ArrayList<Attribute> newAtts = new ArrayList<Attribute>();
        for (Attribute attribute : this.m_Attributes) {
            if (attribute.type() == 2) {
                newAtts.add(new Attribute(attribute.name(), (List<String>)null, attribute.index()));
                continue;
            }
            if (attribute.type() != 4) continue;
            newAtts.add(new Attribute(attribute.name(), new Instances(attribute.relation(), 0), attribute.index()));
        }
        if (newAtts.size() == 0) {
            return new Instances(this, 0);
        }
        ArrayList atts = (ArrayList)Utils.cast(this.m_Attributes.clone());
        for (Attribute att : newAtts) {
            atts.set(att.index(), att);
        }
        Instances instances = new Instances(this, 0);
        instances.m_Attributes = atts;
        return instances;
    }

    @Override
    public boolean add(Instance instance) {
        Instance newInstance = (Instance)instance.copy();
        newInstance.setDataset(this);
        this.m_Instances.add(newInstance);
        return true;
    }

    @Override
    public void add(int index, Instance instance) {
        Instance newInstance = (Instance)instance.copy();
        newInstance.setDataset(this);
        this.m_Instances.add(index, newInstance);
    }

    public boolean allAttributeWeightsIdentical() {
        boolean foundOne = false;
        double weight = 0.0;
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (i == this.classIndex()) continue;
            if (foundOne && this.attribute(i).weight() != weight) {
                return false;
            }
            if (foundOne) continue;
            foundOne = true;
            weight = this.attribute(i).weight();
        }
        return true;
    }

    public boolean allInstanceWeightsIdentical() {
        if (this.numInstances() == 0) {
            return true;
        }
        double weight = this.instance(0).weight();
        for (int i = 1; i < this.numInstances(); ++i) {
            if (this.instance(i).weight() == weight) continue;
            return false;
        }
        return true;
    }

    public Attribute attribute(int index) {
        return this.m_Attributes.get(index);
    }

    public Attribute attribute(String name) {
        Integer index = this.m_NamesToAttributeIndices.get(name);
        if (index != null) {
            return this.attribute(index);
        }
        return null;
    }

    public boolean checkForAttributeType(int attType) {
        int i = 0;
        while (i < this.m_Attributes.size()) {
            if (this.attribute(i++).type() != attType) continue;
            return true;
        }
        return false;
    }

    public boolean checkForStringAttributes() {
        return this.checkForAttributeType(2);
    }

    public boolean checkInstance(Instance instance) {
        if (instance.numAttributes() != this.numAttributes()) {
            return false;
        }
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (instance.isMissing(i) || !this.attribute(i).isNominal() && !this.attribute(i).isString()) continue;
            if (instance.value(i) != (double)((int)instance.value(i))) {
                return false;
            }
            if (!(instance.value(i) < 0.0) && !(instance.value(i) > (double)(this.attribute(i).numValues() - 1))) continue;
            return false;
        }
        return true;
    }

    public Attribute classAttribute() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        return this.attribute(this.m_ClassIndex);
    }

    public int classIndex() {
        return this.m_ClassIndex;
    }

    public void compactify() {
        this.m_Instances.trimToSize();
    }

    public void delete() {
        this.m_Instances = new ArrayList();
    }

    public void delete(int index) {
        this.m_Instances.remove(index);
    }

    public void deleteAttributeAt(int position) {
        int i;
        if (position < 0 || position >= this.m_Attributes.size()) {
            throw new IllegalArgumentException("Cannot delete attribute: index out of range");
        }
        if (position == this.m_ClassIndex) {
            throw new IllegalArgumentException("Cannot delete class attribute");
        }
        ArrayList<Attribute> newList = new ArrayList<Attribute>(this.m_Attributes.size() - 1);
        HashMap<String, Integer> newMap = new HashMap<String, Integer>((int)((double)(this.m_Attributes.size() - 1) / 0.75));
        for (i = 0; i < position; ++i) {
            Attribute att = this.m_Attributes.get(i);
            newList.add(att);
            newMap.put(att.name(), i);
        }
        for (i = position + 1; i < this.m_Attributes.size(); ++i) {
            Attribute newAtt = (Attribute)this.m_Attributes.get(i).copy();
            newAtt.setIndex(i - 1);
            newList.add(newAtt);
            newMap.put(newAtt.name(), i - 1);
        }
        this.m_Attributes = newList;
        this.m_NamesToAttributeIndices = newMap;
        if (this.m_ClassIndex > position) {
            --this.m_ClassIndex;
        }
        for (i = 0; i < this.numInstances(); ++i) {
            this.instance(i).setDataset(null);
            this.instance(i).deleteAttributeAt(position);
            this.instance(i).setDataset(this);
        }
    }

    public void deleteAttributeType(int attType) {
        int i = 0;
        while (i < this.m_Attributes.size()) {
            if (this.attribute(i).type() == attType) {
                this.deleteAttributeAt(i);
                continue;
            }
            ++i;
        }
    }

    public void deleteStringAttributes() {
        this.deleteAttributeType(2);
    }

    public void deleteWithMissing(int attIndex) {
        ArrayList<Instance> newInstances = new ArrayList<Instance>(this.numInstances());
        for (int i = 0; i < this.numInstances(); ++i) {
            if (this.instance(i).isMissing(attIndex)) continue;
            newInstances.add(this.instance(i));
        }
        this.m_Instances = newInstances;
    }

    public void deleteWithMissing(Attribute att) {
        this.deleteWithMissing(att.index());
    }

    public void deleteWithMissingClass() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        this.deleteWithMissing(this.m_ClassIndex);
    }

    public Enumeration<Attribute> enumerateAttributes() {
        return new WekaEnumeration<Attribute>(this.m_Attributes, this.m_ClassIndex);
    }

    public Enumeration<Instance> enumerateInstances() {
        return new WekaEnumeration<Instance>(this.m_Instances);
    }

    public String equalHeadersMsg(Instances dataset) {
        if (this.m_ClassIndex != dataset.m_ClassIndex) {
            return "Class index differ: " + (this.m_ClassIndex + 1) + " != " + (dataset.m_ClassIndex + 1);
        }
        if (this.m_Attributes.size() != dataset.m_Attributes.size()) {
            return "Different number of attributes: " + this.m_Attributes.size() + " != " + dataset.m_Attributes.size();
        }
        for (int i = 0; i < this.m_Attributes.size(); ++i) {
            String msg = this.attribute(i).equalsMsg(dataset.attribute(i));
            if (msg == null) continue;
            return "Attributes differ at position " + (i + 1) + ":\n" + msg;
        }
        return null;
    }

    public boolean equalHeaders(Instances dataset) {
        return this.equalHeadersMsg(dataset) == null;
    }

    public Instance firstInstance() {
        return this.m_Instances.get(0);
    }

    public Random getRandomNumberGenerator(long seed) {
        Random r = new Random(seed);
        r.setSeed((long)this.instance(r.nextInt(this.numInstances())).toStringNoWeight().hashCode() + seed);
        return r;
    }

    public void insertAttributeAt(Attribute att, int position) {
        int i;
        if (position < 0 || position > this.m_Attributes.size()) {
            throw new IllegalArgumentException("Cannot insert attribute: index out of range");
        }
        Attribute existingAttribute = this.attribute(att.name());
        if (existingAttribute != null) {
            throw new IllegalArgumentException("Cannot insert attribute: name '" + att.name() + "' already in use in the " + Utils.indexToOrdinal(existingAttribute.index()) + " attribute " + existingAttribute);
        }
        att = (Attribute)att.copy();
        att.setIndex(position);
        ArrayList<Attribute> newList = new ArrayList<Attribute>(this.m_Attributes.size() + 1);
        HashMap<String, Integer> newMap = new HashMap<String, Integer>((int)((double)(this.m_Attributes.size() + 1) / 0.75));
        for (i = 0; i < position; ++i) {
            Attribute oldAtt = this.m_Attributes.get(i);
            newList.add(oldAtt);
            newMap.put(oldAtt.name(), i);
        }
        newList.add(att);
        newMap.put(att.name(), position);
        for (i = position; i < this.m_Attributes.size(); ++i) {
            Attribute newAtt = (Attribute)this.m_Attributes.get(i).copy();
            newAtt.setIndex(i + 1);
            newList.add(newAtt);
            newMap.put(newAtt.name(), i + 1);
        }
        this.m_Attributes = newList;
        this.m_NamesToAttributeIndices = newMap;
        for (i = 0; i < this.numInstances(); ++i) {
            this.instance(i).setDataset(null);
            this.instance(i).insertAttributeAt(position);
            this.instance(i).setDataset(this);
        }
        if (this.m_ClassIndex >= position) {
            ++this.m_ClassIndex;
        }
    }

    public Instance instance(int index) {
        return this.m_Instances.get(index);
    }

    @Override
    public Instance get(int index) {
        return this.m_Instances.get(index);
    }

    public double kthSmallestValue(Attribute att, int k) {
        return this.kthSmallestValue(att.index(), k);
    }

    public double kthSmallestValue(int attIndex, int k) {
        if (!this.attribute(attIndex).isNumeric()) {
            throw new IllegalArgumentException("Instances: attribute must be numeric to compute kth-smallest value.");
        }
        if (k < 1 || k > this.numInstances()) {
            throw new IllegalArgumentException("Instances: value for k for computing kth-smallest value too large.");
        }
        double[] vals = new double[this.numInstances()];
        for (int i = 0; i < vals.length; ++i) {
            double val = this.instance(i).value(attIndex);
            vals[i] = Utils.isMissingValue(val) ? Double.MAX_VALUE : val;
        }
        return Utils.kthSmallestValue(vals, k);
    }

    public Instance lastInstance() {
        return this.m_Instances.get(this.m_Instances.size() - 1);
    }

    public double meanOrMode(int attIndex) {
        if (this.attribute(attIndex).isNumeric()) {
            double found = 0.0;
            double result = 0.0;
            for (int j = 0; j < this.numInstances(); ++j) {
                if (this.instance(j).isMissing(attIndex)) continue;
                found += this.instance(j).weight();
                result += this.instance(j).weight() * this.instance(j).value(attIndex);
            }
            if (found <= 0.0) {
                return 0.0;
            }
            return result / found;
        }
        if (this.attribute(attIndex).isNominal()) {
            int[] counts = new int[this.attribute(attIndex).numValues()];
            for (int j = 0; j < this.numInstances(); ++j) {
                if (this.instance(j).isMissing(attIndex)) continue;
                int n = (int)this.instance(j).value(attIndex);
                counts[n] = (int)((double)counts[n] + this.instance(j).weight());
            }
            return Utils.maxIndex(counts);
        }
        return 0.0;
    }

    public double meanOrMode(Attribute att) {
        return this.meanOrMode(att.index());
    }

    public int numAttributes() {
        return this.m_Attributes.size();
    }

    public int numClasses() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        if (!this.classAttribute().isNominal()) {
            return 1;
        }
        return this.classAttribute().numValues();
    }

    public int numDistinctValues(int attIndex) {
        HashSet<Double> set = new HashSet<Double>(2 * this.numInstances());
        for (Instance current : this) {
            double key = current.value(attIndex);
            if (Utils.isMissingValue(key)) continue;
            set.add(key);
        }
        return set.size();
    }

    public int numDistinctValues(Attribute att) {
        return this.numDistinctValues(att.index());
    }

    public int numInstances() {
        return this.m_Instances.size();
    }

    @Override
    public int size() {
        return this.m_Instances.size();
    }

    public void randomize(Random random) {
        for (int j = this.numInstances() - 1; j > 0; --j) {
            this.swap(j, random.nextInt(j + 1));
        }
    }

    @Deprecated
    public boolean readInstance(Reader reader) throws IOException {
        ArffLoader.ArffReader arff = new ArffLoader.ArffReader(reader, this, this.m_Lines, 1, new String[0]);
        Instance inst = arff.readInstance(arff.getData(), false);
        this.m_Lines = arff.getLineNo();
        if (inst != null) {
            this.add(inst);
            return true;
        }
        return false;
    }

    public void replaceAttributeAt(Attribute att, int position) {
        int i;
        Attribute candidate;
        if (position < 0 || position >= this.m_Attributes.size()) {
            throw new IllegalArgumentException("Cannot replace attribute: index out of range");
        }
        if (!att.name().equals(this.m_Attributes.get(position).name()) && (candidate = this.attribute(att.name())) != null) {
            throw new IllegalArgumentException("Cannot replace attribute: name '" + att.name() + "' already in use in the " + Utils.indexToOrdinal(candidate.index()) + " attribute " + candidate);
        }
        att = (Attribute)att.copy();
        att.setIndex(position);
        ArrayList<Attribute> newList = new ArrayList<Attribute>(this.m_Attributes.size());
        HashMap<String, Integer> newMap = new HashMap<String, Integer>((int)((double)(this.m_Attributes.size() + 1) / 0.75));
        for (i = 0; i < position; ++i) {
            Attribute oldAtt = this.m_Attributes.get(i);
            newList.add(oldAtt);
            newMap.put(oldAtt.name(), i);
        }
        newList.add(att);
        newMap.put(att.name(), position);
        for (i = position + 1; i < this.m_Attributes.size(); ++i) {
            Attribute newAtt = this.m_Attributes.get(i);
            newList.add(newAtt);
            newMap.put(newAtt.name(), i);
        }
        this.m_Attributes = newList;
        this.m_NamesToAttributeIndices = newMap;
        for (i = 0; i < this.numInstances(); ++i) {
            this.instance(i).setDataset(null);
            this.instance(i).setMissing(position);
            this.instance(i).setDataset(this);
        }
    }

    public String relationName() {
        return this.m_RelationName;
    }

    @Override
    public Instance remove(int index) {
        return this.m_Instances.remove(index);
    }

    public void renameAttribute(int att, String name) {
        if (att < 0 || att >= this.m_Attributes.size()) {
            throw new IllegalArgumentException("Cannot rename attribute: index out of range");
        }
        Attribute existingAtt = this.attribute(name);
        if (existingAtt != null) {
            if (att == existingAtt.index()) {
                return;
            }
            throw new IllegalArgumentException("Cannot rename attribute: name '" + name + "' already in use in the " + Utils.indexToOrdinal(existingAtt.index()) + " attribute " + existingAtt);
        }
        Attribute newAtt = this.attribute(att).copy(name);
        ArrayList<Attribute> newVec = new ArrayList<Attribute>(this.numAttributes());
        HashMap<String, Integer> newMap = new HashMap<String, Integer>((int)((double)this.numAttributes() / 0.75));
        for (Attribute attr : this.m_Attributes) {
            if (attr.index() == att) {
                newVec.add(newAtt);
                newMap.put(name, att);
                continue;
            }
            newVec.add(attr);
            newMap.put(attr.name(), attr.index());
        }
        this.m_Attributes = newVec;
        this.m_NamesToAttributeIndices = newMap;
    }

    public void setAttributeWeight(Attribute att, double weight) {
        this.setAttributeWeight(att.index(), weight);
    }

    public void setAttributeWeight(int att, double weight) {
        Attribute existingAtt = this.attribute(att);
        if (existingAtt.weight() == weight) {
            return;
        }
        Attribute newAtt = (Attribute)existingAtt.copy();
        newAtt.setWeight(weight);
        ArrayList<Attribute> newVec = new ArrayList<Attribute>(this.numAttributes());
        HashMap<String, Integer> newMap = new HashMap<String, Integer>((int)((double)this.numAttributes() / 0.75));
        for (Attribute attr : this.m_Attributes) {
            if (attr.index() == att) {
                newVec.add(newAtt);
                newMap.put(newAtt.name(), att);
                continue;
            }
            newVec.add(attr);
            newMap.put(attr.name(), attr.index());
        }
        this.m_Attributes = newVec;
        this.m_NamesToAttributeIndices = newMap;
    }

    public void renameAttribute(Attribute att, String name) {
        this.renameAttribute(att.index(), name);
    }

    public void renameAttributeValue(int att, int val, String name) {
        Attribute newAtt = (Attribute)this.attribute(att).copy();
        ArrayList<Attribute> newVec = new ArrayList<Attribute>(this.numAttributes());
        newAtt.setValue(val, name);
        for (Attribute attr : this.m_Attributes) {
            if (attr.index() == att) {
                newVec.add(newAtt);
                continue;
            }
            newVec.add(attr);
        }
        this.m_Attributes = newVec;
    }

    public void renameAttributeValue(Attribute att, String val, String name) {
        int v = att.indexOfValue(val);
        if (v == -1) {
            throw new IllegalArgumentException(val + " not found");
        }
        this.renameAttributeValue(att.index(), v, name);
    }

    public Instances resample(Random random) {
        Instances newData = new Instances(this, this.numInstances());
        while (newData.numInstances() < this.numInstances()) {
            newData.add(this.instance(random.nextInt(this.numInstances())));
        }
        return newData;
    }

    public Instances resampleWithWeights(Random random) {
        return this.resampleWithWeights(random, false);
    }

    public Instances resampleWithWeights(Random random, boolean[] sampled) {
        return this.resampleWithWeights(random, sampled, false);
    }

    public Instances resampleWithWeights(Random random, boolean representUsingWeights) {
        return this.resampleWithWeights(random, null, representUsingWeights);
    }

    public Instances resampleWithWeights(Random random, boolean[] sampled, boolean representUsingWeights) {
        return this.resampleWithWeights(random, sampled, representUsingWeights, 100.0);
    }

    public Instances resampleWithWeights(Random random, boolean[] sampled, boolean representUsingWeights, double sampleSize) {
        double[] weights = new double[this.numInstances()];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = this.instance(i).weight();
        }
        return this.resampleWithWeights(random, weights, sampled, representUsingWeights, sampleSize);
    }

    public Instances resampleWithWeights(Random random, double[] weights) {
        return this.resampleWithWeights(random, weights, null);
    }

    public Instances resampleWithWeights(Random random, double[] weights, boolean[] sampled) {
        return this.resampleWithWeights(random, weights, sampled, false);
    }

    public Instances resampleWithWeights(Random random, double[] weights, boolean[] sampled, boolean representUsingWeights) {
        return this.resampleWithWeights(random, weights, sampled, representUsingWeights, 100.0);
    }

    public Instances resampleWithWeights(Random random, double[] weights, boolean[] sampled, boolean representUsingWeights, double sampleSize) {
        int i;
        int I;
        if (weights.length != this.numInstances()) {
            throw new IllegalArgumentException("weights.length != numInstances.");
        }
        if (sampleSize < 0.0 || sampleSize > 100.0) {
            throw new IllegalArgumentException("Sample size must be a percentage.");
        }
        Instances newData = new Instances(this, this.numInstances());
        if (this.numInstances() == 0) {
            return newData;
        }
        double[] P = new double[weights.length];
        System.arraycopy(weights, 0, P, 0, weights.length);
        Utils.normalize(P);
        double[] Q = new double[weights.length];
        int[] A = new int[weights.length];
        int[] W = new int[weights.length];
        int M = weights.length;
        int NN = -1;
        int NP = M;
        for (I = 0; I < M; ++I) {
            if (P[I] < 0.0) {
                throw new IllegalArgumentException("Weights have to be positive.");
            }
            Q[I] = (double)M * P[I];
            if (Q[I] < 1.0) {
                W[++NN] = I;
                continue;
            }
            W[--NP] = I;
        }
        if (NN > -1 && NP < M) {
            for (int S = 0; S < M - 1; ++S) {
                int J;
                int I2 = W[S];
                A[I2] = J = W[NP];
                int n = J;
                Q[n] = Q[n] + (Q[I2] - 1.0);
                if (Q[J] < 1.0) {
                    ++NP;
                }
                if (NP >= M) break;
            }
        }
        for (I = 0; I < M; ++I) {
            int n = I;
            Q[n] = Q[n] + (double)I;
        }
        int[] counts = null;
        if (representUsingWeights) {
            counts = new int[M];
        }
        int numToBeSampled = (int)((double)this.numInstances() * (sampleSize / 100.0));
        for (i = 0; i < numToBeSampled; ++i) {
            int I3;
            double U = (double)M * random.nextDouble();
            int ALRV = U < Q[I3 = (int)U] ? I3 : A[I3];
            if (representUsingWeights) {
                int n = ALRV;
                counts[n] = counts[n] + 1;
            } else {
                newData.add(this.instance(ALRV));
            }
            if (sampled != null) {
                sampled[ALRV] = true;
            }
            if (representUsingWeights) continue;
            newData.instance(newData.numInstances() - 1).setWeight(1.0);
        }
        if (representUsingWeights) {
            for (i = 0; i < counts.length; ++i) {
                if (counts[i] <= 0) continue;
                newData.add(this.instance(i));
                newData.instance(newData.numInstances() - 1).setWeight(counts[i]);
            }
        }
        return newData;
    }

    @Override
    public Instance set(int index, Instance instance) {
        Instance newInstance = (Instance)instance.copy();
        Instance oldInstance = this.m_Instances.get(index);
        newInstance.setDataset(this);
        this.m_Instances.set(index, newInstance);
        return oldInstance;
    }

    public void setClass(Attribute att) {
        this.m_ClassIndex = att.index();
    }

    public void setClassIndex(int classIndex) {
        if (classIndex >= this.numAttributes()) {
            throw new IllegalArgumentException("Invalid class index: " + classIndex);
        }
        this.m_ClassIndex = classIndex;
    }

    public void setRelationName(String newName) {
        this.m_RelationName = newName;
    }

    protected void sortBasedOnNominalAttribute(int attIndex) {
        int[] counts = new int[this.attribute(attIndex).numValues()];
        Instance[] backup = new Instance[this.numInstances()];
        int j = 0;
        for (Instance inst : this) {
            backup[j++] = inst;
            if (inst.isMissing(attIndex)) continue;
            int n = (int)inst.value(attIndex);
            counts[n] = counts[n] + 1;
        }
        int[] indices = new int[counts.length];
        int start = 0;
        for (int i = 0; i < counts.length; ++i) {
            indices[i] = start;
            start += counts[i];
        }
        for (Instance inst : backup) {
            if (!inst.isMissing(attIndex)) {
                int n = (int)inst.value(attIndex);
                int n2 = indices[n];
                indices[n] = n2 + 1;
                this.m_Instances.set(n2, inst);
                continue;
            }
            this.m_Instances.set(start++, inst);
        }
    }

    public void sort(int attIndex) {
        if (!this.attribute(attIndex).isNominal()) {
            double[] vals = new double[this.numInstances()];
            Instance[] backup = new Instance[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                Instance inst;
                backup[i] = inst = this.instance(i);
                double val = inst.value(attIndex);
                vals[i] = Utils.isMissingValue(val) ? Double.MAX_VALUE : val;
            }
            int[] sortOrder = Utils.sortWithNoMissingValues(vals);
            for (int i = 0; i < vals.length; ++i) {
                this.m_Instances.set(i, backup[sortOrder[i]]);
            }
        } else {
            this.sortBasedOnNominalAttribute(attIndex);
        }
    }

    public void sort(Attribute att) {
        this.sort(att.index());
    }

    public void stableSort(int attIndex) {
        if (!this.attribute(attIndex).isNominal()) {
            double[] vals = new double[this.numInstances()];
            Instance[] backup = new Instance[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                Instance inst;
                backup[i] = inst = this.instance(i);
                vals[i] = inst.value(attIndex);
            }
            int[] sortOrder = Utils.stableSort(vals);
            for (int i = 0; i < vals.length; ++i) {
                this.m_Instances.set(i, backup[sortOrder[i]]);
            }
        } else {
            this.sortBasedOnNominalAttribute(attIndex);
        }
    }

    public void stableSort(Attribute att) {
        this.stableSort(att.index());
    }

    public void stratify(int numFolds) {
        if (numFolds <= 1) {
            throw new IllegalArgumentException("Number of folds must be greater than 1");
        }
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        if (this.classAttribute().isNominal()) {
            for (int index = 1; index < this.numInstances(); ++index) {
                Instance instance1 = this.instance(index - 1);
                for (int j = index; j < this.numInstances(); ++j) {
                    Instance instance2 = this.instance(j);
                    if (instance1.classValue() != instance2.classValue() && (!instance1.classIsMissing() || !instance2.classIsMissing())) continue;
                    this.swap(index, j);
                    ++index;
                }
            }
            this.stratStep(numFolds);
        }
    }

    public double sumOfWeights() {
        double sum = 0.0;
        for (int i = 0; i < this.numInstances(); ++i) {
            sum += this.instance(i).weight();
        }
        return sum;
    }

    public Instances testCV(int numFolds, int numFold) {
        int offset;
        if (numFolds < 2) {
            throw new IllegalArgumentException("Number of folds must be at least 2!");
        }
        if (numFolds > this.numInstances()) {
            throw new IllegalArgumentException("Can't have more folds than instances!");
        }
        int numInstForFold = this.numInstances() / numFolds;
        if (numFold < this.numInstances() % numFolds) {
            ++numInstForFold;
            offset = numFold;
        } else {
            offset = this.numInstances() % numFolds;
        }
        Instances test = new Instances(this, numInstForFold);
        int first = numFold * (this.numInstances() / numFolds) + offset;
        this.copyInstances(first, test, numInstForFold);
        return test;
    }

    @Override
    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(ARFF_RELATION).append(" ").append(Utils.quote(this.m_RelationName)).append("\n\n");
        for (int i = 0; i < this.numAttributes(); ++i) {
            text.append(this.attribute(i)).append("\n");
        }
        text.append("\n").append(ARFF_DATA).append("\n");
        text.append(this.stringWithoutHeader());
        return text.toString();
    }

    protected String stringWithoutHeader() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.numInstances(); ++i) {
            text.append(this.instance(i));
            if (i >= this.numInstances() - 1) continue;
            text.append('\n');
        }
        return text.toString();
    }

    public Instances trainCV(int numFolds, int numFold) {
        int offset;
        if (numFolds < 2) {
            throw new IllegalArgumentException("Number of folds must be at least 2!");
        }
        if (numFolds > this.numInstances()) {
            throw new IllegalArgumentException("Can't have more folds than instances!");
        }
        int numInstForFold = this.numInstances() / numFolds;
        if (numFold < this.numInstances() % numFolds) {
            ++numInstForFold;
            offset = numFold;
        } else {
            offset = this.numInstances() % numFolds;
        }
        Instances train = new Instances(this, this.numInstances() - numInstForFold);
        int first = numFold * (this.numInstances() / numFolds) + offset;
        this.copyInstances(0, train, first);
        this.copyInstances(first + numInstForFold, train, this.numInstances() - first - numInstForFold);
        return train;
    }

    public Instances trainCV(int numFolds, int numFold, Random random) {
        Instances train = this.trainCV(numFolds, numFold);
        train.randomize(random);
        return train;
    }

    public double[] variances() {
        double[] vars = new double[this.numAttributes()];
        for (int i = 0; i < this.numAttributes(); ++i) {
            vars[i] = Double.NaN;
        }
        double[] means = new double[this.numAttributes()];
        double[] sumWeights = new double[this.numAttributes()];
        for (int i = 0; i < this.numInstances(); ++i) {
            double weight = this.instance(i).weight();
            for (int attIndex = 0; attIndex < this.numAttributes(); ++attIndex) {
                if (!this.attribute(attIndex).isNumeric() || this.instance(i).isMissing(attIndex)) continue;
                double value = this.instance(i).value(attIndex);
                if (Double.isNaN(vars[attIndex])) {
                    means[attIndex] = value;
                    sumWeights[attIndex] = weight;
                    vars[attIndex] = 0.0;
                    continue;
                }
                double delta = weight * (value - means[attIndex]);
                int n = attIndex;
                sumWeights[n] = sumWeights[n] + weight;
                int n2 = attIndex;
                means[n2] = means[n2] + delta / sumWeights[attIndex];
                int n3 = attIndex;
                vars[n3] = vars[n3] + delta * (value - means[attIndex]);
            }
        }
        for (int attIndex = 0; attIndex < this.numAttributes(); ++attIndex) {
            if (!this.attribute(attIndex).isNumeric()) continue;
            if (sumWeights[attIndex] <= 1.0) {
                vars[attIndex] = Double.NaN;
                continue;
            }
            int n = attIndex;
            vars[n] = vars[n] / (sumWeights[attIndex] - 1.0);
            if (!(vars[attIndex] < 0.0)) continue;
            vars[attIndex] = 0.0;
        }
        return vars;
    }

    public double variance(int attIndex) {
        if (!this.attribute(attIndex).isNumeric()) {
            throw new IllegalArgumentException("Can't compute variance because attribute is not numeric!");
        }
        double mean = 0.0;
        double var = Double.NaN;
        double sumWeights = 0.0;
        for (int i = 0; i < this.numInstances(); ++i) {
            if (this.instance(i).isMissing(attIndex)) continue;
            double weight = this.instance(i).weight();
            double value = this.instance(i).value(attIndex);
            if (Double.isNaN(var)) {
                mean = value;
                sumWeights = weight;
                var = 0.0;
                continue;
            }
            double delta = weight * (value - mean);
            var += delta * (value - (mean += delta / (sumWeights += weight)));
        }
        if (sumWeights <= 1.0) {
            return Double.NaN;
        }
        if ((var /= sumWeights - 1.0) < 0.0) {
            return 0.0;
        }
        return var;
    }

    public double variance(Attribute att) {
        return this.variance(att.index());
    }

    public AttributeStats attributeStats(int index) {
        AttributeStats result = new AttributeStats();
        if (this.attribute(index).isNominal()) {
            result.nominalCounts = new int[this.attribute(index).numValues()];
            result.nominalWeights = new double[this.attribute(index).numValues()];
        }
        if (this.attribute(index).isNumeric()) {
            result.numericStats = new Stats();
        }
        result.totalCount = this.numInstances();
        HashMap<Double, double[]> map = new HashMap<Double, double[]>(2 * result.totalCount);
        for (Instance instance : this) {
            double key = instance.value(index);
            if (Utils.isMissingValue(key)) {
                ++result.missingCount;
                continue;
            }
            double[] values = (double[])map.get(key);
            if (values == null) {
                values = new double[]{1.0, instance.weight()};
                map.put(key, values);
                continue;
            }
            values[0] = values[0] + 1.0;
            values[1] = values[1] + instance.weight();
        }
        for (Map.Entry entry : map.entrySet()) {
            result.addDistinct((Double)entry.getKey(), (int)((double[])entry.getValue())[0], ((double[])entry.getValue())[1]);
        }
        return result;
    }

    public double[] attributeToDoubleArray(int index) {
        double[] result = new double[this.numInstances()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.instance(i).value(index);
        }
        return result;
    }

    public String toSummaryString() {
        StringBuffer result = new StringBuffer();
        result.append("Relation Name:  ").append(this.relationName()).append('\n');
        result.append("Num Instances:  ").append(this.numInstances()).append('\n');
        result.append("Num Attributes: ").append(this.numAttributes()).append('\n');
        result.append('\n');
        result.append(Utils.padLeft("", 5)).append(Utils.padRight("Name", 25));
        result.append(Utils.padLeft("Type", 5)).append(Utils.padLeft("Nom", 5));
        result.append(Utils.padLeft("Int", 5)).append(Utils.padLeft("Real", 5));
        result.append(Utils.padLeft("Missing", 12));
        result.append(Utils.padLeft("Unique", 12));
        result.append(Utils.padLeft("Dist", 6)).append('\n');
        int numDigits = (int)Math.log10(this.numAttributes()) + 1;
        for (int i = 0; i < this.numAttributes(); ++i) {
            long percent;
            Attribute a2 = this.attribute(i);
            AttributeStats as = this.attributeStats(i);
            result.append(Utils.padLeft("" + (i + 1), numDigits)).append(' ');
            result.append(Utils.padRight(a2.name(), 25)).append(' ');
            switch (a2.type()) {
                case 1: {
                    result.append(Utils.padLeft("Nom", 4)).append(' ');
                    percent = Math.round(100.0 * (double)as.intCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    result.append(Utils.padLeft("0", 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.realCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    break;
                }
                case 0: {
                    result.append(Utils.padLeft("Num", 4)).append(' ');
                    result.append(Utils.padLeft("0", 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.intCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.realCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    break;
                }
                case 3: {
                    result.append(Utils.padLeft("Dat", 4)).append(' ');
                    result.append(Utils.padLeft("0", 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.intCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.realCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    break;
                }
                case 2: {
                    result.append(Utils.padLeft("Str", 4)).append(' ');
                    percent = Math.round(100.0 * (double)as.intCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    result.append(Utils.padLeft("0", 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.realCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    break;
                }
                case 4: {
                    result.append(Utils.padLeft("Rel", 4)).append(' ');
                    percent = Math.round(100.0 * (double)as.intCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    result.append(Utils.padLeft("0", 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.realCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    break;
                }
                default: {
                    result.append(Utils.padLeft("???", 4)).append(' ');
                    result.append(Utils.padLeft("0", 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.intCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.realCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                }
            }
            result.append(Utils.padLeft("" + as.missingCount, 5)).append(" /");
            percent = Math.round(100.0 * (double)as.missingCount / (double)as.totalCount);
            result.append(Utils.padLeft("" + percent, 3)).append("% ");
            result.append(Utils.padLeft("" + as.uniqueCount, 5)).append(" /");
            percent = Math.round(100.0 * (double)as.uniqueCount / (double)as.totalCount);
            result.append(Utils.padLeft("" + percent, 3)).append("% ");
            result.append(Utils.padLeft("" + as.distinctCount, 5)).append(' ');
            result.append('\n');
        }
        return result.toString();
    }

    protected void copyInstances(int from, Instances dest, int num) {
        for (int i = 0; i < num; ++i) {
            dest.add(this.instance(from + i));
        }
    }

    protected String instancesAndWeights() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.numInstances(); ++i) {
            text.append(this.instance(i) + " " + this.instance(i).weight());
            if (i >= this.numInstances() - 1) continue;
            text.append("\n");
        }
        return text.toString();
    }

    protected void stratStep(int numFolds) {
        ArrayList<Instance> newVec = new ArrayList<Instance>(this.m_Instances.size());
        int start = 0;
        while (newVec.size() < this.numInstances()) {
            for (int j = start; j < this.numInstances(); j += numFolds) {
                newVec.add(this.instance(j));
            }
            ++start;
        }
        this.m_Instances = newVec;
    }

    public void swap(int i, int j) {
        Instance in = this.m_Instances.get(i);
        this.m_Instances.set(i, this.m_Instances.get(j));
        this.m_Instances.set(j, in);
    }

    public static Instances mergeInstances(Instances first, Instances second) {
        if (first.numInstances() != second.numInstances()) {
            throw new IllegalArgumentException("Instance sets must be of the same size");
        }
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>(first.numAttributes() + second.numAttributes());
        for (Attribute att : first.m_Attributes) {
            newAttributes.add(att);
        }
        for (Attribute att : second.m_Attributes) {
            newAttributes.add((Attribute)att.copy());
        }
        Instances merged = new Instances(first.relationName() + '_' + second.relationName(), newAttributes, first.numInstances());
        for (int i = 0; i < first.numInstances(); ++i) {
            merged.add(first.instance(i).mergeInstance(second.instance(i)));
        }
        return merged;
    }

    public static void test(String[] argv) {
        Random random = new Random(2L);
        try {
            int j;
            int i;
            if (argv.length > 1) {
                throw new Exception("Usage: Instances [<filename>]");
            }
            ArrayList<String> testVals = new ArrayList<String>(2);
            testVals.add("first_value");
            testVals.add("second_value");
            ArrayList<Attribute> testAtts = new ArrayList<Attribute>(2);
            testAtts.add(new Attribute("nominal_attribute", testVals));
            testAtts.add(new Attribute("numeric_attribute"));
            Instances instances = new Instances("test_set", testAtts, 10);
            instances.add(new DenseInstance(instances.numAttributes()));
            instances.add(new DenseInstance(instances.numAttributes()));
            instances.add(new DenseInstance(instances.numAttributes()));
            instances.setClassIndex(0);
            System.out.println("\nSet of instances created from scratch:\n");
            System.out.println(instances);
            if (argv.length == 1) {
                String filename = argv[0];
                FileReader reader = new FileReader(filename);
                System.out.println("\nFirst five instances from file:\n");
                instances = new Instances(reader, 1);
                instances.setClassIndex(instances.numAttributes() - 1);
                for (i = 0; i < 5 && instances.readInstance(reader); ++i) {
                }
                System.out.println(instances);
                reader = new FileReader(filename);
                instances = new Instances(reader);
                instances.setClassIndex(instances.numAttributes() - 1);
                System.out.println("\nDataset:\n");
                System.out.println(instances);
                System.out.println("\nClass index: " + instances.classIndex());
            }
            System.out.println("\nClass name: " + instances.classAttribute().name());
            System.out.println("\nClass index: " + instances.classIndex());
            System.out.println("\nClass is nominal: " + instances.classAttribute().isNominal());
            System.out.println("\nClass is numeric: " + instances.classAttribute().isNumeric());
            System.out.println("\nClasses:\n");
            for (i = 0; i < instances.numClasses(); ++i) {
                System.out.println(instances.classAttribute().value(i));
            }
            System.out.println("\nClass values and labels of instances:\n");
            for (i = 0; i < instances.numInstances(); ++i) {
                Instance inst = instances.instance(i);
                System.out.print(inst.classValue() + "\t");
                System.out.print(inst.toString(inst.classIndex()));
                if (instances.instance(i).classIsMissing()) {
                    System.out.println("\tis missing");
                    continue;
                }
                System.out.println();
            }
            System.out.println("\nCreating random weights for instances.");
            for (i = 0; i < instances.numInstances(); ++i) {
                instances.instance(i).setWeight(random.nextDouble());
            }
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(instances.sumOfWeights());
            Instances secondInstances = new Instances(instances);
            Attribute testAtt = new Attribute("Inserted");
            secondInstances.insertAttributeAt(testAtt, 0);
            System.out.println("\nSet with inserted attribute:\n");
            System.out.println(secondInstances);
            System.out.println("\nClass name: " + secondInstances.classAttribute().name());
            secondInstances.deleteAttributeAt(0);
            System.out.println("\nSet with attribute deleted:\n");
            System.out.println(secondInstances);
            System.out.println("\nClass name: " + secondInstances.classAttribute().name());
            System.out.println("\nHeaders equal: " + instances.equalHeaders(secondInstances) + "\n");
            System.out.println("\nData (internal values):\n");
            for (i = 0; i < instances.numInstances(); ++i) {
                for (j = 0; j < instances.numAttributes(); ++j) {
                    if (instances.instance(i).isMissing(j)) {
                        System.out.print("? ");
                        continue;
                    }
                    System.out.print(instances.instance(i).value(j) + " ");
                }
                System.out.println();
            }
            System.out.println("\nEmpty dataset:\n");
            Instances empty = new Instances(instances, 0);
            System.out.println(empty);
            System.out.println("\nClass name: " + empty.classAttribute().name());
            if (empty.classAttribute().isNominal()) {
                Instances copy = new Instances(empty, 0);
                copy.renameAttribute(copy.classAttribute(), "new_name");
                copy.renameAttributeValue(copy.classAttribute(), copy.classAttribute().value(0), "new_val_name");
                System.out.println("\nDataset with names changed:\n" + copy);
                System.out.println("\nOriginal dataset:\n" + empty);
            }
            int start = instances.numInstances() / 4;
            int num = instances.numInstances() / 2;
            System.out.print("\nSubset of dataset: ");
            System.out.println(num + " instances from " + (start + 1) + ". instance");
            secondInstances = new Instances(instances, start, num);
            System.out.println("\nClass name: " + secondInstances.classAttribute().name());
            System.out.println("\nInstances and their weights:\n");
            System.out.println(secondInstances.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(secondInstances.sumOfWeights());
            System.out.println("\nTrain and test folds for 3-fold CV:");
            if (instances.classAttribute().isNominal()) {
                instances.stratify(3);
            }
            for (j = 0; j < 3; ++j) {
                Instances train = instances.trainCV(3, j, new Random(1L));
                Instances test = instances.testCV(3, j);
                System.out.println("\nTrain: ");
                System.out.println("\nInstances and their weights:\n");
                System.out.println(train.instancesAndWeights());
                System.out.print("\nSum of weights: ");
                System.out.println(train.sumOfWeights());
                System.out.println("\nClass name: " + train.classAttribute().name());
                System.out.println("\nTest: ");
                System.out.println("\nInstances and their weights:\n");
                System.out.println(test.instancesAndWeights());
                System.out.print("\nSum of weights: ");
                System.out.println(test.sumOfWeights());
                System.out.println("\nClass name: " + test.classAttribute().name());
            }
            System.out.println("\nRandomized dataset:");
            instances.randomize(random);
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(instances.sumOfWeights());
            System.out.print("\nInstances sorted according to first attribute:\n ");
            instances.sort(0);
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(instances.sumOfWeights());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                ConverterUtils.DataSource source = new ConverterUtils.DataSource(System.in);
                Instances i = source.getDataSet();
                System.out.println(i.toSummaryString());
            } else if (args.length == 1 && !args[0].equals("-h") && !args[0].equals("help")) {
                ConverterUtils.DataSource source = new ConverterUtils.DataSource(args[0]);
                Instances i = source.getDataSet();
                System.out.println(i.toSummaryString());
            } else if (args.length == 3 && args[0].toLowerCase().equals("merge")) {
                ConverterUtils.DataSource source1 = new ConverterUtils.DataSource(args[1]);
                ConverterUtils.DataSource source2 = new ConverterUtils.DataSource(args[2]);
                Instances i = Instances.mergeInstances(source1.getDataSet(), source2.getDataSet());
                System.out.println(i);
            } else if (args.length == 3 && args[0].toLowerCase().equals("append")) {
                ConverterUtils.DataSource source1 = new ConverterUtils.DataSource(args[1]);
                ConverterUtils.DataSource source2 = new ConverterUtils.DataSource(args[2]);
                String msg = source1.getStructure().equalHeadersMsg(source2.getStructure());
                if (msg != null) {
                    throw new Exception("The two datasets have different headers:\n" + msg);
                }
                Instances structure = source1.getStructure();
                System.out.println(source1.getStructure());
                while (source1.hasMoreElements(structure)) {
                    System.out.println(source1.nextElement(structure));
                }
                structure = source2.getStructure();
                while (source2.hasMoreElements(structure)) {
                    System.out.println(source2.nextElement(structure));
                }
            } else if (args.length == 3 && args[0].toLowerCase().equals("headers")) {
                ConverterUtils.DataSource source1 = new ConverterUtils.DataSource(args[1]);
                ConverterUtils.DataSource source2 = new ConverterUtils.DataSource(args[2]);
                String msg = source1.getStructure().equalHeadersMsg(source2.getStructure());
                if (msg == null) {
                    System.out.println("Headers match");
                } else {
                    System.out.println("Headers don't match:\n" + msg);
                }
            } else if (args.length == 3 && args[0].toLowerCase().equals("randomize")) {
                ConverterUtils.DataSource source = new ConverterUtils.DataSource(args[2]);
                Instances i = source.getDataSet();
                i.randomize(new Random(Integer.parseInt(args[1])));
                System.out.println(i);
            } else {
                System.err.println("\nUsage:\n\tweka.core.Instances help\n\t\tPrints this help\n\tweka.core.Instances <filename>\n\t\tOutputs dataset statistics\n\tweka.core.Instances merge <filename1> <filename2>\n\t\tMerges the datasets (must have same number of rows).\n\t\tGenerated dataset gets output on stdout.\n\tweka.core.Instances append <filename1> <filename2>\n\t\tAppends the second dataset to the first (must have same number of attributes).\n\t\tGenerated dataset gets output on stdout.\n\tweka.core.Instances headers <filename1> <filename2>\n\t\tCompares the structure of the two datasets and outputs whether they\n\t\tdiffer or not.\n\tweka.core.Instances randomize <seed> <filename>\n\t\tRandomizes the dataset and outputs it on stdout.\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15570 $");
    }
}

