/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import weka.classifiers.bayes.NaiveBayes;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.estimators.Estimator;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.ProgrammaticProperty;

public class ClassConditionalProbabilities
extends SimpleBatchFilter
implements WeightedAttributesHandler,
WeightedInstancesHandler {
    private static final long serialVersionUID = 1684310720200284263L;
    protected boolean m_excludeNumericAttributes;
    protected boolean m_excludeNominalAttributes;
    protected int m_nominalConversionThreshold = -1;
    protected NaiveBayes m_estimator;
    protected Remove m_remove;
    protected Instances m_unchanged;
    protected Map<String, Estimator[]> m_estimatorLookup;
    protected boolean m_SpreadAttributeWeight = false;

    public static void main(String[] args) {
        ClassConditionalProbabilities.runFilter(new ClassConditionalProbabilities(), args);
    }

    @Override
    public String globalInfo() {
        return "Converts the values of nominal and/or numeric attributes into class conditional probabilities. If there are k classes, then k new attributes are created for each of the original ones, giving pr(att val | class k).\n\nCan be useful for converting nominal attributes with a lot of distinct values into something more manageable for learning schemes that can't handle nominal attributes (as opposed to creating binary indicator attributes). For nominal attributes, the user can specify the number values above which an attribute will be converted by this method. Normal distributions are assumed for numeric attributes.";
    }

    @OptionMetadata(displayName="Exclude numeric attributes", description="Don't apply this transformation to numeric attributes", commandLineParamName="N", commandLineParamIsFlag=true, commandLineParamSynopsis="-N", displayOrder=1)
    public boolean getExcludeNumericAttributes() {
        return this.m_excludeNumericAttributes;
    }

    public void setExcludeNumericAttributes(boolean e) {
        this.m_excludeNumericAttributes = e;
    }

    @OptionMetadata(displayName="Exclude nominal attributes", description="Don't apply this transformation to nominal attributes", commandLineParamName="C", commandLineParamIsFlag=true, commandLineParamSynopsis="-C", displayOrder=2)
    public boolean getExcludeNominalAttributes() {
        return this.m_excludeNominalAttributes;
    }

    public void setExcludeNominalAttributes(boolean e) {
        this.m_excludeNominalAttributes = e;
    }

    @OptionMetadata(displayName="Spread weight across new attributes", description="When generating attributes, spread weight of old\nattribute across new attributes. Do not give each new attribute the old weight.", commandLineParamName="spread-attribute-weight", commandLineParamIsFlag=true, commandLineParamSynopsis="-spread-attribute-weight", displayOrder=3)
    public void setSpreadAttributeWeight(boolean p) {
        this.m_SpreadAttributeWeight = p;
    }

    public boolean getSpreadAttributeWeight() {
        return this.m_SpreadAttributeWeight;
    }

    @OptionMetadata(displayName="Nominal conversion threshold", description="Transform nominal attributes with at least this many values.\n-1 means always transform.", commandLineParamName="min-values", commandLineParamSynopsis="-min-values <integer>", displayOrder=3)
    public int getNominalConversionThreshold() {
        return this.m_nominalConversionThreshold;
    }

    public void setNominalConversionThreshold(int n) {
        this.m_nominalConversionThreshold = n;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        if (this.m_excludeNominalAttributes && this.m_excludeNumericAttributes) {
            throw new Exception("No transformation will be done if both nominal and numeric attributes are excluded!");
        }
        if (this.m_remove == null) {
            int i;
            ArrayList<Integer> attsToExclude = new ArrayList<Integer>();
            if (this.m_excludeNumericAttributes) {
                for (i = 0; i < inputFormat.numAttributes(); ++i) {
                    if (!inputFormat.attribute(i).isNumeric() || i == inputFormat.classIndex()) continue;
                    attsToExclude.add(i);
                }
            }
            if (this.m_excludeNominalAttributes || this.m_nominalConversionThreshold > 1) {
                for (i = 0; i < inputFormat.numAttributes(); ++i) {
                    if (!inputFormat.attribute(i).isNominal() || i == inputFormat.classIndex() || !this.m_excludeNominalAttributes && inputFormat.attribute(i).numValues() >= this.m_nominalConversionThreshold) continue;
                    attsToExclude.add(i);
                }
            }
            if (attsToExclude.size() > 0) {
                int[] r = new int[attsToExclude.size()];
                for (int i2 = 0; i2 < attsToExclude.size(); ++i2) {
                    r[i2] = (Integer)attsToExclude.get(i2);
                }
                this.m_remove = new Remove();
                this.m_remove.setAttributeIndicesArray(r);
                this.m_remove.setInputFormat(inputFormat);
                Remove forRetaining = new Remove();
                forRetaining.setAttributeIndicesArray(r);
                forRetaining.setInvertSelection(true);
                forRetaining.setInputFormat(inputFormat);
                this.m_unchanged = Filter.useFilter(inputFormat, forRetaining);
            }
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (i == inputFormat.classIndex()) continue;
            if (this.m_unchanged != null && this.m_unchanged.attribute(inputFormat.attribute(i).name()) != null) {
                atts.add((Attribute)this.m_unchanged.attribute(inputFormat.attribute(i).name()).copy());
                continue;
            }
            for (int j = 0; j < inputFormat.classAttribute().numValues(); ++j) {
                String name = "pr_" + inputFormat.attribute(i).name() + "|" + inputFormat.classAttribute().value(j);
                Attribute a2 = new Attribute(name);
                if (this.getSpreadAttributeWeight()) {
                    a2.setWeight(inputFormat.attribute(i).weight() / (double)inputFormat.classAttribute().numValues());
                } else {
                    a2.setWeight(inputFormat.attribute(i).weight());
                }
                atts.add(a2);
            }
        }
        atts.add((Attribute)inputFormat.classAttribute().copy());
        Instances data = new Instances(inputFormat.relationName(), atts, 0);
        data.setClassIndex(data.numAttributes() - 1);
        return data;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        if (this.m_estimator == null) {
            this.m_estimator = new NaiveBayes();
            Instances trainingData = new Instances(instances);
            if (this.m_remove != null) {
                trainingData = Filter.useFilter(instances, this.m_remove);
            }
            this.m_estimator.buildClassifier(trainingData);
        }
        if (this.m_estimatorLookup == null) {
            this.m_estimatorLookup = new HashMap<String, Estimator[]>();
            Estimator[][] estimators = this.m_estimator.getConditionalEstimators();
            Instances header = this.m_estimator.getHeader();
            int index = 0;
            for (int i = 0; i < header.numAttributes(); ++i) {
                if (i == header.classIndex()) continue;
                this.m_estimatorLookup.put(header.attribute(i).name(), estimators[index]);
                ++index;
            }
        }
        Instances result = new Instances(this.getOutputFormat(), instances.numInstances());
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance current = instances.instance(i);
            Instance instNew = this.convertInstance(current);
            result.add(instNew);
        }
        return result;
    }

    protected Instance convertInstance(Instance current) throws Exception {
        double[] vals = new double[this.getOutputFormat().numAttributes()];
        int index = 0;
        for (int j = 0; j < current.numAttributes(); ++j) {
            if (j == current.classIndex()) continue;
            if (this.m_unchanged != null && this.m_unchanged.attribute(current.attribute(j).name()) != null) {
                vals[index++] = current.value(j);
                continue;
            }
            Estimator[] estForAtt = this.m_estimatorLookup.get(current.attribute(j).name());
            for (int k = 0; k < current.classAttribute().numValues(); ++k) {
                if (current.isMissing(j)) {
                    vals[index++] = Utils.missingValue();
                    continue;
                }
                double e = estForAtt[k].getProbability(current.value(j));
                vals[index++] = e;
            }
        }
        vals[vals.length - 1] = current.classValue();
        DenseInstance instNew = new DenseInstance(current.weight(), vals);
        return instNew;
    }

    @Override
    public boolean input(Instance inst) throws Exception {
        if (!this.isFirstBatchDone()) {
            return super.input(inst);
        }
        Instance converted = this.convertInstance(inst);
        this.push(converted);
        return true;
    }

    @Override
    public Capabilities getCapabilities() {
        return new NaiveBayes().getCapabilities();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: $");
    }

    @ProgrammaticProperty
    public NaiveBayes getEstimator() {
        return this.m_estimator;
    }

    public void setEstimator(NaiveBayes nb) {
        this.m_estimator = nb;
    }

    @ProgrammaticProperty
    public Remove getRemoveFilter() {
        return this.m_remove;
    }

    public void setRemoveFilter(Remove r) {
        this.m_remove = r;
        this.m_unchanged = r.getOutputFormat();
    }
}

