/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;

public class CartesianProduct
extends SimpleBatchFilter {
    private static final long serialVersionUID = -227979753639722020L;
    protected Range m_Attributes = new Range("");

    @Override
    public String globalInfo() {
        return "A filter for performing the Cartesian product of a set of nominal attributes. The weight of the new Cartesian product attribute is the sum of the weights of the combined attributes.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSpecifies list of nominal attributes to use to form the product.\n\t(default none)", "R", 1, "-R <col1,col2-col4,...>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption("R", options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices("");
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (!this.getAttributeIndices().equals("")) {
            result.add("-R");
            result.add(this.getAttributeIndices());
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on;  this is a comma separated list of attribute indices, with \"first\" and \"last\" valid values; specify an inclusive range with \"-\", eg: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_Attributes.getRanges();
    }

    public void setAttributeIndices(String value) {
        this.m_Attributes.setRanges(value);
    }

    public void setAttributeIndicesArray(int[] value) {
        this.setAttributeIndices(Range.indicesToRangeList(value));
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllAttributes();
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_Attributes.setUpper(inputFormat.numAttributes() - 1);
        ArrayList<Attribute> atts = new ArrayList<Attribute>(inputFormat.numAttributes() + 1);
        ArrayList<String> values = new ArrayList<String>();
        String name = "";
        double sumOfWeights = 0.0;
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            atts.add(inputFormat.attribute(i));
            if (!inputFormat.attribute(i).isNominal() || !this.m_Attributes.isInRange(i) || i == inputFormat.classIndex()) continue;
            sumOfWeights += inputFormat.attribute(i).weight();
            if (values.size() == 0) {
                values = new ArrayList(inputFormat.attribute(i).numValues());
                for (int j = 0; j < inputFormat.attribute(i).numValues(); ++j) {
                    values.add(inputFormat.attribute(i).value(j));
                }
                name = inputFormat.attribute(i).name();
                continue;
            }
            ArrayList<String> newValues = new ArrayList<String>(values.size() * inputFormat.attribute(i).numValues());
            for (String value : values) {
                for (int j = 0; j < inputFormat.attribute(i).numValues(); ++j) {
                    newValues.add(value + "_x_" + inputFormat.attribute(i).value(j));
                }
            }
            name = name + "_x_" + inputFormat.attribute(i).name();
            values = newValues;
        }
        if (values.size() > 0) {
            Attribute a2 = new Attribute(name, values);
            a2.setWeight(sumOfWeights);
            atts.add(a2);
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        result.setClassIndex(inputFormat.classIndex());
        return result;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        Instances result = this.getOutputFormat();
        for (Instance inst : instances) {
            if (instances.numAttributes() < result.numAttributes()) {
                double[] newVals = new double[result.numAttributes()];
                for (int i = 0; i < inst.numValues(); ++i) {
                    newVals[inst.index((int)i)] = inst.valueSparse(i);
                }
                String value = "";
                for (int i = 0; i < inst.numAttributes(); ++i) {
                    if (!instances.attribute(i).isNominal() || !this.m_Attributes.isInRange(i) || i == instances.classIndex()) continue;
                    if (Utils.isMissingValue(newVals[i])) {
                        value = null;
                        break;
                    }
                    value = value + (value.length() > 0 ? "_x_" + instances.attribute(i).value((int)newVals[i]) : instances.attribute(i).value((int)newVals[i]));
                }
                newVals[newVals.length - 1] = value == null ? Double.NaN : (double)result.attribute(result.numAttributes() - 1).indexOfValue(value);
                Instance newInst = inst.copy(newVals);
                this.copyValues(newInst, false, inst.dataset(), result);
                result.add(newInst);
                continue;
            }
            this.copyValues(inst, false, inst.dataset(), result);
            result.add(inst);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12037 $");
    }

    public static void main(String[] args) {
        CartesianProduct.runFilter(new CartesianProduct(), args);
    }
}

