/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.streams;

import java.io.Serializable;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.streams.InstanceEvent;
import weka.gui.streams.InstanceListener;
import weka.gui.streams.InstanceProducer;
import weka.gui.streams.SerialInstanceListener;

public class InstanceJoiner
implements Serializable,
InstanceProducer,
SerialInstanceListener {
    private static final long serialVersionUID = -6529972700291329656L;
    private final Vector<InstanceListener> listeners = new Vector();
    private boolean b_Debug = false;
    protected Instances m_InputFormat = null;
    private Instance m_OutputInstance = null;
    private boolean b_FirstInputFinished = false;

    public boolean inputFormat(Instances instanceInfo) {
        this.m_InputFormat = new Instances(instanceInfo, 0);
        this.notifyInstanceProduced(new InstanceEvent(this, 1));
        this.b_FirstInputFinished = false;
        return true;
    }

    @Override
    public Instances outputFormat() throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No output format defined.");
        }
        return new Instances(this.m_InputFormat, 0);
    }

    public boolean input(Instance instance) throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (instance != null) {
            this.m_OutputInstance = (Instance)instance.copy();
            this.notifyInstanceProduced(new InstanceEvent(this, 2));
            return true;
        }
        return false;
    }

    public void batchFinished() throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        this.notifyInstanceProduced(new InstanceEvent(this, 3));
    }

    @Override
    public Instance outputPeek() throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No output instance format defined");
        }
        if (this.m_OutputInstance == null) {
            return null;
        }
        return (Instance)this.m_OutputInstance.copy();
    }

    public void setDebug(boolean debug) {
        this.b_Debug = debug;
    }

    public boolean getDebug() {
        return this.b_Debug;
    }

    @Override
    public synchronized void addInstanceListener(InstanceListener ipl) {
        this.listeners.addElement(ipl);
    }

    @Override
    public synchronized void removeInstanceListener(InstanceListener ipl) {
        this.listeners.removeElement(ipl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceProduced(InstanceEvent e) {
        if (this.listeners.size() > 0) {
            Vector l;
            if (this.b_Debug) {
                System.err.println(this.getClass().getName() + "::notifyInstanceProduced()");
            }
            InstanceJoiner instanceJoiner = this;
            synchronized (instanceJoiner) {
                l = (Vector)this.listeners.clone();
            }
            for (int i = 0; i < l.size(); ++i) {
                ((InstanceListener)l.elementAt(i)).instanceProduced(e);
            }
            try {
                if (e.getID() == 2) {
                    this.m_OutputInstance = null;
                }
            }
            catch (Exception ex) {
                System.err.println("Problem: notifyInstanceProduced() was\ncalled with INSTANCE_AVAILABLE, but output()\nthrew an exception: " + ex.getMessage());
            }
        }
    }

    public void instanceProduced(InstanceEvent e) {
        Object source = e.getSource();
        if (source instanceof InstanceProducer) {
            try {
                InstanceProducer a2 = (InstanceProducer)source;
                switch (e.getID()) {
                    case 1: {
                        if (this.b_Debug) {
                            System.err.println(this.getClass().getName() + "::firstInstanceProduced() - Format available");
                        }
                        this.inputFormat(a2.outputFormat());
                        break;
                    }
                    case 2: {
                        if (this.b_Debug) {
                            System.err.println(this.getClass().getName() + "::firstInstanceProduced() - Instance available");
                        }
                        this.input(a2.outputPeek());
                        break;
                    }
                    case 3: {
                        if (this.b_Debug) {
                            System.err.println(this.getClass().getName() + "::firstInstanceProduced() - End of instance batch");
                        }
                        this.batchFinished();
                        this.b_FirstInputFinished = true;
                        break;
                    }
                    default: {
                        System.err.println(this.getClass().getName() + "::firstInstanceProduced() - unknown event type");
                        break;
                    }
                }
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        } else {
            System.err.println(this.getClass().getName() + "::firstInstanceProduced() - Unknown source object type");
        }
    }

    @Override
    public void secondInstanceProduced(InstanceEvent e) {
        Object source = e.getSource();
        if (source instanceof InstanceProducer) {
            try {
                if (!this.b_FirstInputFinished) {
                    throw new Exception(this.getClass().getName() + "::secondInstanceProduced() - Input received from second stream before first stream finished");
                }
                InstanceProducer a2 = (InstanceProducer)source;
                switch (e.getID()) {
                    case 1: {
                        if (this.b_Debug) {
                            System.err.println(this.getClass().getName() + "::secondInstanceProduced() - Format available");
                        }
                        if (!a2.outputFormat().equalHeaders(this.outputFormat())) {
                            throw new Exception(this.getClass().getName() + "::secondInstanceProduced() - incompatible instance streams\n" + a2.outputFormat().equalHeadersMsg(this.outputFormat()));
                        }
                        break;
                    }
                    case 2: {
                        if (this.b_Debug) {
                            System.err.println(this.getClass().getName() + "::secondInstanceProduced() - Instance available");
                        }
                        this.input(a2.outputPeek());
                        break;
                    }
                    case 3: {
                        if (this.b_Debug) {
                            System.err.println(this.getClass().getName() + "::secondInstanceProduced() - End of instance batch");
                        }
                        this.batchFinished();
                        break;
                    }
                    default: {
                        System.err.println(this.getClass().getName() + "::secondInstanceProduced() - unknown event type");
                        break;
                    }
                }
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        } else {
            System.err.println(this.getClass().getName() + "::secondInstanceProduced() - Unknown source object type");
        }
    }
}

