/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.treevisualizer;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.logging.Logger;
import weka.gui.treevisualizer.Edge;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeDisplayEvent;
import weka.gui.treevisualizer.TreeDisplayListener;
import weka.gui.visualize.PrintablePanel;
import weka.gui.visualize.VisualizePanel;
import weka.gui.visualize.VisualizeUtils;

public class TreeVisualizer
extends PrintablePanel
implements MouseMotionListener,
MouseListener,
ActionListener,
ItemListener {
    private static final long serialVersionUID = -8668637962504080749L;
    public static final String PROPERTIES_FILE = "weka/gui/treevisualizer/TreeVisualizer.props";
    private final NodePlace m_placer;
    private final Node m_topNode;
    private final Dimension m_viewPos;
    private final Dimension m_viewSize;
    private Font m_currentFont;
    private FontMetrics m_fontSize;
    private final int m_numNodes;
    private final int m_numLevels;
    private final NodeInfo[] m_nodes;
    private final EdgeInfo[] m_edges;
    private final Timer m_frameLimiter;
    private int m_mouseState;
    private final Dimension m_oldMousePos;
    private final Dimension m_newMousePos;
    private boolean m_clickAvailable;
    private final Dimension m_nViewPos;
    private final Dimension m_nViewSize;
    private int m_scaling;
    private final JPopupMenu m_winMenu;
    private final JMenuItem m_topN;
    private final JMenuItem m_fitToScreen;
    private final JMenuItem m_autoScale;
    private final JMenu m_selectFont;
    private final ButtonGroup m_selectFontGroup;
    private final JRadioButtonMenuItem m_size24;
    private final JRadioButtonMenuItem m_size22;
    private final JRadioButtonMenuItem m_size20;
    private final JRadioButtonMenuItem m_size18;
    private final JRadioButtonMenuItem m_size16;
    private final JRadioButtonMenuItem m_size14;
    private final JRadioButtonMenuItem m_size12;
    private final JRadioButtonMenuItem m_size10;
    private final JRadioButtonMenuItem m_size8;
    private final JRadioButtonMenuItem m_size6;
    private final JRadioButtonMenuItem m_size4;
    private final JRadioButtonMenuItem m_size2;
    private final JRadioButtonMenuItem m_size1;
    private final JMenuItem m_accept;
    private final JPopupMenu m_nodeMenu;
    private final JMenuItem m_visualise;
    private JMenuItem m_remChildren;
    private JMenuItem m_classifyChild;
    private JMenuItem m_sendInstances;
    private int m_focusNode;
    private int m_highlightNode;
    private final TreeDisplayListener m_listener;
    protected Color m_FontColor = null;
    protected Color m_BackgroundColor = null;
    protected Color m_NodeColor = null;
    protected Color m_LineColor = null;
    protected Color m_ZoomBoxColor = null;
    protected Color m_ZoomBoxXORColor = null;
    protected boolean m_ShowBorder = true;

    public TreeVisualizer(TreeDisplayListener tdl, String dot, NodePlace p) {
        this.initialize();
        if (this.m_ShowBorder) {
            this.setBorder(BorderFactory.createTitledBorder("Tree View"));
        }
        this.m_listener = tdl;
        TreeBuild builder = new TreeBuild();
        Node n = null;
        n = builder.create(new StringReader(dot));
        this.m_highlightNode = 5;
        this.m_topNode = n;
        this.m_placer = p;
        this.m_placer.place(this.m_topNode);
        this.m_viewPos = new Dimension(0, 0);
        this.m_viewSize = new Dimension(800, 600);
        this.m_nViewPos = new Dimension(0, 0);
        this.m_nViewSize = new Dimension(800, 600);
        this.m_scaling = 0;
        this.m_numNodes = Node.getCount(this.m_topNode, 0);
        this.m_numLevels = Node.getHeight(this.m_topNode, 0);
        this.m_nodes = new NodeInfo[this.m_numNodes];
        this.m_edges = new EdgeInfo[this.m_numNodes - 1];
        this.arrayFill(this.m_topNode, this.m_nodes, this.m_edges);
        this.changeFontSize(12);
        this.m_mouseState = 0;
        this.m_oldMousePos = new Dimension(0, 0);
        this.m_newMousePos = new Dimension(0, 0);
        this.m_frameLimiter = new Timer(120, this);
        this.m_winMenu = new JPopupMenu();
        this.m_topN = new JMenuItem("Center on Top Node");
        this.m_topN.setActionCommand("Center on Top Node");
        this.m_fitToScreen = new JMenuItem("Fit to Screen");
        this.m_fitToScreen.setActionCommand("Fit to Screen");
        this.m_selectFont = new JMenu("Select Font");
        this.m_selectFont.setActionCommand("Select Font");
        this.m_autoScale = new JMenuItem("Auto Scale");
        this.m_autoScale.setActionCommand("Auto Scale");
        this.m_selectFontGroup = new ButtonGroup();
        this.m_accept = new JMenuItem("Accept The Tree");
        this.m_accept.setActionCommand("Accept The Tree");
        this.m_winMenu.add(this.m_topN);
        this.m_winMenu.addSeparator();
        this.m_winMenu.add(this.m_fitToScreen);
        this.m_winMenu.add(this.m_autoScale);
        this.m_winMenu.addSeparator();
        this.m_winMenu.add(this.m_selectFont);
        if (this.m_listener != null) {
            this.m_winMenu.addSeparator();
            this.m_winMenu.add(this.m_accept);
        }
        this.m_topN.addActionListener(this);
        this.m_fitToScreen.addActionListener(this);
        this.m_autoScale.addActionListener(this);
        this.m_accept.addActionListener(this);
        this.m_size24 = new JRadioButtonMenuItem("Size 24", false);
        this.m_size22 = new JRadioButtonMenuItem("Size 22", false);
        this.m_size20 = new JRadioButtonMenuItem("Size 20", false);
        this.m_size18 = new JRadioButtonMenuItem("Size 18", false);
        this.m_size16 = new JRadioButtonMenuItem("Size 16", false);
        this.m_size14 = new JRadioButtonMenuItem("Size 14", false);
        this.m_size12 = new JRadioButtonMenuItem("Size 12", true);
        this.m_size10 = new JRadioButtonMenuItem("Size 10", false);
        this.m_size8 = new JRadioButtonMenuItem("Size 8", false);
        this.m_size6 = new JRadioButtonMenuItem("Size 6", false);
        this.m_size4 = new JRadioButtonMenuItem("Size 4", false);
        this.m_size2 = new JRadioButtonMenuItem("Size 2", false);
        this.m_size1 = new JRadioButtonMenuItem("Size 1", false);
        this.m_size24.setActionCommand("Size 24");
        this.m_size22.setActionCommand("Size 22");
        this.m_size20.setActionCommand("Size 20");
        this.m_size18.setActionCommand("Size 18");
        this.m_size16.setActionCommand("Size 16");
        this.m_size14.setActionCommand("Size 14");
        this.m_size12.setActionCommand("Size 12");
        this.m_size10.setActionCommand("Size 10");
        this.m_size8.setActionCommand("Size 8");
        this.m_size6.setActionCommand("Size 6");
        this.m_size4.setActionCommand("Size 4");
        this.m_size2.setActionCommand("Size 2");
        this.m_size1.setActionCommand("Size 1");
        this.m_selectFontGroup.add(this.m_size24);
        this.m_selectFontGroup.add(this.m_size22);
        this.m_selectFontGroup.add(this.m_size20);
        this.m_selectFontGroup.add(this.m_size18);
        this.m_selectFontGroup.add(this.m_size16);
        this.m_selectFontGroup.add(this.m_size14);
        this.m_selectFontGroup.add(this.m_size12);
        this.m_selectFontGroup.add(this.m_size10);
        this.m_selectFontGroup.add(this.m_size8);
        this.m_selectFontGroup.add(this.m_size6);
        this.m_selectFontGroup.add(this.m_size4);
        this.m_selectFontGroup.add(this.m_size2);
        this.m_selectFontGroup.add(this.m_size1);
        this.m_selectFont.add(this.m_size24);
        this.m_selectFont.add(this.m_size22);
        this.m_selectFont.add(this.m_size20);
        this.m_selectFont.add(this.m_size18);
        this.m_selectFont.add(this.m_size16);
        this.m_selectFont.add(this.m_size14);
        this.m_selectFont.add(this.m_size12);
        this.m_selectFont.add(this.m_size10);
        this.m_selectFont.add(this.m_size8);
        this.m_selectFont.add(this.m_size6);
        this.m_selectFont.add(this.m_size4);
        this.m_selectFont.add(this.m_size2);
        this.m_selectFont.add(this.m_size1);
        this.m_size24.addItemListener(this);
        this.m_size22.addItemListener(this);
        this.m_size20.addItemListener(this);
        this.m_size18.addItemListener(this);
        this.m_size16.addItemListener(this);
        this.m_size14.addItemListener(this);
        this.m_size12.addItemListener(this);
        this.m_size10.addItemListener(this);
        this.m_size8.addItemListener(this);
        this.m_size6.addItemListener(this);
        this.m_size4.addItemListener(this);
        this.m_size2.addItemListener(this);
        this.m_size1.addItemListener(this);
        this.m_nodeMenu = new JPopupMenu();
        this.m_visualise = new JMenuItem("Visualize The Node");
        this.m_visualise.setActionCommand("Visualize The Node");
        this.m_visualise.addActionListener(this);
        this.m_nodeMenu.add(this.m_visualise);
        if (this.m_listener != null) {
            this.m_remChildren = new JMenuItem("Remove Child Nodes");
            this.m_remChildren.setActionCommand("Remove Child Nodes");
            this.m_remChildren.addActionListener(this);
            this.m_nodeMenu.add(this.m_remChildren);
            this.m_classifyChild = new JMenuItem("Use Classifier...");
            this.m_classifyChild.setActionCommand("classify_child");
            this.m_classifyChild.addActionListener(this);
            this.m_nodeMenu.add(this.m_classifyChild);
        }
        this.m_focusNode = -1;
        this.m_highlightNode = -1;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.m_frameLimiter.setRepeats(false);
        this.m_frameLimiter.start();
    }

    public TreeVisualizer(TreeDisplayListener tdl, Node n, NodePlace p) {
        this.initialize();
        if (this.m_ShowBorder) {
            this.setBorder(BorderFactory.createTitledBorder("Tree View"));
        }
        this.m_listener = tdl;
        this.m_topNode = n;
        this.m_placer = p;
        this.m_placer.place(this.m_topNode);
        this.m_viewPos = new Dimension(0, 0);
        this.m_viewSize = new Dimension(800, 600);
        this.m_nViewPos = new Dimension(0, 0);
        this.m_nViewSize = new Dimension(800, 600);
        this.m_scaling = 0;
        this.m_numNodes = Node.getCount(this.m_topNode, 0);
        this.m_numLevels = Node.getHeight(this.m_topNode, 0);
        this.m_nodes = new NodeInfo[this.m_numNodes];
        this.m_edges = new EdgeInfo[this.m_numNodes - 1];
        this.arrayFill(this.m_topNode, this.m_nodes, this.m_edges);
        this.changeFontSize(12);
        this.m_mouseState = 0;
        this.m_oldMousePos = new Dimension(0, 0);
        this.m_newMousePos = new Dimension(0, 0);
        this.m_frameLimiter = new Timer(120, this);
        this.m_winMenu = new JPopupMenu();
        this.m_topN = new JMenuItem("Center on Top Node");
        this.m_topN.setActionCommand("Center on Top Node");
        this.m_fitToScreen = new JMenuItem("Fit to Screen");
        this.m_fitToScreen.setActionCommand("Fit to Screen");
        this.m_selectFont = new JMenu("Select Font");
        this.m_selectFont.setActionCommand("Select Font");
        this.m_autoScale = new JMenuItem("Auto Scale");
        this.m_autoScale.setActionCommand("Auto Scale");
        this.m_selectFontGroup = new ButtonGroup();
        this.m_accept = new JMenuItem("Accept The Tree");
        this.m_accept.setActionCommand("Accept The Tree");
        this.m_winMenu.add(this.m_topN);
        this.m_winMenu.addSeparator();
        this.m_winMenu.add(this.m_fitToScreen);
        this.m_winMenu.add(this.m_autoScale);
        this.m_winMenu.addSeparator();
        this.m_winMenu.addSeparator();
        this.m_winMenu.add(this.m_selectFont);
        this.m_winMenu.addSeparator();
        if (this.m_listener != null) {
            this.m_winMenu.add(this.m_accept);
        }
        this.m_topN.addActionListener(this);
        this.m_fitToScreen.addActionListener(this);
        this.m_autoScale.addActionListener(this);
        this.m_accept.addActionListener(this);
        this.m_size24 = new JRadioButtonMenuItem("Size 24", false);
        this.m_size22 = new JRadioButtonMenuItem("Size 22", false);
        this.m_size20 = new JRadioButtonMenuItem("Size 20", false);
        this.m_size18 = new JRadioButtonMenuItem("Size 18", false);
        this.m_size16 = new JRadioButtonMenuItem("Size 16", false);
        this.m_size14 = new JRadioButtonMenuItem("Size 14", false);
        this.m_size12 = new JRadioButtonMenuItem("Size 12", true);
        this.m_size10 = new JRadioButtonMenuItem("Size 10", false);
        this.m_size8 = new JRadioButtonMenuItem("Size 8", false);
        this.m_size6 = new JRadioButtonMenuItem("Size 6", false);
        this.m_size4 = new JRadioButtonMenuItem("Size 4", false);
        this.m_size2 = new JRadioButtonMenuItem("Size 2", false);
        this.m_size1 = new JRadioButtonMenuItem("Size 1", false);
        this.m_size24.setActionCommand("Size 24");
        this.m_size22.setActionCommand("Size 22");
        this.m_size20.setActionCommand("Size 20");
        this.m_size18.setActionCommand("Size 18");
        this.m_size16.setActionCommand("Size 16");
        this.m_size14.setActionCommand("Size 14");
        this.m_size12.setActionCommand("Size 12");
        this.m_size10.setActionCommand("Size 10");
        this.m_size8.setActionCommand("Size 8");
        this.m_size6.setActionCommand("Size 6");
        this.m_size4.setActionCommand("Size 4");
        this.m_size2.setActionCommand("Size 2");
        this.m_size1.setActionCommand("Size 1");
        this.m_selectFontGroup.add(this.m_size24);
        this.m_selectFontGroup.add(this.m_size22);
        this.m_selectFontGroup.add(this.m_size20);
        this.m_selectFontGroup.add(this.m_size18);
        this.m_selectFontGroup.add(this.m_size16);
        this.m_selectFontGroup.add(this.m_size14);
        this.m_selectFontGroup.add(this.m_size12);
        this.m_selectFontGroup.add(this.m_size10);
        this.m_selectFontGroup.add(this.m_size8);
        this.m_selectFontGroup.add(this.m_size6);
        this.m_selectFontGroup.add(this.m_size4);
        this.m_selectFontGroup.add(this.m_size2);
        this.m_selectFontGroup.add(this.m_size1);
        this.m_selectFont.add(this.m_size24);
        this.m_selectFont.add(this.m_size22);
        this.m_selectFont.add(this.m_size20);
        this.m_selectFont.add(this.m_size18);
        this.m_selectFont.add(this.m_size16);
        this.m_selectFont.add(this.m_size14);
        this.m_selectFont.add(this.m_size12);
        this.m_selectFont.add(this.m_size10);
        this.m_selectFont.add(this.m_size8);
        this.m_selectFont.add(this.m_size6);
        this.m_selectFont.add(this.m_size4);
        this.m_selectFont.add(this.m_size2);
        this.m_selectFont.add(this.m_size1);
        this.m_size24.addItemListener(this);
        this.m_size22.addItemListener(this);
        this.m_size20.addItemListener(this);
        this.m_size18.addItemListener(this);
        this.m_size16.addItemListener(this);
        this.m_size14.addItemListener(this);
        this.m_size12.addItemListener(this);
        this.m_size10.addItemListener(this);
        this.m_size8.addItemListener(this);
        this.m_size6.addItemListener(this);
        this.m_size4.addItemListener(this);
        this.m_size2.addItemListener(this);
        this.m_size1.addItemListener(this);
        this.m_nodeMenu = new JPopupMenu();
        this.m_visualise = new JMenuItem("Visualize The Node");
        this.m_visualise.setActionCommand("Visualize The Node");
        this.m_visualise.addActionListener(this);
        this.m_nodeMenu.add(this.m_visualise);
        if (this.m_listener != null) {
            this.m_remChildren = new JMenuItem("Remove Child Nodes");
            this.m_remChildren.setActionCommand("Remove Child Nodes");
            this.m_remChildren.addActionListener(this);
            this.m_nodeMenu.add(this.m_remChildren);
            this.m_classifyChild = new JMenuItem("Use Classifier...");
            this.m_classifyChild.setActionCommand("classify_child");
            this.m_classifyChild.addActionListener(this);
            this.m_nodeMenu.add(this.m_classifyChild);
            this.m_sendInstances = new JMenuItem("Add Instances To Viewer");
            this.m_sendInstances.setActionCommand("send_instances");
            this.m_sendInstances.addActionListener(this);
            this.m_nodeMenu.add(this.m_sendInstances);
        }
        this.m_focusNode = -1;
        this.m_highlightNode = -1;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.m_frameLimiter.setRepeats(false);
        this.m_frameLimiter.start();
    }

    protected Color getColor(String colorStr) {
        Color result = null;
        if (colorStr != null && colorStr.length() > 0) {
            result = VisualizeUtils.processColour(colorStr, result);
        }
        return result;
    }

    protected void initialize() {
        Properties props;
        try {
            props = Utils.readProperties(PROPERTIES_FILE);
        }
        catch (Exception e) {
            e.printStackTrace();
            props = new Properties();
        }
        this.m_FontColor = this.getColor(props.getProperty("FontColor", ""));
        this.m_BackgroundColor = this.getColor(props.getProperty("BackgroundColor", ""));
        this.m_NodeColor = this.getColor(props.getProperty("NodeColor", ""));
        this.m_LineColor = this.getColor(props.getProperty("LineColor", ""));
        this.m_ZoomBoxColor = this.getColor(props.getProperty("ZoomBoxColor", ""));
        this.m_ZoomBoxXORColor = this.getColor(props.getProperty("ZoomBoxXORColor", ""));
        this.m_ShowBorder = Boolean.parseBoolean(props.getProperty("ShowBorder", "true"));
    }

    public void fitToScreen() {
        this.getScreenFit(this.m_viewPos, this.m_viewSize);
        this.repaint();
    }

    private void getScreenFit(Dimension np, Dimension ns) {
        int leftmost = 1000000;
        int rightmost = -1000000;
        int leftCenter = 1000000;
        int rightCenter = -1000000;
        int rightNode = 0;
        int highest = -1000000;
        int highTop = -1000000;
        for (int noa = 0; noa < this.m_numNodes; ++noa) {
            this.calcScreenCoords(noa);
            if (this.m_nodes[noa].m_center - this.m_nodes[noa].m_side < leftmost) {
                leftmost = this.m_nodes[noa].m_center - this.m_nodes[noa].m_side;
            }
            if (this.m_nodes[noa].m_center < leftCenter) {
                leftCenter = this.m_nodes[noa].m_center;
            }
            if (this.m_nodes[noa].m_center + this.m_nodes[noa].m_side > rightmost) {
                rightmost = this.m_nodes[noa].m_center + this.m_nodes[noa].m_side;
            }
            if (this.m_nodes[noa].m_center > rightCenter) {
                rightCenter = this.m_nodes[noa].m_center;
                rightNode = noa;
            }
            if (this.m_nodes[noa].m_top + this.m_nodes[noa].m_height > highest) {
                highest = this.m_nodes[noa].m_top + this.m_nodes[noa].m_height;
            }
            if (this.m_nodes[noa].m_top <= highTop) continue;
            highTop = this.m_nodes[noa].m_top;
        }
        ns.width = this.getWidth();
        ns.width -= leftCenter - leftmost + rightmost - rightCenter + 30;
        ns.height = this.getHeight() - highest + highTop - 40;
        if (this.m_nodes[rightNode].m_node.getCenter() != 0.0 && leftCenter != rightCenter) {
            ns.width = (int)((double)ns.width / this.m_nodes[rightNode].m_node.getCenter());
        }
        if (ns.width < 10) {
            ns.width = 10;
        }
        if (ns.height < 10) {
            ns.height = 10;
        }
        np.width = (leftCenter - leftmost + rightmost - rightCenter) / 2 + 15;
        np.height = (highest - highTop) / 2 + 20;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == null) {
            if (this.m_scaling == 0) {
                this.repaint();
            } else {
                this.animateScaling(this.m_nViewPos, this.m_nViewSize, this.m_scaling);
            }
        } else if (e.getActionCommand().equals("Fit to Screen")) {
            Dimension np = new Dimension();
            Dimension ns = new Dimension();
            this.getScreenFit(np, ns);
            this.animateScaling(np, ns, 10);
        } else if (e.getActionCommand().equals("Center on Top Node")) {
            int tpx = (int)(this.m_topNode.getCenter() * (double)this.m_viewSize.width);
            int tpy = (int)(this.m_topNode.getTop() * (double)this.m_viewSize.height);
            Dimension np = new Dimension(this.getSize().width / 2 - tpx, this.getSize().width / 6 - tpy);
            this.animateScaling(np, this.m_viewSize, 10);
        } else if (e.getActionCommand().equals("Auto Scale")) {
            this.autoScale();
        } else if (e.getActionCommand().equals("Visualize The Node")) {
            if (this.m_focusNode >= 0) {
                Instances inst = this.m_nodes[this.m_focusNode].m_node.getInstances();
                if (inst != null) {
                    VisualizePanel pan = new VisualizePanel();
                    pan.setInstances(inst);
                    final JFrame nf = Utils.getWekaJFrame("", this);
                    nf.getContentPane().add(pan);
                    nf.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            nf.dispose();
                        }
                    });
                    nf.pack();
                    nf.setSize(800, 600);
                    nf.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
                    nf.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry, there is no available Instances data for this Node.", "Sorry!", 2);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error, there is no selected Node to perform this operation on.", "Error!", 0);
            }
        } else if (e.getActionCommand().equals("Create Child Nodes")) {
            if (this.m_focusNode >= 0) {
                if (this.m_listener != null) {
                    this.m_listener.userCommand(new TreeDisplayEvent(1, this.m_nodes[this.m_focusNode].m_node.getRefer()));
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry, there is no available Decision Tree to perform this operation on.", "Sorry!", 2);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error, there is no selected Node to perform this operation on.", "Error!", 0);
            }
        } else if (e.getActionCommand().equals("Remove Child Nodes")) {
            if (this.m_focusNode >= 0) {
                if (this.m_listener != null) {
                    this.m_listener.userCommand(new TreeDisplayEvent(2, this.m_nodes[this.m_focusNode].m_node.getRefer()));
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry, there is no available Decsion Tree to perform this operation on.", "Sorry!", 2);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error, there is no selected Node to perform this operation on.", "Error!", 0);
            }
        } else if (e.getActionCommand().equals("classify_child")) {
            if (this.m_focusNode >= 0) {
                if (this.m_listener != null) {
                    this.m_listener.userCommand(new TreeDisplayEvent(4, this.m_nodes[this.m_focusNode].m_node.getRefer()));
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry, there is no available Decsion Tree to perform this operation on.", "Sorry!", 2);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error, there is no selected Node to perform this operation on.", "Error!", 0);
            }
        } else if (e.getActionCommand().equals("send_instances")) {
            if (this.m_focusNode >= 0) {
                if (this.m_listener != null) {
                    this.m_listener.userCommand(new TreeDisplayEvent(5, this.m_nodes[this.m_focusNode].m_node.getRefer()));
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry, there is no available Decsion Tree to perform this operation on.", "Sorry!", 2);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error, there is no selected Node to perform this operation on.", "Error!", 0);
            }
        } else if (e.getActionCommand().equals("Accept The Tree")) {
            if (this.m_listener != null) {
                this.m_listener.userCommand(new TreeDisplayEvent(3, null));
            } else {
                JOptionPane.showMessageDialog(this, "Sorry, there is no available Decision Tree to perform this operation on.", "Sorry!", 2);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JRadioButtonMenuItem c = (JRadioButtonMenuItem)e.getSource();
        if (c.getActionCommand().equals("Size 24")) {
            this.changeFontSize(24);
        } else if (c.getActionCommand().equals("Size 22")) {
            this.changeFontSize(22);
        } else if (c.getActionCommand().equals("Size 20")) {
            this.changeFontSize(20);
        } else if (c.getActionCommand().equals("Size 18")) {
            this.changeFontSize(18);
        } else if (c.getActionCommand().equals("Size 16")) {
            this.changeFontSize(16);
        } else if (c.getActionCommand().equals("Size 14")) {
            this.changeFontSize(14);
        } else if (c.getActionCommand().equals("Size 12")) {
            this.changeFontSize(12);
        } else if (c.getActionCommand().equals("Size 10")) {
            this.changeFontSize(10);
        } else if (c.getActionCommand().equals("Size 8")) {
            this.changeFontSize(8);
        } else if (c.getActionCommand().equals("Size 6")) {
            this.changeFontSize(6);
        } else if (c.getActionCommand().equals("Size 4")) {
            this.changeFontSize(4);
        } else if (c.getActionCommand().equals("Size 2")) {
            this.changeFontSize(2);
        } else if (c.getActionCommand().equals("Size 1")) {
            this.changeFontSize(1);
        } else if (c.getActionCommand().equals("Hide Descendants")) {
            // empty if block
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.m_clickAvailable) {
            int s = -1;
            for (int noa = 0; noa < this.m_numNodes; ++noa) {
                if (this.m_nodes[noa].m_quad != 18) continue;
                this.calcScreenCoords(noa);
                if (e.getX() <= this.m_nodes[noa].m_center + this.m_nodes[noa].m_side && e.getX() >= this.m_nodes[noa].m_center - this.m_nodes[noa].m_side && e.getY() >= this.m_nodes[noa].m_top && e.getY() <= this.m_nodes[noa].m_top + this.m_nodes[noa].m_height) {
                    s = noa;
                }
                this.m_nodes[noa].m_top = 32000;
            }
            this.m_focusNode = s;
            if (this.m_focusNode != -1) {
                if (this.m_listener != null) {
                    this.actionPerformed(new ActionEvent(this, 32000, "Create Child Nodes"));
                } else {
                    this.actionPerformed(new ActionEvent(this, 32000, "Visualize The Node"));
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.m_frameLimiter.setRepeats(true);
        if ((e.getModifiers() & 0x10) != 0 && !e.isAltDown() && this.m_mouseState == 0 && this.m_scaling == 0) {
            if ((e.getModifiers() & 2) != 0 && (e.getModifiers() & 1) == 0) {
                this.m_mouseState = 2;
            } else if ((e.getModifiers() & 1) != 0 && (e.getModifiers() & 2) == 0) {
                this.m_oldMousePos.width = e.getX();
                this.m_oldMousePos.height = e.getY();
                this.m_newMousePos.width = e.getX();
                this.m_newMousePos.height = e.getY();
                this.m_mouseState = 3;
                Graphics g = this.getGraphics();
                if (this.m_ZoomBoxColor == null) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(this.m_ZoomBoxColor);
                }
                if (this.m_ZoomBoxXORColor == null) {
                    g.setXORMode(Color.white);
                } else {
                    g.setXORMode(this.m_ZoomBoxXORColor);
                }
                g.drawRect(this.m_oldMousePos.width, this.m_oldMousePos.height, this.m_newMousePos.width - this.m_oldMousePos.width, this.m_newMousePos.height - this.m_oldMousePos.height);
                g.dispose();
            } else {
                this.m_oldMousePos.width = e.getX();
                this.m_oldMousePos.height = e.getY();
                this.m_newMousePos.width = e.getX();
                this.m_newMousePos.height = e.getY();
                this.m_mouseState = 1;
                this.m_frameLimiter.start();
            }
        } else if (e.getButton() == 1 && e.isAltDown() && e.isShiftDown() && !e.isControlDown()) {
            this.saveComponent();
        } else if (this.m_mouseState != 0 || this.m_scaling == 0) {
            // empty if block
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.m_clickAvailable = this.m_mouseState == 1;
        if (this.m_mouseState == 2 && this.mouseInBounds(e)) {
            this.m_mouseState = 0;
            Dimension ns = new Dimension(this.m_viewSize.width / 2, this.m_viewSize.height / 2);
            if (ns.width < 10) {
                ns.width = 10;
            }
            if (ns.height < 10) {
                ns.height = 10;
            }
            Dimension d = this.getSize();
            Dimension np = new Dimension((int)((double)(d.width / 2) - ((double)d.width / 2.0 - (double)this.m_viewPos.width) / 2.0), (int)((double)(d.height / 2) - ((double)d.height / 2.0 - (double)this.m_viewPos.height) / 2.0));
            this.animateScaling(np, ns, 10);
        } else if (this.m_mouseState == 3) {
            this.m_mouseState = 0;
            Graphics g = this.getGraphics();
            if (this.m_ZoomBoxColor == null) {
                g.setColor(Color.black);
            } else {
                g.setColor(this.m_ZoomBoxColor);
            }
            if (this.m_ZoomBoxXORColor == null) {
                g.setXORMode(Color.white);
            } else {
                g.setXORMode(this.m_ZoomBoxXORColor);
            }
            g.drawRect(this.m_oldMousePos.width, this.m_oldMousePos.height, this.m_newMousePos.width - this.m_oldMousePos.width, this.m_newMousePos.height - this.m_oldMousePos.height);
            g.dispose();
            int cw = this.m_newMousePos.width - this.m_oldMousePos.width;
            int ch = this.m_newMousePos.height - this.m_oldMousePos.height;
            if (cw >= 1 && ch >= 1 && this.mouseInBounds(e) && this.getSize().width / cw <= 6 && this.getSize().height / ch <= 6) {
                Dimension ns = new Dimension();
                Dimension np = new Dimension();
                double nvsw = (double)this.getSize().width / (double)cw;
                double nvsh = (double)this.getSize().height / (double)ch;
                np.width = (int)((double)(this.m_oldMousePos.width - this.m_viewPos.width) * -nvsw);
                np.height = (int)((double)(this.m_oldMousePos.height - this.m_viewPos.height) * -nvsh);
                ns.width = (int)((double)this.m_viewSize.width * nvsw);
                ns.height = (int)((double)this.m_viewSize.height * nvsh);
                this.animateScaling(np, ns, 10);
            }
        } else if (this.m_mouseState == 0 && this.m_scaling == 0) {
            this.m_mouseState = 0;
            this.setFont(new Font("A Name", 0, 12));
            int s = -1;
            for (int noa = 0; noa < this.m_numNodes; ++noa) {
                if (this.m_nodes[noa].m_quad != 18) continue;
                this.calcScreenCoords(noa);
                if (e.getX() <= this.m_nodes[noa].m_center + this.m_nodes[noa].m_side && e.getX() >= this.m_nodes[noa].m_center - this.m_nodes[noa].m_side && e.getY() >= this.m_nodes[noa].m_top && e.getY() <= this.m_nodes[noa].m_top + this.m_nodes[noa].m_height) {
                    s = noa;
                }
                this.m_nodes[noa].m_top = 32000;
            }
            if (s == -1) {
                this.m_winMenu.show(this, e.getX(), e.getY());
            } else {
                this.m_focusNode = s;
                this.m_nodeMenu.show(this, e.getX(), e.getY());
            }
            this.setFont(this.m_currentFont);
        } else if (this.m_mouseState == 1) {
            this.m_mouseState = 0;
            this.m_frameLimiter.stop();
            this.repaint();
        }
    }

    private boolean mouseInBounds(MouseEvent e) {
        return e.getX() >= 0 && e.getY() >= 0 && e.getX() <= this.getSize().width && e.getY() <= this.getSize().height;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.m_mouseState == 1) {
            this.m_oldMousePos.width = this.m_newMousePos.width;
            this.m_oldMousePos.height = this.m_newMousePos.height;
            this.m_newMousePos.width = e.getX();
            this.m_newMousePos.height = e.getY();
            this.m_viewPos.width += this.m_newMousePos.width - this.m_oldMousePos.width;
            this.m_viewPos.height += this.m_newMousePos.height - this.m_oldMousePos.height;
        } else if (this.m_mouseState == 3) {
            Graphics g = this.getGraphics();
            if (this.m_ZoomBoxColor == null) {
                g.setColor(Color.black);
            } else {
                g.setColor(this.m_ZoomBoxColor);
            }
            if (this.m_ZoomBoxXORColor == null) {
                g.setXORMode(Color.white);
            } else {
                g.setXORMode(this.m_ZoomBoxXORColor);
            }
            g.drawRect(this.m_oldMousePos.width, this.m_oldMousePos.height, this.m_newMousePos.width - this.m_oldMousePos.width, this.m_newMousePos.height - this.m_oldMousePos.height);
            this.m_newMousePos.width = e.getX();
            this.m_newMousePos.height = e.getY();
            g.drawRect(this.m_oldMousePos.width, this.m_oldMousePos.height, this.m_newMousePos.width - this.m_oldMousePos.width, this.m_newMousePos.height - this.m_oldMousePos.height);
            g.dispose();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setHighlight(String id) {
        for (int noa = 0; noa < this.m_numNodes; ++noa) {
            if (!id.equals(this.m_nodes[noa].m_node.getRefer())) continue;
            this.m_highlightNode = noa;
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Color oldBackground = ((Graphics2D)g).getBackground();
        if (this.m_BackgroundColor != null) {
            ((Graphics2D)g).setBackground(this.m_BackgroundColor);
        }
        g.clearRect(0, 0, this.getSize().width, this.getSize().height);
        ((Graphics2D)g).setBackground(oldBackground);
        g.setClip(3, 7, this.getWidth() - 6, this.getHeight() - 10);
        this.painter(g);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
    }

    private void painter(Graphics g) {
        int noa;
        double left_clip = (double)(-this.m_viewPos.width - 50) / (double)this.m_viewSize.width;
        double right_clip = (double)(this.getSize().width - this.m_viewPos.width + 50) / (double)this.m_viewSize.width;
        double top_clip = (double)(-this.m_viewPos.height - 50) / (double)this.m_viewSize.height;
        double bottom_clip = (double)(this.getSize().height - this.m_viewPos.height + 50) / (double)this.m_viewSize.height;
        int row = 0;
        int col = 0;
        for (noa = 0; noa < this.m_numNodes; ++noa) {
            double ncent;
            Node r = this.m_nodes[noa].m_node;
            if (this.m_nodes[noa].m_change) {
                double ntop = r.getTop();
                row = ntop < top_clip ? 8 : (ntop > bottom_clip ? 32 : 16);
            }
            col = (ncent = r.getCenter()) < left_clip ? 4 : (ncent > right_clip ? 1 : 2);
            this.m_nodes[noa].m_quad = row | col;
            if (this.m_nodes[noa].m_parent < 0) continue;
            int pq = this.m_nodes[this.m_edges[this.m_nodes[noa].m_parent].m_parent].m_quad;
            int cq = this.m_nodes[noa].m_quad;
            if ((cq & 8) == 8 || (pq & 0x20) == 32 || (cq & 4) == 4 && (pq & 4) == 4 || (cq & 1) == 1 && (pq & 1) == 1) continue;
            this.drawLine(this.m_nodes[noa].m_parent, g);
        }
        for (noa = 0; noa < this.m_numNodes; ++noa) {
            if (this.m_nodes[noa].m_quad != 18) continue;
            this.drawNode(noa, g);
        }
        if (this.m_highlightNode >= 0 && this.m_highlightNode < this.m_numNodes && this.m_nodes[this.m_highlightNode].m_quad == 18) {
            Color acol = this.m_NodeColor == null ? this.m_nodes[this.m_highlightNode].m_node.getColor() : this.m_NodeColor;
            g.setColor(new Color((acol.getRed() + 125) % 256, (acol.getGreen() + 125) % 256, (acol.getBlue() + 125) % 256));
            if (this.m_nodes[this.m_highlightNode].m_node.getShape() == 1) {
                g.drawRect(this.m_nodes[this.m_highlightNode].m_center - this.m_nodes[this.m_highlightNode].m_side, this.m_nodes[this.m_highlightNode].m_top, this.m_nodes[this.m_highlightNode].m_width, this.m_nodes[this.m_highlightNode].m_height);
                g.drawRect(this.m_nodes[this.m_highlightNode].m_center - this.m_nodes[this.m_highlightNode].m_side + 1, this.m_nodes[this.m_highlightNode].m_top + 1, this.m_nodes[this.m_highlightNode].m_width - 2, this.m_nodes[this.m_highlightNode].m_height - 2);
            } else if (this.m_nodes[this.m_highlightNode].m_node.getShape() == 2) {
                g.drawOval(this.m_nodes[this.m_highlightNode].m_center - this.m_nodes[this.m_highlightNode].m_side, this.m_nodes[this.m_highlightNode].m_top, this.m_nodes[this.m_highlightNode].m_width, this.m_nodes[this.m_highlightNode].m_height);
                g.drawOval(this.m_nodes[this.m_highlightNode].m_center - this.m_nodes[this.m_highlightNode].m_side + 1, this.m_nodes[this.m_highlightNode].m_top + 1, this.m_nodes[this.m_highlightNode].m_width - 2, this.m_nodes[this.m_highlightNode].m_height - 2);
            }
        }
        for (int noa2 = 0; noa2 < this.m_numNodes; ++noa2) {
            this.m_nodes[noa2].m_top = 32000;
        }
    }

    private void drawNode(int n, Graphics g) {
        if (this.m_NodeColor == null) {
            g.setColor(this.m_nodes[n].m_node.getColor());
        } else {
            g.setColor(this.m_NodeColor);
        }
        g.setPaintMode();
        this.calcScreenCoords(n);
        int x = this.m_nodes[n].m_center - this.m_nodes[n].m_side;
        int y = this.m_nodes[n].m_top;
        if (this.m_nodes[n].m_node.getShape() == 1) {
            g.fill3DRect(x, y, this.m_nodes[n].m_width, this.m_nodes[n].m_height, true);
            this.drawText(x, y, n, false, g);
        } else if (this.m_nodes[n].m_node.getShape() == 2) {
            g.fillOval(x, y, this.m_nodes[n].m_width, this.m_nodes[n].m_height);
            this.drawText(x, y + (int)((double)this.m_nodes[n].m_height * 0.15), n, false, g);
        }
    }

    private void drawLine(int e, Graphics g) {
        int p = this.m_edges[e].m_parent;
        int c = this.m_edges[e].m_child;
        this.calcScreenCoords(c);
        this.calcScreenCoords(p);
        if (this.m_LineColor == null) {
            g.setColor(Color.black);
        } else {
            g.setColor(this.m_LineColor);
        }
        g.setPaintMode();
        if (this.m_currentFont.getSize() < 2) {
            g.drawLine(this.m_nodes[p].m_center, this.m_nodes[p].m_top + this.m_nodes[p].m_height, this.m_nodes[c].m_center, this.m_nodes[c].m_top);
        } else {
            int e_width = this.m_nodes[c].m_center - this.m_nodes[p].m_center;
            int e_height = this.m_nodes[c].m_top - (this.m_nodes[p].m_top + this.m_nodes[p].m_height);
            int e_width2 = e_width / 2;
            int e_height2 = e_height / 2;
            int e_centerx = this.m_nodes[p].m_center + e_width2;
            int e_centery = this.m_nodes[p].m_top + this.m_nodes[p].m_height + e_height2;
            int e_offset = this.m_edges[e].m_tb;
            int tmp = (int)((double)e_width / (double)e_height * (double)(e_height2 - e_offset)) + this.m_nodes[p].m_center;
            this.drawText(e_centerx - this.m_edges[e].m_side, e_centery - e_offset, e, true, g);
            if (tmp > e_centerx - this.m_edges[e].m_side && tmp < e_centerx + this.m_edges[e].m_side) {
                g.drawLine(this.m_nodes[p].m_center, this.m_nodes[p].m_top + this.m_nodes[p].m_height, tmp, e_centery - e_offset);
                g.drawLine(e_centerx * 2 - tmp, e_centery + e_offset, this.m_nodes[c].m_center, this.m_nodes[c].m_top);
            } else {
                e_offset = this.m_edges[e].m_side;
                if (e_width < 0) {
                    e_offset *= -1;
                }
                tmp = (int)((double)e_height / (double)e_width * (double)(e_width2 - e_offset)) + this.m_nodes[p].m_top + this.m_nodes[p].m_height;
                g.drawLine(this.m_nodes[p].m_center, this.m_nodes[p].m_top + this.m_nodes[p].m_height, e_centerx - e_offset, tmp);
                g.drawLine(e_centerx + e_offset, e_centery * 2 - tmp, this.m_nodes[c].m_center, this.m_nodes[c].m_top);
            }
        }
    }

    private void drawText(int x1, int y1, int s, boolean e_or_n, Graphics g) {
        Color oldColor = g.getColor();
        g.setPaintMode();
        if (this.m_FontColor == null) {
            g.setColor(Color.black);
        } else {
            g.setColor(this.m_FontColor);
        }
        if (e_or_n) {
            String st;
            Edge e = this.m_edges[s].m_edge;
            int noa = 0;
            while ((st = e.getLine(noa)) != null) {
                g.drawString(st, (this.m_edges[s].m_width - this.m_fontSize.stringWidth(st)) / 2 + x1, y1 + (noa + 1) * this.m_fontSize.getHeight());
                ++noa;
            }
        } else {
            String st;
            Node e = this.m_nodes[s].m_node;
            int noa = 0;
            while ((st = e.getLine(noa)) != null) {
                g.drawString(st, (this.m_nodes[s].m_width - this.m_fontSize.stringWidth(st)) / 2 + x1, y1 + (noa + 1) * this.m_fontSize.getHeight());
                ++noa;
            }
        }
        g.setColor(oldColor);
    }

    private void calcScreenCoords(int n) {
        if (this.m_nodes[n].m_top == 32000) {
            this.m_nodes[n].m_top = (int)(this.m_nodes[n].m_node.getTop() * (double)this.m_viewSize.height) + this.m_viewPos.height;
            this.m_nodes[n].m_center = (int)(this.m_nodes[n].m_node.getCenter() * (double)this.m_viewSize.width) + this.m_viewPos.width;
        }
    }

    private void autoScale() {
        Dimension temp = new Dimension(10, 10);
        if (this.m_numNodes <= 1) {
            return;
        }
        int dist = (this.m_nodes[0].m_height + 40) * this.m_numLevels;
        if (dist > temp.height) {
            temp.height = dist;
        }
        for (int noa = 0; noa < this.m_numNodes - 1; ++noa) {
            this.calcScreenCoords(noa);
            this.calcScreenCoords(noa + 1);
            if (!this.m_nodes[noa + 1].m_change) {
                dist = this.m_nodes[noa + 1].m_center - this.m_nodes[noa].m_center;
                if (dist <= 0) {
                    dist = 1;
                }
                if ((dist = (6 + this.m_nodes[noa].m_side + this.m_nodes[noa + 1].m_side) * this.m_viewSize.width / dist) > temp.width) {
                    temp.width = dist;
                }
            }
            if ((dist = (this.m_nodes[noa + 1].m_height + 40) * this.m_numLevels) <= temp.height) continue;
            temp.height = dist;
        }
        int y2 = this.m_nodes[this.m_edges[0].m_child].m_top;
        int y1 = this.m_nodes[this.m_edges[0].m_parent].m_top;
        dist = y2 - y1;
        if (dist <= 0) {
            dist = 1;
        }
        if ((dist = (60 + this.m_edges[0].m_height + this.m_nodes[this.m_edges[0].m_parent].m_height) * this.m_viewSize.height / dist) > temp.height) {
            temp.height = dist;
        }
        for (int noa = 0; noa < this.m_numNodes - 2; ++noa) {
            if (!this.m_nodes[this.m_edges[noa + 1].m_child].m_change) {
                int xa = this.m_nodes[this.m_edges[noa].m_child].m_center - this.m_nodes[this.m_edges[noa].m_parent].m_center;
                xa /= 2;
                int xb = this.m_nodes[this.m_edges[noa + 1].m_child].m_center - this.m_nodes[this.m_edges[noa + 1].m_parent].m_center;
                xb /= 2;
                dist = (xb += this.m_nodes[this.m_edges[noa + 1].m_parent].m_center) - (xa += this.m_nodes[this.m_edges[noa].m_parent].m_center);
                if (dist <= 0) {
                    dist = 1;
                }
                if ((dist = (12 + this.m_edges[noa].m_side + this.m_edges[noa + 1].m_side) * this.m_viewSize.width / dist) > temp.width) {
                    temp.width = dist;
                }
            }
            y1 = this.m_nodes[this.m_edges[noa + 1].m_parent].m_top;
            y2 = this.m_nodes[this.m_edges[noa + 1].m_child].m_top;
            dist = y2 - y1;
            if (dist <= 0) {
                dist = 1;
            }
            if ((dist = (60 + this.m_edges[noa + 1].m_height + this.m_nodes[this.m_edges[noa + 1].m_parent].m_height) * this.m_viewSize.height / dist) <= temp.height) continue;
            temp.height = dist;
        }
        Dimension e = this.getSize();
        Dimension np = new Dimension();
        np.width = (int)((double)(e.width / 2) - ((double)e.width / 2.0 - (double)this.m_viewPos.width) / (double)this.m_viewSize.width * (double)temp.width);
        np.height = (int)((double)(e.height / 2) - ((double)e.height / 2.0 - (double)this.m_viewPos.height) / (double)this.m_viewSize.height * (double)temp.height);
        for (int noa = 0; noa < this.m_numNodes; ++noa) {
            this.m_nodes[noa].m_top = 32000;
        }
        this.animateScaling(np, temp, 10);
    }

    private void animateScaling(Dimension n_pos, Dimension n_size, int frames) {
        if (frames == 0) {
            System.out.println("the timer didn't end in time");
            this.m_scaling = 0;
        } else {
            if (this.m_scaling == 0) {
                this.m_frameLimiter.start();
                this.m_nViewPos.width = n_pos.width;
                this.m_nViewPos.height = n_pos.height;
                this.m_nViewSize.width = n_size.width;
                this.m_nViewSize.height = n_size.height;
                this.m_scaling = frames;
            }
            int s_w = (n_size.width - this.m_viewSize.width) / frames;
            int s_h = (n_size.height - this.m_viewSize.height) / frames;
            int p_w = (n_pos.width - this.m_viewPos.width) / frames;
            int p_h = (n_pos.height - this.m_viewPos.height) / frames;
            this.m_viewSize.width += s_w;
            this.m_viewSize.height += s_h;
            this.m_viewPos.width += p_w;
            this.m_viewPos.height += p_h;
            this.repaint();
            --this.m_scaling;
            if (this.m_scaling == 0) {
                this.m_frameLimiter.stop();
            }
        }
    }

    private void changeFontSize(int s) {
        this.m_currentFont = new Font("A Name", 0, s);
        this.setFont(this.m_currentFont);
        this.m_fontSize = this.getFontMetrics(this.getFont());
        for (int noa = 0; noa < this.m_numNodes; ++noa) {
            Dimension d = this.m_nodes[noa].m_node.stringSize(this.m_fontSize);
            if (this.m_nodes[noa].m_node.getShape() == 1) {
                this.m_nodes[noa].m_height = d.height + 10;
                this.m_nodes[noa].m_width = d.width + 8;
                this.m_nodes[noa].m_side = this.m_nodes[noa].m_width / 2;
            } else if (this.m_nodes[noa].m_node.getShape() == 2) {
                this.m_nodes[noa].m_height = (int)((double)(d.height + 2) * 1.6);
                this.m_nodes[noa].m_width = (int)((double)(d.width + 2) * 1.6);
                this.m_nodes[noa].m_side = this.m_nodes[noa].m_width / 2;
            }
            if (noa >= this.m_numNodes - 1) continue;
            d = this.m_edges[noa].m_edge.stringSize(this.m_fontSize);
            this.m_edges[noa].m_height = d.height + 8;
            this.m_edges[noa].m_width = d.width + 8;
            this.m_edges[noa].m_side = this.m_edges[noa].m_width / 2;
            this.m_edges[noa].m_tb = this.m_edges[noa].m_height / 2;
        }
    }

    private void arrayFill(Node t, NodeInfo[] l, EdgeInfo[] k) {
        if (t == null || l == null) {
            System.exit(1);
        }
        l[0] = new NodeInfo();
        l[0].m_node = t;
        l[0].m_parent = -1;
        l[0].m_change = true;
        int free_space = 1;
        double height = t.getTop();
        for (int floater = 0; floater < free_space; ++floater) {
            Edge e;
            Node r = l[floater].m_node;
            int noa = 0;
            while ((e = r.getChild(noa)) != null) {
                Node s = e.getTarget();
                l[free_space] = new NodeInfo();
                l[free_space].m_node = s;
                l[free_space].m_parent = free_space - 1;
                k[free_space - 1] = new EdgeInfo();
                k[free_space - 1].m_edge = e;
                k[free_space - 1].m_parent = floater;
                k[free_space - 1].m_child = free_space;
                if (height != s.getTop()) {
                    l[free_space].m_change = true;
                    height = s.getTop();
                } else {
                    l[free_space].m_change = false;
                }
                ++free_space;
                ++noa;
            }
        }
    }

    public static void main(String[] args) {
        try {
            Logger.log(Logger.Level.INFO, "Logging started");
            TreeBuild builder = new TreeBuild();
            Node top = null;
            PlaceNode2 arrange = new PlaceNode2();
            top = builder.create(new FileReader(args[0]));
            TreeVisualizer a2 = new TreeVisualizer(null, top, (NodePlace)arrange);
            a2.setSize(800, 600);
            JFrame f = new JFrame();
            Container contentPane = f.getContentPane();
            contentPane.add(a2);
            f.setDefaultCloseOperation(2);
            f.setSize(800, 600);
            f.setVisible(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class EdgeInfo {
        int m_parent;
        int m_child;
        int m_side;
        int m_tb;
        int m_width;
        int m_height;
        Edge m_edge;

        private EdgeInfo() {
        }
    }

    private class NodeInfo {
        int m_top = 32000;
        int m_center;
        int m_side;
        int m_width;
        int m_height;
        boolean m_change;
        int m_parent;
        int m_quad;
        Node m_node;

        private NodeInfo() {
        }
    }
}

