/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.selection;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.uma.jmetal.operator.impl.selection.RankingAndCrowdingSelection;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.comparator.DirScoreComparator;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.DirScore;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;

public class RankingAndDirScoreSelection<S extends Solution<?>>
extends RankingAndCrowdingSelection<S> {
    private int solutionsToSelect;
    private Comparator<S> dominanceComparator;
    private double[][] referenceVectors;

    public RankingAndDirScoreSelection(int solutionsToSelect, Comparator<S> dominanceComparator, double[][] referenceVectors) {
        super(solutionsToSelect, dominanceComparator);
        this.solutionsToSelect = solutionsToSelect;
        this.dominanceComparator = dominanceComparator;
        this.referenceVectors = referenceVectors;
    }

    @Override
    public List<S> execute(List<S> solutionSet) {
        if (this.referenceVectors == null || this.referenceVectors.length == 0) {
            throw new JMetalException("reference vectors can not be null.");
        }
        if (CollectionUtils.isEmpty(solutionSet)) {
            throw new JMetalException("solution set can not be null");
        }
        DominanceRanking<S> ranking = new DominanceRanking<S>(this.dominanceComparator);
        ranking.computeRanking(solutionSet);
        return this.dirScoreSelection(ranking);
    }

    private List<S> dirScoreSelection(Ranking<S> ranking) {
        DirScore<S> dirScore = new DirScore<S>(this.referenceVectors);
        ArrayList population = new ArrayList(this.solutionsToSelect);
        int rankingIndex = 0;
        while (population.size() < this.solutionsToSelect) {
            if (this.subfrontFillsIntoThePopulation(ranking, rankingIndex, population)) {
                dirScore.computeDensityEstimator(ranking.getSubfront(rankingIndex));
                this.addRankedSolutionsToPopulation(ranking, rankingIndex, population);
                ++rankingIndex;
                continue;
            }
            dirScore.computeDensityEstimator(ranking.getSubfront(rankingIndex));
            this.addLastRankedSolutionsToPopulation(ranking, rankingIndex, population);
        }
        return population;
    }

    @Override
    protected void addLastRankedSolutionsToPopulation(Ranking<S> ranking, int rank, List<S> population) {
        List<S> currentRankedFront = ranking.getSubfront(rank);
        currentRankedFront.sort(new DirScoreComparator());
        int i = 0;
        while (population.size() < this.solutionsToSelect) {
            population.add(currentRankedFront.get(i));
            ++i;
        }
    }
}

