/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.impl.DefaultDoubleSolution;
import org.uma.jmetal.util.solutionattribute.impl.NumberOfViolatedConstraints;
import org.uma.jmetal.util.solutionattribute.impl.OverallConstraintViolation;

public class ComposableDoubleProblem
implements DoubleProblem {
    private List<Function<Double[], Double>> objectiveFunction = new ArrayList<Function<Double[], Double>>();
    private List<Function<Double[], Double>> constraints = new ArrayList<Function<Double[], Double>>();
    private List<Double> lowerBounds = new ArrayList<Double>();
    private List<Double> upperBounds = new ArrayList<Double>();
    private String name = "";
    private OverallConstraintViolation<DoubleSolution> overallConstraintViolationDegree = new OverallConstraintViolation();
    private NumberOfViolatedConstraints<DoubleSolution> numberOfViolatedConstraints = new NumberOfViolatedConstraints();

    public ComposableDoubleProblem addFunction(Function<Double[], Double> objective) {
        this.objectiveFunction.add(objective);
        return this;
    }

    public ComposableDoubleProblem addConstraint(Function<Double[], Double> constraint) {
        this.constraints.add(constraint);
        return this;
    }

    public ComposableDoubleProblem addVariable(double lowerBound, double upperBound) {
        this.lowerBounds.add(lowerBound);
        this.upperBounds.add(upperBound);
        return this;
    }

    public ComposableDoubleProblem setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public int getNumberOfVariables() {
        return this.lowerBounds.size();
    }

    @Override
    public int getNumberOfObjectives() {
        return this.objectiveFunction.size();
    }

    @Override
    public int getNumberOfConstraints() {
        return this.constraints.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Double getLowerBound(int index) {
        return this.lowerBounds.get(index);
    }

    @Override
    public Double getUpperBound(int index) {
        return this.upperBounds.get(index);
    }

    @Override
    public DoubleSolution createSolution() {
        return new DefaultDoubleSolution(this);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        Double[] vars = solution.getVariables().toArray(new Double[this.getNumberOfVariables()]);
        IntStream.range(0, this.getNumberOfObjectives()).forEach(i -> solution.setObjective(i, this.objectiveFunction.get(i).apply(vars)));
        if (this.getNumberOfConstraints() > 0) {
            double overallConstraintViolation = 0.0;
            int violatedConstraints = 0;
            for (int i2 = 0; i2 < this.getNumberOfConstraints(); ++i2) {
                double violationDegree = this.constraints.get(i2).apply(vars);
                if (!(violationDegree < 0.0)) continue;
                overallConstraintViolation += violationDegree;
                ++violatedConstraints;
            }
            this.overallConstraintViolationDegree.setAttribute(solution, overallConstraintViolation);
            this.numberOfViolatedConstraints.setAttribute(solution, violatedConstraints);
        }
    }
}

