/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.solutionattribute.impl.NumberOfViolatedConstraints;
import org.uma.jmetal.util.solutionattribute.impl.OverallConstraintViolation;

public class Osyczka2
extends AbstractDoubleProblem {
    public OverallConstraintViolation<DoubleSolution> overallConstraintViolationDegree;
    public NumberOfViolatedConstraints<DoubleSolution> numberOfViolatedConstraints;

    public Osyczka2() {
        this.setNumberOfVariables(6);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(6);
        this.setName("Osyczka2");
        List<Double> lowerLimit = Arrays.asList(0.0, 0.0, 1.0, 0.0, 1.0, 0.0);
        List<Double> upperLimit = Arrays.asList(10.0, 10.0, 5.0, 6.0, 5.0, 10.0);
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
        this.overallConstraintViolationDegree = new OverallConstraintViolation();
        this.numberOfViolatedConstraints = new NumberOfViolatedConstraints();
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        double[] fx = new double[this.getNumberOfObjectives()];
        double x1 = (Double)solution.getVariableValue(0);
        double x2 = (Double)solution.getVariableValue(1);
        double x3 = (Double)solution.getVariableValue(2);
        double x4 = (Double)solution.getVariableValue(3);
        double x5 = (Double)solution.getVariableValue(4);
        double x6 = (Double)solution.getVariableValue(5);
        fx[0] = -(25.0 * (x1 - 2.0) * (x1 - 2.0) + (x2 - 2.0) * (x2 - 2.0) + (x3 - 1.0) * (x3 - 1.0) + (x4 - 4.0) * (x4 - 4.0) + (x5 - 1.0) * (x5 - 1.0));
        fx[1] = x1 * x1 + x2 * x2 + x3 * x3 + x4 * x4 + x5 * x5 + x6 * x6;
        solution.setObjective(0, fx[0]);
        solution.setObjective(1, fx[1]);
        this.evaluateConstraints(solution);
    }

    private void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double x1 = (Double)solution.getVariableValue(0);
        double x2 = (Double)solution.getVariableValue(1);
        double x3 = (Double)solution.getVariableValue(2);
        double x4 = (Double)solution.getVariableValue(3);
        double x5 = (Double)solution.getVariableValue(4);
        double x6 = (Double)solution.getVariableValue(5);
        constraint[0] = (x1 + x2) / 2.0 - 1.0;
        constraint[1] = (6.0 - x1 - x2) / 6.0;
        constraint[2] = (2.0 - x2 + x1) / 2.0;
        constraint[3] = (2.0 - x1 + 3.0 * x2) / 2.0;
        constraint[4] = (4.0 - (x3 - 3.0) * (x3 - 3.0) - x4) / 4.0;
        constraint[5] = ((x5 - 3.0) * (x5 - 3.0) + x6 - 4.0) / 4.0;
        double overallConstraintViolation = 0.0;
        int violatedConstraints = 0;
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            if (!(constraint[i] < 0.0)) continue;
            overallConstraintViolation += constraint[i];
            ++violatedConstraints;
        }
        this.overallConstraintViolationDegree.setAttribute(solution, overallConstraintViolation);
        this.numberOfViolatedConstraints.setAttribute(solution, violatedConstraints);
    }
}

