/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.solutionattribute.impl.NumberOfViolatedConstraints;
import org.uma.jmetal.util.solutionattribute.impl.OverallConstraintViolation;

public class Water
extends AbstractDoubleProblem {
    public OverallConstraintViolation<DoubleSolution> overallConstraintViolationDegree;
    public NumberOfViolatedConstraints<DoubleSolution> numberOfViolatedConstraints;
    public static final Double[] LOWERLIMIT = new Double[]{0.01, 0.01, 0.01};
    public static final Double[] UPPERLIMIT = new Double[]{0.45, 0.1, 0.1};

    public Water() {
        this.setNumberOfVariables(3);
        this.setNumberOfObjectives(5);
        this.setNumberOfConstraints(7);
        this.setName("Water");
        List<Double> lowerLimit = Arrays.asList(LOWERLIMIT);
        List<Double> upperLimit = Arrays.asList(UPPERLIMIT);
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
        this.overallConstraintViolationDegree = new OverallConstraintViolation();
        this.numberOfViolatedConstraints = new NumberOfViolatedConstraints();
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        double[] fx = new double[solution.getNumberOfObjectives()];
        double[] x = new double[solution.getNumberOfVariables()];
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariableValue(i);
        }
        fx[0] = 106780.37 * (x[1] + x[2]) + 61704.67;
        fx[1] = 3000.0 * x[0];
        fx[2] = 6.997473E8 * x[1] / Math.pow(137.34, 0.65);
        fx[3] = 572250.0 * Math.exp(-39.75 * x[1] + 9.9 * x[2] + 2.74);
        fx[4] = 25.0 * (1.39 / (x[0] * x[1]) + 4940.0 * x[2] - 80.0);
        solution.setObjective(0, fx[0]);
        solution.setObjective(1, fx[1]);
        solution.setObjective(2, fx[2]);
        solution.setObjective(3, fx[3]);
        solution.setObjective(4, fx[4]);
        this.evaluateConstraints(solution);
    }

    public void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double[] x = new double[solution.getNumberOfVariables()];
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariableValue(i);
        }
        constraint[0] = 1.0 - (0.00139 / (x[0] * x[1]) + 4.94 * x[2] - 0.08);
        constraint[1] = 1.0 - (3.06E-4 / (x[0] * x[1]) + 1.082 * x[2] - 0.0986);
        constraint[2] = 50000.0 - (12.307 / (x[0] * x[1]) + 49408.24 * x[2] + 4051.02);
        constraint[3] = 16000.0 - (2.098 / (x[0] * x[1]) + 8046.33 * x[2] - 696.71);
        constraint[4] = 10000.0 - (2.138 / (x[0] * x[1]) + 7883.39 * x[2] - 705.04);
        constraint[5] = 2000.0 - (0.417 * x[0] * x[1] + 1721.26 * x[2] - 136.54);
        constraint[6] = 550.0 - (0.164 / (x[0] * x[1]) + 631.13 * x[2] - 54.48);
        double overallConstraintViolation = 0.0;
        int violatedConstraints = 0;
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            if (!(constraint[i] < 0.0)) continue;
            overallConstraintViolation += constraint[i];
            ++violatedConstraints;
        }
        this.overallConstraintViolationDegree.setAttribute(solution, overallConstraintViolation);
        this.numberOfViolatedConstraints.setAttribute(solution, violatedConstraints);
    }
}

