/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cdtlz;

import java.util.HashMap;
import java.util.Map;
import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ3;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.solutionattribute.impl.NumberOfViolatedConstraints;
import org.uma.jmetal.util.solutionattribute.impl.OverallConstraintViolation;

public class C1_DTLZ3
extends DTLZ3 {
    public OverallConstraintViolation<DoubleSolution> overallConstraintViolationDegree;
    public NumberOfViolatedConstraints<DoubleSolution> numberOfViolatedConstraints;
    private static Map<Integer, Double> rValue = new HashMap<Integer, Double>();

    public C1_DTLZ3(int numberOfVariables, int numberOfObjectives) {
        super(numberOfVariables, numberOfObjectives);
        this.setNumberOfConstraints(1);
        this.overallConstraintViolationDegree = new OverallConstraintViolation();
        this.numberOfViolatedConstraints = new NumberOfViolatedConstraints();
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        super.evaluate(solution);
        this.evaluateConstraints(solution);
    }

    private void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < this.getNumberOfObjectives(); ++i) {
            double v = Math.pow(solution.getObjective(i), 2.0);
            sum1 += v - 16.0;
            sum2 += v - Math.pow(rValue.get(this.getNumberOfObjectives()), 2.0);
        }
        constraint[0] = sum1 * sum2;
        double overallConstraintViolation = 0.0;
        int violatedConstraints = 0;
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            if (!(constraint[i] < 0.0)) continue;
            overallConstraintViolation += constraint[i];
            ++violatedConstraints;
        }
        this.overallConstraintViolationDegree.setAttribute(solution, overallConstraintViolation);
        this.numberOfViolatedConstraints.setAttribute(solution, violatedConstraints);
    }

    static {
        rValue.put(3, 9.0);
        rValue.put(5, 12.5);
        rValue.put(8, 12.5);
        rValue.put(10, 15.0);
        rValue.put(15, 15.0);
    }
}

