/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cdtlz;

import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ4;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.solutionattribute.impl.NumberOfViolatedConstraints;
import org.uma.jmetal.util.solutionattribute.impl.OverallConstraintViolation;

public class C3_DTLZ4
extends DTLZ4 {
    public OverallConstraintViolation<DoubleSolution> overallConstraintViolationDegree;
    public NumberOfViolatedConstraints<DoubleSolution> numberOfViolatedConstraints;

    public C3_DTLZ4(int numberOfVariables, int numberOfObjectives, int numberOfConstraints) {
        super(numberOfVariables, numberOfObjectives);
        this.setNumberOfConstraints(numberOfConstraints);
        this.overallConstraintViolationDegree = new OverallConstraintViolation();
        this.numberOfViolatedConstraints = new NumberOfViolatedConstraints();
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        super.evaluate(solution);
        this.evaluateConstraints(solution);
    }

    private void evaluateConstraints(DoubleSolution solution) {
        int i;
        double[] constraint = new double[this.getNumberOfConstraints()];
        for (int j = 0; j < this.getNumberOfConstraints(); ++j) {
            double sum = 0.0;
            constraint[j] = Math.pow(solution.getObjective(j), 2.0) / 4.0 - 1.0;
            for (i = 0; i < this.getNumberOfObjectives(); ++i) {
                if (i != j) {
                    sum += Math.pow(solution.getObjective(j), 2.0);
                }
                int n = j;
                constraint[n] = constraint[n] + sum;
            }
        }
        double overallConstraintViolation = 0.0;
        int violatedConstraints = 0;
        for (i = 0; i < this.getNumberOfConstraints(); ++i) {
            if (!(constraint[i] < 0.0)) continue;
            overallConstraintViolation += constraint[i];
            ++violatedConstraints;
        }
        this.overallConstraintViolationDegree.setAttribute(solution, overallConstraintViolation);
        this.numberOfViolatedConstraints.setAttribute(solution, violatedConstraints);
    }
}

