/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.maf;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class MaF03
extends AbstractDoubleProblem {
    public MaF03() {
        this(12, 3);
    }

    public MaF03(Integer numberOfVariables, Integer numberOfObjectives) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setNumberOfConstraints(0);
        this.setName("MaF03");
        ArrayList<Double> lower = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upper = new ArrayList<Double>(this.getNumberOfVariables());
        for (int var = 0; var < numberOfVariables; ++var) {
            lower.add(0.0);
            upper.add(1.0);
        }
        this.setLowerLimit(lower);
        this.setUpperLimit(upper);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        int i;
        int numberOfVariables = solution.getNumberOfVariables();
        int numberOfObjectives = solution.getNumberOfObjectives();
        double[] x = new double[numberOfVariables];
        double[] f = new double[numberOfObjectives];
        for (int i2 = 0; i2 < numberOfVariables; ++i2) {
            x[i2] = (Double)solution.getVariableValue(i2);
        }
        double g = 0.0;
        for (int i3 = numberOfObjectives - 1; i3 < numberOfVariables; ++i3) {
            g += Math.pow(x[i3] - 0.5, 2.0) - Math.cos(62.83185307179586 * (x[i3] - 0.5));
        }
        g = 100.0 * ((double)(numberOfVariables - numberOfObjectives + 1) + g);
        double subf1 = 1.0;
        double subf3 = 1.0 + g;
        f[numberOfObjectives - 1] = Math.pow(Math.sin(Math.PI * x[0] / 2.0) * subf3, 2.0);
        for (i = numberOfObjectives - 2; i > 0; --i) {
            f[i] = Math.pow((subf1 *= Math.cos(Math.PI * x[numberOfObjectives - i - 2] / 2.0)) * Math.sin(Math.PI * x[numberOfObjectives - i - 1] / 2.0) * subf3, 4.0);
        }
        f[0] = Math.pow(subf1 * Math.cos(Math.PI * x[numberOfObjectives - 2] / 2.0) * subf3, 4.0);
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

