/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.maf;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class MaF10
extends AbstractDoubleProblem {
    public static int K10;

    public MaF10() {
        this(12, 3);
    }

    public MaF10(Integer numberOfVariables, Integer numberOfObjectives) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setNumberOfConstraints(0);
        this.setName("MaF10");
        K10 = numberOfObjectives - 1;
        ArrayList<Double> lower = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upper = new ArrayList<Double>(this.getNumberOfVariables());
        for (int var = 0; var < numberOfVariables; ++var) {
            lower.add(0.0);
            upper.add(2.0 * (double)(var + 1));
        }
        this.setLowerLimit(lower);
        this.setUpperLimit(upper);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        int i;
        int i2;
        int numberOfVariables_ = solution.getNumberOfVariables();
        int numberOfObjectives_ = solution.getNumberOfObjectives();
        double[] x = new double[numberOfVariables_];
        double[] f = new double[numberOfObjectives_];
        for (int i3 = 0; i3 < numberOfVariables_; ++i3) {
            x[i3] = (Double)solution.getVariableValue(i3);
        }
        double[] z = new double[numberOfVariables_];
        double[] t1 = new double[numberOfVariables_];
        double[] t2 = new double[numberOfVariables_];
        double[] t3 = new double[numberOfVariables_];
        double[] t4 = new double[numberOfObjectives_];
        double[] y = new double[numberOfObjectives_];
        double sub1 = 0.0;
        double sub2 = 0.0;
        int lb = 0;
        int ub = 0;
        for (i2 = 0; i2 < K10; ++i2) {
            z[i2] = x[i2] / (double)(2 * i2 + 2);
            t1[i2] = z[i2];
            t2[i2] = t1[i2];
            t3[i2] = Math.pow(t2[i2], 0.02);
        }
        for (i2 = K10; i2 < numberOfVariables_; ++i2) {
            z[i2] = x[i2] / (double)(2 * i2 + 2);
            t1[i2] = Math.abs(z[i2] - 0.35) / Math.abs(Math.floor(0.35 - z[i2]) + 0.35);
            t2[i2] = 0.8 + 0.8 * (0.75 - t1[i2]) * Math.min(0.0, Math.floor(t1[i2] - 0.75)) / 0.75 - 0.2 * (t1[i2] - 0.85) * Math.min(0.0, Math.floor(0.85 - t1[i2])) / 0.15;
            t2[i2] = (double)Math.round(t2[i2] * 1000000.0) / 1000000.0;
            t3[i2] = Math.pow(t2[i2], 0.02);
        }
        for (i2 = 0; i2 < numberOfObjectives_ - 1; ++i2) {
            sub1 = 0.0;
            sub2 = 0.0;
            lb = i2 * K10 / (numberOfObjectives_ - 1) + 1;
            ub = (i2 + 1) * K10 / (numberOfObjectives_ - 1);
            for (int j = lb - 1; j < ub; ++j) {
                sub1 += (double)(2 * (j + 1)) * t3[j];
                sub2 += (double)(2 * (j + 1));
            }
            t4[i2] = sub1 / sub2;
        }
        lb = K10 + 1;
        ub = numberOfVariables_;
        sub1 = 0.0;
        sub2 = 0.0;
        for (int j = lb - 1; j < ub; ++j) {
            sub1 += (double)(2 * (j + 1)) * t3[j];
            sub2 += (double)(2 * (j + 1));
        }
        t4[numberOfObjectives_ - 1] = sub1 / sub2;
        for (i2 = 0; i2 < numberOfObjectives_ - 1; ++i2) {
            y[i2] = (t4[i2] - 0.5) * Math.max(1.0, t4[numberOfObjectives_ - 1]) + 0.5;
        }
        y[numberOfObjectives_ - 1] = t4[numberOfObjectives_ - 1];
        double subf1 = 1.0;
        f[numberOfObjectives_ - 1] = y[numberOfObjectives_ - 1] + (double)(2 * numberOfObjectives_) * (1.0 - y[0] - Math.cos(Math.PI * 10 * y[0] + 1.5707963267948966) / (Math.PI * 10));
        for (i = numberOfObjectives_ - 2; i > 0; --i) {
            f[i] = y[numberOfObjectives_ - 1] + (double)(2 * (i + 1)) * (subf1 *= 1.0 - Math.cos(Math.PI * y[numberOfObjectives_ - i - 2] / 2.0)) * (1.0 - Math.sin(Math.PI * y[numberOfObjectives_ - i - 1] / 2.0));
        }
        f[0] = y[numberOfObjectives_ - 1] + 2.0 * subf1 * (1.0 - Math.cos(Math.PI * y[numberOfObjectives_ - 2] / 2.0));
        for (i = 0; i < numberOfObjectives_; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

