/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.maf;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class MaF12
extends AbstractDoubleProblem {
    public static int K12;
    public static int L12;

    public MaF12() {
        this(12, 3);
    }

    public MaF12(Integer numberOfVariables, Integer numberOfObjectives) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setNumberOfConstraints(0);
        this.setName("MaF12");
        K12 = numberOfObjectives - 1;
        L12 = numberOfVariables - K12;
        ArrayList<Double> lower = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upper = new ArrayList<Double>(this.getNumberOfVariables());
        for (int var = 0; var < numberOfVariables; ++var) {
            lower.add(0.0);
            upper.add(2.0 * (double)(var + 1));
        }
        this.setLowerLimit(lower);
        this.setUpperLimit(upper);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        int i;
        double sub1;
        int i2;
        int numberOfVariables_ = solution.getNumberOfVariables();
        int numberOfObjectives_ = solution.getNumberOfObjectives();
        double[] x = new double[numberOfVariables_];
        double[] f = new double[numberOfObjectives_];
        for (int i3 = 0; i3 < numberOfVariables_; ++i3) {
            x[i3] = (Double)solution.getVariableValue(i3);
        }
        double subf1 = 1.0;
        double[] z = new double[numberOfVariables_];
        double[] t1 = new double[numberOfVariables_];
        double[] t2 = new double[numberOfVariables_];
        double[] t3 = new double[numberOfObjectives_];
        double[] y = new double[numberOfObjectives_];
        double sub2 = 0.0;
        int lb1 = 0;
        int ub1 = 0;
        int lb2 = 0;
        int ub2 = 0;
        for (i2 = 0; i2 < numberOfVariables_; ++i2) {
            z[i2] = x[i2] / (double)(2 * i2 + 2);
        }
        for (i2 = 0; i2 < numberOfVariables_ - 1; ++i2) {
            sub1 = 0.0;
            for (int j = i2 + 1; j < numberOfVariables_; ++j) {
                sub1 += z[j];
            }
            sub2 = sub1 / (double)(numberOfVariables_ - i2 - 1);
            t1[i2] = Math.pow(z[i2], 0.02 + 49.98 * (0.0196078431372549 - (1.0 - 2.0 * sub2) * Math.abs(Math.floor(0.5 - sub2) + 0.0196078431372549)));
        }
        t1[numberOfVariables_ - 1] = z[numberOfVariables_ - 1];
        for (i2 = 0; i2 < K12; ++i2) {
            t2[i2] = 1.0 + (Math.abs(t1[i2] - 0.35) - 0.001) * (349.95 * Math.floor(t1[i2] - 0.349) / 0.349 + 649.95 * Math.floor(0.351 - t1[i2]) / 0.649 + 1000.0);
        }
        for (i2 = K12; i2 < numberOfVariables_; ++i2) {
            t2[i2] = 0.010309278350515464 * (1.0 + Math.cos(383.27430373795477 * (0.5 - Math.abs(t1[i2] - 0.35) * 0.5 / (Math.floor(0.35 - t1[i2]) + 0.35))) + 380.0 * Math.pow(Math.abs(t1[i2] - 0.35) * 0.5 / (Math.floor(0.35 - t1[i2]) + 0.35), 2.0));
        }
        int p = 0;
        int h = 0;
        double sub3 = 0.0;
        double sub4 = 0.0;
        sub1 = Math.ceil(0.5 * (double)K12 / (double)(numberOfObjectives_ - 1)) * ((double)(1 + 2 * K12 / (numberOfObjectives_ - 1)) - 2.0 * Math.ceil(0.5 * (double)K12 / (double)(numberOfObjectives_ - 1)));
        sub2 = Math.ceil((double)L12 / 2.0) * ((double)(1 + 2 * L12) - 2.0 * Math.ceil((double)L12 / 2.0));
        lb2 = 0;
        ub2 = K12 / (numberOfObjectives_ - 1) - 2;
        for (i = 0; i < numberOfObjectives_ - 1; ++i) {
            sub4 = 0.0;
            lb1 = i * K12 / (numberOfObjectives_ - 1) + 1;
            ub1 = (i + 1) * K12 / (numberOfObjectives_ - 1);
            for (int j = lb1 - 1; j < ub1; ++j) {
                sub3 = 0.0;
                for (h = lb2; h <= ub2; ++h) {
                    p = lb1 + (j - lb1 + 1 + h) % (K12 / (numberOfObjectives_ - 1));
                    sub3 += Math.abs(t2[j] - t2[p - 1]);
                }
                sub4 += t2[j] + sub3;
            }
            t3[i] = sub4 / sub1;
        }
        lb1 = K12 + 1;
        ub1 = numberOfVariables_;
        lb2 = 0;
        ub2 = L12 - 2;
        sub3 = 0.0;
        sub4 = 0.0;
        for (int j = lb1 - 1; j < ub1; ++j) {
            for (h = j + 1; h < K12 + L12; ++h) {
                sub3 += Math.abs(t2[j] - t2[h]);
            }
            sub4 += t2[j];
        }
        t3[numberOfObjectives_ - 1] = (sub4 += sub3 * 2.0) / sub2;
        for (i = 0; i < numberOfObjectives_ - 1; ++i) {
            y[i] = (t3[i] - 0.5) * Math.max(1.0, t3[numberOfObjectives_ - 1]) + 0.5;
        }
        y[numberOfObjectives_ - 1] = t3[numberOfObjectives_ - 1];
        f[numberOfObjectives_ - 1] = y[numberOfObjectives_ - 1] + (double)(2 * numberOfObjectives_) * Math.cos(Math.PI * y[0] / 2.0);
        for (i = numberOfObjectives_ - 2; i > 0; --i) {
            f[i] = y[numberOfObjectives_ - 1] + (double)(2 * (i + 1)) * (subf1 *= Math.sin(Math.PI * y[numberOfObjectives_ - i - 2] / 2.0)) * Math.cos(Math.PI * y[numberOfObjectives_ - i - 1] / 2.0);
        }
        f[0] = y[numberOfObjectives_ - 1] + 2.0 * subf1 * Math.sin(Math.PI * y[numberOfObjectives_ - 2] / 2.0);
        for (i = 0; i < numberOfObjectives_; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

