/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.zdt;

import java.util.ArrayList;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT1;
import org.uma.jmetal.solution.DoubleSolution;

public class ZDT4
extends ZDT1 {
    public ZDT4() {
        this(10);
    }

    public ZDT4(Integer numberOfVariables) {
        super(numberOfVariables);
        this.setName("ZDT4");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-5.0);
            upperLimit.add(5.0);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public double evalG(DoubleSolution solution) {
        double g = 0.0;
        for (int var = 1; var < solution.getNumberOfVariables(); ++var) {
            g += Math.pow((Double)solution.getVariableValue(var), 2.0) + -10.0 * Math.cos(Math.PI * 4 * (Double)solution.getVariableValue(var));
        }
        double constant = 1.0 + 10.0 * (double)(solution.getNumberOfVariables() - 1);
        return g + constant;
    }

    @Override
    public double evalH(double f, double g) {
        return 1.0 - Math.sqrt(f / g);
    }
}

