/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.qualityindicator.impl.GenericIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontUtils;
import org.uma.jmetal.util.point.Point;
import org.uma.jmetal.util.point.impl.ArrayPoint;
import org.uma.jmetal.util.point.util.comparator.LexicographicalPointComparator;
import org.uma.jmetal.util.point.util.comparator.PointDimensionComparator;
import org.uma.jmetal.util.point.util.distance.EuclideanDistance;

public class GeneralizedSpread<S extends Solution<?>>
extends GenericIndicator<S> {
    public GeneralizedSpread() {
    }

    public GeneralizedSpread(String referenceParetoFrontFile) throws FileNotFoundException {
        super(referenceParetoFrontFile);
    }

    public GeneralizedSpread(Front referenceParetoFront) {
        super(referenceParetoFront);
    }

    @Override
    public Double evaluate(List<S> solutionList) {
        return this.generalizedSpread(new ArrayFront(solutionList), this.referenceParetoFront);
    }

    public double generalizedSpread(Front front, Front referenceFront) {
        int numberOfObjectives = front.getPoint(0).getDimension();
        Point[] extremeValues = new Point[numberOfObjectives];
        for (int i = 0; i < numberOfObjectives; ++i) {
            referenceFront.sort(new PointDimensionComparator(i));
            ArrayPoint newPoint = new ArrayPoint(numberOfObjectives);
            for (int j = 0; j < numberOfObjectives; ++j) {
                newPoint.setValue(j, referenceFront.getPoint(referenceFront.getNumberOfPoints() - 1).getValue(j));
            }
            extremeValues[i] = newPoint;
        }
        int numberOfPoints = front.getNumberOfPoints();
        front.sort(new LexicographicalPointComparator());
        if (new EuclideanDistance().compute(front.getPoint(0), front.getPoint(front.getNumberOfPoints() - 1)) == 0.0) {
            return 1.0;
        }
        double dmean = 0.0;
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            dmean += FrontUtils.distanceToNearestPoint(front.getPoint(i), front);
        }
        dmean /= (double)numberOfPoints;
        double dExtrems = 0.0;
        for (int i = 0; i < extremeValues.length; ++i) {
            dExtrems += FrontUtils.distanceToClosestPoint(extremeValues[i], front);
        }
        double mean = 0.0;
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            mean += Math.abs(FrontUtils.distanceToNearestPoint(front.getPoint(i), front) - dmean);
        }
        return (dExtrems + mean) / (dExtrems + (double)numberOfPoints * dmean);
    }

    @Override
    public String getName() {
        return "GSPREAD";
    }

    @Override
    public String getDescription() {
        return "Generalized Spread quality indicator";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }
}

