/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;

public class SetCoverage
extends SimpleDescribedEntity
implements QualityIndicator<Pair<? extends List<? extends Solution<?>>, ? extends List<? extends Solution<?>>>, Pair<Double, Double>> {
    public SetCoverage() {
        super("SC", "Set coverage");
    }

    @Override
    public Pair<Double, Double> evaluate(Pair<? extends List<? extends Solution<?>>, ? extends List<? extends Solution<?>>> pairOfSolutionLists) {
        List<? extends Solution<?>> front1 = pairOfSolutionLists.getLeft();
        List<? extends Solution<?>> front2 = pairOfSolutionLists.getRight();
        if (front1 == null) {
            throw new JMetalException("The first front is null");
        }
        if (front2 == null) {
            throw new JMetalException("The second front is null");
        }
        return new ImmutablePair<Double, Double>(this.evaluate(front1, front2), this.evaluate(front2, front1));
    }

    public double evaluate(List<? extends Solution<?>> set1, List<? extends Solution<?>> set2) {
        double result;
        int sum = 0;
        if (set2.size() == 0) {
            result = set1.size() == 0 ? 0.0 : 1.0;
        } else {
            for (Solution<?> solution : set2) {
                if (!SolutionListUtils.isSolutionDominatedBySolutionList(solution, set1)) continue;
                ++sum;
            }
            result = (double)sum / (double)set2.size();
        }
        return result;
    }

    @Override
    public String getName() {
        return super.getName();
    }
}

