/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.HashMap;
import java.util.Map;
import org.uma.jmetal.problem.BinaryProblem;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class DefaultBinarySolution
extends AbstractGenericSolution<BinarySet, BinaryProblem>
implements BinarySolution {
    public DefaultBinarySolution(BinaryProblem problem) {
        super(problem);
        this.initializeBinaryVariables(JMetalRandom.getInstance());
        this.initializeObjectiveValues();
    }

    public DefaultBinarySolution(DefaultBinarySolution solution) {
        super(solution.problem);
        int i;
        for (i = 0; i < ((BinaryProblem)this.problem).getNumberOfVariables(); ++i) {
            this.setVariableValue(i, (BinarySet)((BinarySet)solution.getVariableValue(i)).clone());
        }
        for (i = 0; i < ((BinaryProblem)this.problem).getNumberOfObjectives(); ++i) {
            this.setObjective(i, solution.getObjective(i));
        }
        this.attributes = new HashMap(solution.attributes);
    }

    private static BinarySet createNewBitSet(int numberOfBits, JMetalRandom randomGenerator) {
        BinarySet bitSet = new BinarySet(numberOfBits);
        for (int i = 0; i < numberOfBits; ++i) {
            double rnd = randomGenerator.nextDouble();
            if (rnd < 0.5) {
                bitSet.set(i);
                continue;
            }
            bitSet.clear(i);
        }
        return bitSet;
    }

    @Override
    public int getNumberOfBits(int index) {
        return ((BinarySet)this.getVariableValue(index)).getBinarySetLength();
    }

    public DefaultBinarySolution copy() {
        return new DefaultBinarySolution(this);
    }

    @Override
    public int getTotalNumberOfBits() {
        int sum = 0;
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            sum += ((BinarySet)this.getVariableValue(i)).getBinarySetLength();
        }
        return sum;
    }

    @Override
    public String getVariableValueString(int index) {
        String result = "";
        for (int i = 0; i < ((BinarySet)this.getVariableValue(index)).getBinarySetLength(); ++i) {
            result = ((BinarySet)this.getVariableValue(index)).get(i) ? result + "1" : result + "0";
        }
        return result;
    }

    private void initializeBinaryVariables(JMetalRandom randomGenerator) {
        for (int i = 0; i < ((BinaryProblem)this.problem).getNumberOfVariables(); ++i) {
            this.setVariableValue(i, DefaultBinarySolution.createNewBitSet(((BinaryProblem)this.problem).getNumberOfBits(i), randomGenerator));
        }
    }

    @Override
    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }
}

