/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.HashMap;
import java.util.Map;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class DefaultDoubleSolution
extends AbstractGenericSolution<Double, DoubleProblem>
implements DoubleSolution {
    public DefaultDoubleSolution(DoubleProblem problem) {
        super(problem);
        this.initializeDoubleVariables(JMetalRandom.getInstance());
        this.initializeObjectiveValues();
    }

    public DefaultDoubleSolution(DefaultDoubleSolution solution) {
        super(solution.problem);
        int i;
        for (i = 0; i < ((DoubleProblem)this.problem).getNumberOfVariables(); ++i) {
            this.setVariableValue(i, solution.getVariableValue(i));
        }
        for (i = 0; i < ((DoubleProblem)this.problem).getNumberOfObjectives(); ++i) {
            this.setObjective(i, solution.getObjective(i));
        }
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public Double getUpperBound(int index) {
        return (Double)((DoubleProblem)this.problem).getUpperBound(index);
    }

    @Override
    public Double getLowerBound(int index) {
        return (Double)((DoubleProblem)this.problem).getLowerBound(index);
    }

    public DefaultDoubleSolution copy() {
        return new DefaultDoubleSolution(this);
    }

    @Override
    public String getVariableValueString(int index) {
        return ((Double)this.getVariableValue(index)).toString();
    }

    private void initializeDoubleVariables(JMetalRandom randomGenerator) {
        for (int i = 0; i < ((DoubleProblem)this.problem).getNumberOfVariables(); ++i) {
            Double value = randomGenerator.nextDouble(this.getLowerBound(i), this.getUpperBound(i));
            this.setVariableValue(i, value);
        }
    }

    @Override
    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }
}

