/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.HashMap;
import java.util.Map;
import org.uma.jmetal.problem.IntegerProblem;
import org.uma.jmetal.solution.IntegerSolution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class DefaultIntegerSolution
extends AbstractGenericSolution<Integer, IntegerProblem>
implements IntegerSolution {
    public DefaultIntegerSolution(IntegerProblem problem) {
        super(problem);
        this.initializeIntegerVariables(JMetalRandom.getInstance());
        this.initializeObjectiveValues();
    }

    public DefaultIntegerSolution(DefaultIntegerSolution solution) {
        super(solution.problem);
        int i;
        for (i = 0; i < ((IntegerProblem)this.problem).getNumberOfVariables(); ++i) {
            this.setVariableValue(i, solution.getVariableValue(i));
        }
        for (i = 0; i < ((IntegerProblem)this.problem).getNumberOfObjectives(); ++i) {
            this.setObjective(i, solution.getObjective(i));
        }
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public Integer getUpperBound(int index) {
        return (Integer)((IntegerProblem)this.problem).getUpperBound(index);
    }

    @Override
    public Integer getLowerBound(int index) {
        return (Integer)((IntegerProblem)this.problem).getLowerBound(index);
    }

    public DefaultIntegerSolution copy() {
        return new DefaultIntegerSolution(this);
    }

    @Override
    public String getVariableValueString(int index) {
        return ((Integer)this.getVariableValue(index)).toString();
    }

    private void initializeIntegerVariables(JMetalRandom randomGenerator) {
        for (int i = 0; i < ((IntegerProblem)this.problem).getNumberOfVariables(); ++i) {
            Integer value = randomGenerator.nextInt(this.getLowerBound(i), this.getUpperBound(i));
            this.setVariableValue(i, value);
        }
    }

    @Override
    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }
}

