/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.distance.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.distance.Distance;
import org.uma.jmetal.util.distance.impl.EuclideanDistanceBetweenSolutionsInSolutionSpace;

public class DistanceBetweenSolutionAndKNearestNeighbors<S extends Solution<Double>, L extends List<S>>
implements Distance<S, L> {
    private final int k;
    private Distance<S, S> distance;

    public DistanceBetweenSolutionAndKNearestNeighbors(int k, Distance<S, S> distance) {
        this.k = k;
        this.distance = distance;
    }

    public DistanceBetweenSolutionAndKNearestNeighbors(int k) {
        this(k, new EuclideanDistanceBetweenSolutionsInSolutionSpace());
    }

    @Override
    public double getDistance(S solution, L solutionList) {
        double result;
        List<Double> listOfDistances = this.knnDistances(solution, solutionList);
        listOfDistances.sort(Comparator.naturalOrder());
        int limit = Math.min(this.k, listOfDistances.size());
        if (limit == 0) {
            result = 0.0;
        } else {
            double sum = 0.0;
            for (int i = 0; i < limit; ++i) {
                sum += listOfDistances.get(i).doubleValue();
            }
            result = sum / (double)limit;
        }
        return result;
    }

    private List<Double> knnDistances(S solution, L solutionList) {
        ArrayList<Double> listOfDistances = new ArrayList<Double>();
        for (int i = 0; i < solutionList.size(); ++i) {
            double distanceBetweenSolutions = this.distance.getDistance(solution, solutionList.get(i));
            if (distanceBetweenSolutions == 0.0) continue;
            listOfDistances.add(distanceBetweenSolutions);
        }
        return listOfDistances;
    }
}

