/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment.component;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.uma.jmetal.qualityindicator.impl.GenericIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentComponent;
import org.uma.jmetal.util.experiment.util.ExperimentProblem;

public class GenerateBoxplotsWithR<Result extends List<? extends Solution<?>>>
implements ExperimentComponent {
    private static final String DEFAULT_R_DIRECTORY = "R";
    private final Experiment<?, Result> experiment;
    private int numberOfRows;
    private int numberOfColumns;
    private boolean displayNotch;

    public GenerateBoxplotsWithR(Experiment<?, Result> experimentConfiguration) {
        this.experiment = experimentConfiguration;
        this.displayNotch = false;
        this.numberOfRows = 3;
        this.numberOfColumns = 3;
        this.experiment.removeDuplicatedAlgorithms();
    }

    public GenerateBoxplotsWithR<Result> setRows(int rows) {
        this.numberOfRows = rows;
        return this;
    }

    public GenerateBoxplotsWithR<Result> setColumns(int columns) {
        this.numberOfColumns = columns;
        return this;
    }

    public GenerateBoxplotsWithR<Result> setDisplayNotch() {
        this.displayNotch = true;
        return this;
    }

    @Override
    public void run() throws IOException {
        String rDirectoryName = this.experiment.getExperimentBaseDirectory() + "/" + DEFAULT_R_DIRECTORY;
        File rOutput = new File(rDirectoryName);
        if (!rOutput.exists()) {
            new File(rDirectoryName).mkdirs();
            System.out.println("Creating " + rDirectoryName + " directory");
        }
        for (GenericIndicator<?> indicator : this.experiment.getIndicatorList()) {
            String rFileName = rDirectoryName + "/" + indicator.getName() + ".Boxplot.R";
            FileWriter os = new FileWriter(rFileName, false);
            Throwable throwable = null;
            try {
                int i;
                os.write("postscript(\"" + indicator.getName() + ".Boxplot.eps\", horizontal=FALSE, onefile=FALSE, height=8, width=12, pointsize=10)\n");
                os.write("resultDirectory<-\"../data\"\n");
                os.write("qIndicator <- function(indicator, problem)\n");
                os.write("{\n");
                for (i = 0; i < this.experiment.getAlgorithmList().size(); ++i) {
                    String algorithmName = this.experiment.getAlgorithmList().get(i).getAlgorithmTag();
                    os.write("file" + algorithmName + "<-paste(resultDirectory, \"" + algorithmName + "\", sep=\"/\")\n");
                    os.write("file" + algorithmName + "<-paste(file" + algorithmName + ", problem, sep=\"/\")\n");
                    os.write("file" + algorithmName + "<-paste(file" + algorithmName + ", indicator, sep=\"/\")\n");
                    os.write(algorithmName + "<-scan(file" + algorithmName + ")\n");
                    os.write("\n");
                }
                os.write("algs<-c(");
                for (i = 0; i < this.experiment.getAlgorithmList().size() - 1; ++i) {
                    os.write("\"" + this.experiment.getAlgorithmList().get(i).getAlgorithmTag() + "\",");
                }
                os.write("\"" + this.experiment.getAlgorithmList().get(this.experiment.getAlgorithmList().size() - 1).getAlgorithmTag() + "\")\n");
                os.write("boxplot(");
                for (i = 0; i < this.experiment.getAlgorithmList().size(); ++i) {
                    os.write(this.experiment.getAlgorithmList().get(i).getAlgorithmTag() + ",");
                }
                if (this.displayNotch) {
                    os.write("names=algs, notch = TRUE)\n");
                } else {
                    os.write("names=algs, notch = FALSE)\n");
                }
                os.write("titulo <-paste(indicator, problem, sep=\":\")\n");
                os.write("title(main=titulo)\n");
                os.write("}\n");
                os.write("par(mfrow=c(" + this.numberOfRows + "," + this.numberOfColumns + "))\n");
                os.write("indicator<-\"" + indicator.getName() + "\"\n");
                for (ExperimentProblem<?> problem : this.experiment.getProblemList()) {
                    os.write("qIndicator(indicator, \"" + problem.getTag() + "\")\n");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (os == null) continue;
                if (throwable != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                os.close();
            }
        }
    }
}

