/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment.component;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.uma.jmetal.qualityindicator.impl.GenericIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentComponent;
import org.uma.jmetal.util.experiment.util.ExperimentProblem;

public class GenerateWilcoxonTestTablesWithR<Result extends List<? extends Solution<?>>>
implements ExperimentComponent {
    private static final String DEFAULT_R_DIRECTORY = "R";
    private static final String APPEND_STRING = "\", append=TRUE)\n";
    private static final String END_JUMP_STRING = "}\n";
    private final Experiment<?, Result> experiment;

    public GenerateWilcoxonTestTablesWithR(Experiment<?, Result> experimentConfiguration) {
        this.experiment = experimentConfiguration;
        this.experiment.removeDuplicatedAlgorithms();
    }

    @Override
    public void run() throws IOException {
        String rDirectoryName = this.experiment.getExperimentBaseDirectory() + "/" + DEFAULT_R_DIRECTORY;
        File rOutput = new File(rDirectoryName);
        if (!rOutput.exists()) {
            new File(rDirectoryName).mkdirs();
            System.out.println("Creating " + rDirectoryName + " directory");
        }
        for (GenericIndicator<?> indicator : this.experiment.getIndicatorList()) {
            String rFileName = rDirectoryName + "/" + indicator.getName() + ".Wilcoxon.R";
            String latexFileName = rDirectoryName + "/" + indicator.getName() + ".Wilcoxon.tex";
            this.printHeaderLatexCommands(rFileName, latexFileName);
            this.printTableHeader(indicator, rFileName, latexFileName);
            this.printLines(indicator, rFileName, latexFileName);
            this.printTableTail(rFileName, latexFileName);
            this.printEndLatexCommands(rFileName, latexFileName);
            this.printGenerateMainScript(indicator, rFileName, latexFileName);
        }
    }

    private void printHeaderLatexCommands(String rFileName, String latexFileName) throws IOException {
        try (FileWriter os = new FileWriter(rFileName, false);){
            String output = "write(\"\", \"" + latexFileName + "\",append=FALSE)";
            os.write(output + "\n");
            String dataDirectory = this.experiment.getExperimentBaseDirectory() + "/data";
            os.write("resultDirectory<-\"" + dataDirectory + "\"\n");
            output = "latexHeader <- function() {\n  write(\"\\\\documentclass{article}\", \"" + latexFileName + APPEND_STRING + "  write(\"\\\\title{StandardStudy}\", \"" + latexFileName + APPEND_STRING + "  write(\"\\\\usepackage{amssymb}\", \"" + latexFileName + APPEND_STRING + "  write(\"\\\\author{A.J.Nebro}\", \"" + latexFileName + APPEND_STRING + "  write(\"\\\\begin{document}\", \"" + latexFileName + APPEND_STRING + "  write(\"\\\\maketitle\", \"" + latexFileName + APPEND_STRING + "  write(\"\\\\section{Tables}\", \"" + latexFileName + APPEND_STRING + "  write(\"\\\\\", \"" + latexFileName + APPEND_STRING + END_JUMP_STRING;
            os.write(output + "\n");
        }
    }

    private void printEndLatexCommands(String rFileName, String latexFileName) throws IOException {
        try (FileWriter os = new FileWriter(rFileName, true);){
            String output = "latexTail <- function() { \n  write(\"\\\\end{document}\", \"" + latexFileName + APPEND_STRING + END_JUMP_STRING;
            os.write(output + "\n");
        }
    }

    private void printTableHeader(GenericIndicator<?> indicator, String rFileName, String latexFileName) throws IOException {
        try (FileWriter os = new FileWriter(rFileName, true);){
            String latexTableLabel = "";
            String latexTableCaption = "";
            latexTableCaption = "  write(\"\\\\caption{\", \"" + latexFileName + APPEND_STRING + "  write(problem, \"" + latexFileName + APPEND_STRING + "  write(\"." + indicator.getName() + ".}\", \"" + latexFileName + APPEND_STRING;
            latexTableLabel = "  write(\"\\\\label{Table:\", \"" + latexFileName + APPEND_STRING + "  write(problem, \"" + latexFileName + "\", append=TRUE)\n  write(\"." + indicator.getName() + ".}\", \"" + latexFileName + APPEND_STRING;
            String output = "latexTableHeader <- function(problem, tabularString, latexTableFirstLine) {\n  write(\"\\\\begin{table}\", \"" + latexFileName + APPEND_STRING + latexTableCaption + "\n" + latexTableLabel + "\n  write(\"\\\\centering\", \"" + latexFileName + APPEND_STRING + "  write(\"\\\\begin{scriptsize}\", \"" + latexFileName + APPEND_STRING + "  write(\"\\\\begin{tabular}{\", \"" + latexFileName + APPEND_STRING + "  write(tabularString, \"" + latexFileName + APPEND_STRING + "  write(\"}\", \"" + latexFileName + APPEND_STRING + "  write(latexTableFirstLine, \"" + latexFileName + APPEND_STRING + "  write(\"\\\\hline \", \"" + latexFileName + APPEND_STRING + END_JUMP_STRING;
            os.write(output + "\n");
        }
    }

    private void printTableTail(String rFileName, String latexFileName) throws IOException {
        try (FileWriter os = new FileWriter(rFileName, true);){
            String output = "latexTableTail <- function() { \n  write(\"\\\\hline\", \"" + latexFileName + APPEND_STRING + "  write(\"\\\\end{tabular}\", \"" + latexFileName + APPEND_STRING + "  write(\"\\\\end{scriptsize}\", \"" + latexFileName + APPEND_STRING + "  write(\"\\\\end{table}\", \"" + latexFileName + APPEND_STRING + END_JUMP_STRING;
            os.write(output + "\n");
        }
    }

    private void printLines(GenericIndicator<?> indicator, String rFileName, String latexFileName) throws IOException {
        try (FileWriter os = new FileWriter(rFileName, true);){
            String output = indicator.isTheLowerTheIndicatorValueTheBetter() ? "printTableLine <- function(indicator, algorithm1, algorithm2, i, j, problem) { \n  file1<-paste(resultDirectory, algorithm1, sep=\"/\")\n  file1<-paste(file1, problem, sep=\"/\")\n  file1<-paste(file1, indicator, sep=\"/\")\n  data1<-scan(file1)\n  file2<-paste(resultDirectory, algorithm2, sep=\"/\")\n  file2<-paste(file2, problem, sep=\"/\")\n  file2<-paste(file2, indicator, sep=\"/\")\n  data2<-scan(file2)\n  if (i == j) {\n    write(\"-- \", \"" + latexFileName + APPEND_STRING + "  }\n  else if (i < j) {\n    if (is.finite(wilcox.test(data1, data2)$p.value) & wilcox.test(data1, data2)$p.value <= 0.05) {\n      if (median(data1) <= median(data2)) {\n        write(\"$\\\\blacktriangle$\", \"" + latexFileName + APPEND_STRING + END_JUMP_STRING + "      else {\n        write(\"$\\\\triangledown$\", \"" + latexFileName + APPEND_STRING + END_JUMP_STRING + "    }\n    else {\n      write(\"--\", \"" + latexFileName + APPEND_STRING + "    }\n  }\n  else {\n    write(\" \", \"" + latexFileName + APPEND_STRING + "  }\n}\n" : "printTableLine <- function(indicator, algorithm1, algorithm2, i, j, problem) { \n  file1<-paste(resultDirectory, algorithm1, sep=\"/\")\n  file1<-paste(file1, problem, sep=\"/\")\n  file1<-paste(file1, indicator, sep=\"/\")\n  data1<-scan(file1)\n  file2<-paste(resultDirectory, algorithm2, sep=\"/\")\n  file2<-paste(file2, problem, sep=\"/\")\n  file2<-paste(file2, indicator, sep=\"/\")\n  data2<-scan(file2)\n  if (i == j) {\n    write(\"--\", \"" + latexFileName + APPEND_STRING + "  }\n  else if (i < j) {\n    if (is.finite(wilcox.test(data1, data2)$p.value) & wilcox.test(data1, data2)$p.value <= 0.05) {\n      if (median(data1) >= median(data2)) {\n        write(\"$\\\\blacktriangle$\", \"" + latexFileName + APPEND_STRING + END_JUMP_STRING + "      else {\n        write(\"$\\\\triangledown$\", \"" + latexFileName + APPEND_STRING + END_JUMP_STRING + END_JUMP_STRING + "    else {\n      write(\"$-$\", \"" + latexFileName + APPEND_STRING + END_JUMP_STRING + "  }\n  else {\n    write(\" \", \"" + latexFileName + APPEND_STRING + "  }\n}\n";
            os.write(output + "\n");
        }
    }

    private void printGenerateMainScript(GenericIndicator<?> indicator, String rFileName, String latexFileName) throws IOException {
        try (FileWriter os = new FileWriter(rFileName, true);){
            int i;
            String output = "### START OF SCRIPT ";
            os.write(output + "\n");
            String problemList = "problemList <-c(";
            String algorithmList = "algorithmList <-c(";
            for (i = 0; i < this.experiment.getProblemList().size() - 1; ++i) {
                problemList = problemList + "\"" + this.experiment.getProblemList().get(i).getTag() + "\", ";
            }
            problemList = problemList + "\"" + this.experiment.getProblemList().get(this.experiment.getProblemList().size() - 1).getTag() + "\") ";
            for (i = 0; i < this.experiment.getAlgorithmList().size() - 1; ++i) {
                algorithmList = algorithmList + "\"" + this.experiment.getAlgorithmList().get(i).getAlgorithmTag() + "\", ";
            }
            algorithmList = algorithmList + "\"" + this.experiment.getAlgorithmList().get(this.experiment.getAlgorithmList().size() - 1).getAlgorithmTag() + "\") ";
            String latexTabularAlignment = "l";
            for (int i2 = 1; i2 < this.experiment.getAlgorithmList().size(); ++i2) {
                latexTabularAlignment = latexTabularAlignment + "c";
            }
            latexTabularAlignment = "l";
            String latexTableFirstLine = "\\\\hline ";
            for (int i3 = 1; i3 < this.experiment.getAlgorithmList().size(); ++i3) {
                latexTabularAlignment = latexTabularAlignment + "c";
                latexTableFirstLine = latexTableFirstLine + " & " + this.experiment.getAlgorithmList().get(i3).getAlgorithmTag();
            }
            latexTableFirstLine = latexTableFirstLine + "\\\\\\\\ \"";
            String tabularString = "tabularString <-c(\"" + latexTabularAlignment + "\") ";
            String tableFirstLine = "latexTableFirstLine <-c(\"" + latexTableFirstLine + ") ";
            output = "# Constants\n" + problemList + "\n" + algorithmList + "\n" + tabularString + "\n" + tableFirstLine + "\nindicator<-\"" + indicator.getName() + "\"";
            os.write(output + "\n");
            output = "\n # Step 1.  Writes the latex header\nlatexHeader()";
            os.write(output + "\n");
            problemList = "";
            for (ExperimentProblem<?> problem : this.experiment.getProblemList()) {
                problemList = problemList + problem.getTag() + " ";
            }
            latexTabularAlignment = "| l | ";
            latexTableFirstLine = "\\\\hline \\\\multicolumn{1}{|c|}{}";
            for (int i4 = 1; i4 < this.experiment.getAlgorithmList().size(); ++i4) {
                latexTabularAlignment = latexTabularAlignment + StringUtils.repeat("p{0.15cm }", this.experiment.getProblemList().size());
                latexTableFirstLine = latexTableFirstLine + " & \\\\multicolumn{" + this.experiment.getProblemList().size() + "}{c|}{" + this.experiment.getAlgorithmList().get(i4).getAlgorithmTag() + "}";
                latexTabularAlignment = latexTabularAlignment + " | ";
            }
            latexTableFirstLine = latexTableFirstLine + " \\\\\\\\";
            tabularString = "tabularString <-c(\"" + latexTabularAlignment + "\") ";
            latexTableFirstLine = "latexTableFirstLine <-c(\"" + latexTableFirstLine + "\") ";
            output = tabularString;
            os.write(output + "\n\n");
            output = latexTableFirstLine;
            os.write(output + "\n\n");
            output = "# Step 3. Problem loop \nlatexTableHeader(\"" + problemList + "\", tabularString, latexTableFirstLine)\n\nindx = 0\nfor (i in algorithmList) {\n  if (i != \"" + this.experiment.getAlgorithmList().get(this.experiment.getAlgorithmList().size() - 1).getAlgorithmTag() + "\") {\n    write(i , \"" + latexFileName + APPEND_STRING + "    write(\" & \", \"" + latexFileName + APPEND_STRING + "\n    jndx = 0\n    for (j in algorithmList) {\n      for (problem in problemList) {\n        if (jndx != 0) {\n          if (i != j) {\n            printTableLine(indicator, i, j, indx, jndx, problem)\n          }\n          else {\n            write(\"  \", \"" + latexFileName + APPEND_STRING + "          } \n          if (problem == \"" + this.experiment.getProblemList().get(this.experiment.getProblemList().size() - 1).getTag() + "\") {\n            if (j == \"" + this.experiment.getAlgorithmList().get(this.experiment.getAlgorithmList().size() - 1).getAlgorithmTag() + "\") {\n              write(\" \\\\\\\\ \", \"" + latexFileName + APPEND_STRING + "            } \n            else {\n              write(\" & \", \"" + latexFileName + APPEND_STRING + "            }\n          }\n     else {\n    write(\"&\", \"" + latexFileName + APPEND_STRING + "     }\n        }\n      }\n      jndx = jndx + 1\n" + END_JUMP_STRING + "    indx = indx + 1\n  }\n} # for algorithm\n\n  latexTableTail()\n";
            os.write(output + "\n");
            output = "#Step 3. Writes the end of latex file \nlatexTail()\n";
            os.write(output + "\n");
        }
    }
}

