/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.point.util.distance;

import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.point.Point;
import org.uma.jmetal.util.point.util.distance.PointDistance;

public class DominanceDistance
implements PointDistance {
    @Override
    public double compute(Point a2, Point b) {
        if (a2 == null) {
            throw new JMetalException("The first point is null");
        }
        if (b == null) {
            throw new JMetalException("The second point is null");
        }
        if (a2.getDimension() != b.getDimension()) {
            throw new JMetalException("The dimensions of the points are different: " + a2.getDimension() + ", " + b.getDimension());
        }
        double distance = 0.0;
        for (int i = 0; i < a2.getDimension(); ++i) {
            double max = Math.max(b.getValue(i) - a2.getValue(i), 0.0);
            distance += Math.pow(max, 2.0);
        }
        return Math.sqrt(distance);
    }
}

