/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.pseudorandom.impl;

import org.apache.commons.math3.random.Well44497b;
import org.uma.jmetal.util.pseudorandom.PseudoRandomGenerator;

public class Well44497bGenerator
implements PseudoRandomGenerator {
    private Well44497b rnd;
    private long seed;
    private static final String NAME = "Well44497b";

    public Well44497bGenerator() {
        this(System.currentTimeMillis());
    }

    public Well44497bGenerator(long seed) {
        this.seed = seed;
        this.rnd = new Well44497b(seed);
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public int nextInt(int lowerBound, int upperBound) {
        return lowerBound + this.rnd.nextInt(upperBound - lowerBound + 1);
    }

    @Override
    public double nextDouble(double lowerBound, double upperBound) {
        return lowerBound + this.rnd.nextDouble() * (upperBound - lowerBound);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(0.0, 1.0);
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
        this.rnd.setSeed(seed);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

