/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.solutionattribute.impl;

import java.util.List;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.solutionattribute.DensityEstimator;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;

public class DirScore<S extends Solution<?>>
extends GenericSolutionAttribute<S, Double>
implements DensityEstimator<S> {
    private double[][] referenceVectors;

    public DirScore(double[][] referenceVectors) {
        this.referenceVectors = referenceVectors;
    }

    @Override
    public void computeDensityEstimator(List<S> solutionSet) {
        int[] dirVector = this.computeDirVector(solutionSet);
        for (int i = 0; i < dirVector.length; ++i) {
            Solution solution = (Solution)solutionSet.get(i);
            solution.setAttribute("dir-score", 1.0 / (double)dirVector[i]);
        }
    }

    private int[] computeDirVector(List<S> solutionSet) {
        int[] dirVector = new int[solutionSet.size()];
        for (double[] vector : this.referenceVectors) {
            int minIndex = 0;
            double minDistance = Double.MAX_VALUE;
            for (int i = 0; i < solutionSet.size(); ++i) {
                Solution solution = (Solution)solutionSet.get(i);
                double distance = this.computeAngleDistance(vector, solution.getObjectives());
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                minIndex = i;
            }
            dirVector[minIndex] = dirVector[minIndex] + 1;
        }
        return dirVector;
    }

    private double computeAngleDistance(double[] vector, double[] objectives) {
        ArrayRealVector realVector = new ArrayRealVector(vector);
        ArrayRealVector objectVector = new ArrayRealVector(objectives);
        return 1.0 / realVector.cosine(objectVector);
    }
}

