/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.solutionattribute.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.solutionattribute.DensityEstimator;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;

public class StrengthRawFitness<S extends Solution<?>>
extends GenericSolutionAttribute<S, Double>
implements DensityEstimator<S> {
    private static final Comparator<Solution<?>> DOMINANCE_COMPARATOR = new DominanceComparator();
    private int k;

    public StrengthRawFitness(int k) {
        this.k = k;
    }

    public StrengthRawFitness() {
        this.k = 1;
    }

    @Override
    public void computeDensityEstimator(List<S> solutionSet) {
        int j;
        int i;
        double[][] distance = SolutionListUtils.distanceMatrix(solutionSet);
        double[] strength = new double[solutionSet.size()];
        double[] rawFitness = new double[solutionSet.size()];
        for (i = 0; i < solutionSet.size(); ++i) {
            for (j = 0; j < solutionSet.size(); ++j) {
                if (DOMINANCE_COMPARATOR.compare((Solution<?>)solutionSet.get(i), (Solution<?>)solutionSet.get(j)) != -1) continue;
                int n = i;
                strength[n] = strength[n] + 1.0;
            }
        }
        for (i = 0; i < solutionSet.size(); ++i) {
            for (j = 0; j < solutionSet.size(); ++j) {
                if (DOMINANCE_COMPARATOR.compare((Solution<?>)solutionSet.get(i), (Solution<?>)solutionSet.get(j)) != 1) continue;
                int n = i;
                rawFitness[n] = rawFitness[n] + strength[j];
            }
        }
        for (i = 0; i < distance.length; ++i) {
            Arrays.sort(distance[i]);
            double kDistance = 1.0 / (distance[i][this.k] + 2.0);
            ((Solution)solutionSet.get(i)).setAttribute(this.getAttributeIdentifier(), rawFitness[i] + kDistance);
        }
    }

    public int getK() {
        return this.k;
    }
}

