/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.visualize.Plot2D;
import weka.gui.visualize.VisualizeUtils;

public class ClassPanel
extends JPanel {
    private static final long serialVersionUID = -7969401840501661430L;
    private boolean m_isEnabled = false;
    private boolean m_isNumeric = false;
    private final int m_spectrumHeight = 5;
    private double m_maxC;
    private double m_minC;
    private final int m_tickSize = 5;
    private FontMetrics m_labelMetrics = null;
    private Font m_labelFont = null;
    private int m_HorizontalPad = 0;
    private int m_precisionC;
    private int m_oldWidth = -9000;
    private Instances m_Instances = null;
    private int m_cIndex;
    private ArrayList<Color> m_colorList;
    private final ArrayList<Component> m_Repainters = new ArrayList();
    private final ArrayList<ActionListener> m_ColourChangeListeners = new ArrayList();
    protected Color[] m_DefaultColors = new Color[]{Color.blue, Color.red, Color.green, Color.cyan, Color.pink, new Color(255, 0, 255), Color.orange, new Color(255, 0, 0), new Color(0, 255, 0), Color.white};
    protected Color m_backgroundColor = null;

    public ClassPanel() {
        this((Color)null);
    }

    public ClassPanel(Color background) {
        this.m_backgroundColor = background;
        this.m_colorList = new ArrayList(10);
        for (int noa = this.m_colorList.size(); noa < 10; ++noa) {
            Color pc = this.m_DefaultColors[noa % 10];
            int ija = noa / 10;
            ija *= 2;
            for (int j = 0; j < ija; ++j) {
                pc = pc.darker();
            }
            this.m_colorList.add(pc);
        }
    }

    public void addRepaintNotify(Component c) {
        this.m_Repainters.add(c);
    }

    public void addActionListener(ActionListener a2) {
        this.m_ColourChangeListeners.add(a2);
    }

    private void setFonts(Graphics gx) {
        if (this.m_labelMetrics == null) {
            this.m_labelFont = new Font("Monospaced", 0, 12);
            this.m_labelMetrics = gx.getFontMetrics(this.m_labelFont);
            int hf = this.m_labelMetrics.getAscent();
            if (this.getHeight() < 3 * hf) {
                this.m_labelFont = new Font("Monospaced", 0, 11);
                this.m_labelMetrics = gx.getFontMetrics(this.m_labelFont);
            }
        }
        gx.setFont(this.m_labelFont);
    }

    public void setOn(boolean e) {
        this.m_isEnabled = e;
    }

    public void setInstances(Instances insts) {
        this.m_Instances = insts;
    }

    public void setCindex(int cIndex) {
        if (this.m_Instances.numAttributes() > 0) {
            this.m_cIndex = cIndex;
            if (this.m_Instances.attribute(this.m_cIndex).isNumeric()) {
                this.setNumeric();
            } else {
                if (this.m_Instances.attribute(this.m_cIndex).numValues() > this.m_colorList.size()) {
                    this.extendColourMap();
                }
                this.setNominal();
            }
        }
    }

    private void extendColourMap() {
        if (this.m_Instances.attribute(this.m_cIndex).isNominal()) {
            for (int i = this.m_colorList.size(); i < this.m_Instances.attribute(this.m_cIndex).numValues(); ++i) {
                Color pc = this.m_DefaultColors[i % 10];
                int ija = i / 10;
                ija *= 2;
                for (int j = 0; j < ija; ++j) {
                    pc = pc.brighter();
                }
                if (this.m_backgroundColor != null) {
                    pc = Plot2D.checkAgainstBackground(pc, this.m_backgroundColor);
                }
                this.m_colorList.add(pc);
            }
        }
    }

    protected void setDefaultColourList(Color[] list) {
        this.m_DefaultColors = list;
    }

    public void setColours(ArrayList<Color> cols) {
        this.m_colorList = cols;
    }

    protected void setNominal() {
        this.m_isNumeric = false;
        this.m_HorizontalPad = 0;
        this.setOn(true);
        this.m_oldWidth = -9000;
        this.repaint();
    }

    protected void setNumeric() {
        this.m_isNumeric = true;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            if (this.m_Instances.instance(i).isMissing(this.m_cIndex)) continue;
            double value = this.m_Instances.instance(i).value(this.m_cIndex);
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        if (min == Double.POSITIVE_INFINITY) {
            max = 0.0;
            min = 0.0;
        }
        this.m_minC = min;
        this.m_maxC = max;
        int whole = (int)Math.abs(this.m_maxC);
        double decimal = Math.abs(this.m_maxC) - (double)whole;
        int nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
        int n = this.m_precisionC = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_maxC)) / Math.log(10.0)) + 2 : 1;
        if (this.m_precisionC > VisualizeUtils.MAX_PRECISION) {
            this.m_precisionC = 1;
        }
        String maxStringC = Utils.doubleToString(this.m_maxC, nondecimal + 1 + this.m_precisionC, this.m_precisionC);
        if (this.m_labelMetrics != null) {
            this.m_HorizontalPad = this.m_labelMetrics.stringWidth(maxStringC);
        }
        whole = (int)Math.abs(this.m_minC);
        decimal = Math.abs(this.m_minC) - (double)whole;
        nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
        int n2 = this.m_precisionC = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_minC)) / Math.log(10.0)) + 2 : 1;
        if (this.m_precisionC > VisualizeUtils.MAX_PRECISION) {
            this.m_precisionC = 1;
        }
        maxStringC = Utils.doubleToString(this.m_minC, nondecimal + 1 + this.m_precisionC, this.m_precisionC);
        if (this.m_labelMetrics != null && this.m_labelMetrics.stringWidth(maxStringC) > this.m_HorizontalPad) {
            this.m_HorizontalPad = this.m_labelMetrics.stringWidth(maxStringC);
        }
        this.setOn(true);
        this.repaint();
    }

    protected void paintNominal(Graphics gx) {
        NomLabel jj;
        NomLabel jj2;
        int rm;
        int sw;
        String val;
        int i;
        this.setFonts(gx);
        int numClasses = this.m_Instances.attribute(this.m_cIndex).numValues();
        int maxLabelLen = 0;
        int idx = 0;
        int w = this.getWidth();
        int hf = this.m_labelMetrics.getAscent();
        for (int i2 = 0; i2 < numClasses; ++i2) {
            if (this.m_Instances.attribute(this.m_cIndex).value(i2).length() <= maxLabelLen) continue;
            maxLabelLen = this.m_Instances.attribute(this.m_cIndex).value(i2).length();
            idx = i2;
        }
        maxLabelLen = this.m_labelMetrics.stringWidth(this.m_Instances.attribute(this.m_cIndex).value(idx));
        int legendHeight = (w - 2 * this.m_HorizontalPad) / (maxLabelLen + 5) >= numClasses ? 1 : 2;
        int x = this.m_HorizontalPad;
        int y = 1 + hf;
        int numToDo = legendHeight == 1 ? numClasses : numClasses / 2;
        for (i = 0; i < numToDo; ++i) {
            gx.setColor(this.m_colorList.get(i));
            if (numToDo * maxLabelLen > w - this.m_HorizontalPad * 2) {
                val = this.m_Instances.attribute(this.m_cIndex).value(i);
                sw = this.m_labelMetrics.stringWidth(val);
                rm = 0;
                if (sw > (w - this.m_HorizontalPad * 2) / numToDo) {
                    int incr = sw / val.length();
                    rm = (sw - (w - this.m_HorizontalPad * 2) / numToDo) / incr;
                    if (rm <= 0) {
                        rm = 0;
                    }
                    if (rm >= val.length()) {
                        rm = val.length() - 1;
                    }
                    val = val.substring(0, val.length() - rm);
                    sw = this.m_labelMetrics.stringWidth(val);
                }
                jj2 = new NomLabel(val, i);
                jj2.setFont(gx.getFont());
                jj2.setSize(this.m_labelMetrics.stringWidth(jj2.getText()), this.m_labelMetrics.getAscent() + 4);
                this.add(jj2);
                jj2.setLocation(x, y);
                jj2.setForeground(this.m_colorList.get(i % this.m_colorList.size()));
                x += sw + 2;
                continue;
            }
            jj = new NomLabel(this.m_Instances.attribute(this.m_cIndex).value(i), i);
            jj.setFont(gx.getFont());
            jj.setSize(this.m_labelMetrics.stringWidth(jj.getText()), this.m_labelMetrics.getAscent() + 4);
            this.add(jj);
            jj.setLocation(x, y);
            jj.setForeground(this.m_colorList.get(i % this.m_colorList.size()));
            x += (w - this.m_HorizontalPad * 2) / numToDo;
        }
        x = this.m_HorizontalPad;
        y = 1 + hf + 5 + hf;
        for (i = numToDo; i < numClasses; ++i) {
            gx.setColor(this.m_colorList.get(i));
            if ((numClasses - numToDo + 1) * maxLabelLen > w - this.m_HorizontalPad * 2) {
                val = this.m_Instances.attribute(this.m_cIndex).value(i);
                sw = this.m_labelMetrics.stringWidth(val);
                rm = 0;
                if (sw > (w - this.m_HorizontalPad * 2) / (numClasses - numToDo + 1)) {
                    int incr = sw / val.length();
                    rm = (sw - (w - this.m_HorizontalPad * 2) / (numClasses - numToDo)) / incr;
                    if (rm <= 0) {
                        rm = 0;
                    }
                    if (rm >= val.length()) {
                        rm = val.length() - 1;
                    }
                    val = val.substring(0, val.length() - rm);
                    sw = this.m_labelMetrics.stringWidth(val);
                }
                jj2 = new NomLabel(val, i);
                jj2.setFont(gx.getFont());
                jj2.setSize(this.m_labelMetrics.stringWidth(jj2.getText()), this.m_labelMetrics.getAscent() + 4);
                this.add(jj2);
                jj2.setLocation(x, y);
                jj2.setForeground(this.m_colorList.get(i % this.m_colorList.size()));
                x += sw + 2;
                continue;
            }
            jj = new NomLabel(this.m_Instances.attribute(this.m_cIndex).value(i), i);
            jj.setFont(gx.getFont());
            jj.setSize(this.m_labelMetrics.stringWidth(jj.getText()), this.m_labelMetrics.getAscent() + 4);
            this.add(jj);
            jj.setLocation(x, y);
            jj.setForeground(this.m_colorList.get(i % this.m_colorList.size()));
            x += (w - this.m_HorizontalPad * 2) / (numClasses - numToDo);
        }
    }

    protected void paintNumeric(Graphics gx) {
        String maxStringC;
        int mswc;
        int tmsc;
        this.setFonts(gx);
        if (this.m_HorizontalPad == 0) {
            this.setCindex(this.m_cIndex);
        }
        int w = this.getWidth();
        double rs = 15.0;
        double incr = 240.0 / (double)(w - this.m_HorizontalPad * 2);
        int hf = this.m_labelMetrics.getAscent();
        for (int i = this.m_HorizontalPad; i < w - this.m_HorizontalPad; ++i) {
            Color c = new Color((int)rs, 150, (int)(255.0 - rs));
            gx.setColor(c);
            gx.drawLine(i, 0, i, 5);
            rs += incr;
        }
        int whole = (int)Math.abs(this.m_maxC);
        double decimal = Math.abs(this.m_maxC) - (double)whole;
        int nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
        int n = this.m_precisionC = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_maxC)) / Math.log(10.0)) + 2 : 1;
        if (this.m_precisionC > VisualizeUtils.MAX_PRECISION) {
            this.m_precisionC = 1;
        }
        if (w > 2 * (tmsc = (mswc = this.m_labelMetrics.stringWidth(maxStringC = Utils.doubleToString(this.m_maxC, nondecimal + 1 + this.m_precisionC, this.m_precisionC))))) {
            gx.setColor(Color.black);
            gx.drawLine(this.m_HorizontalPad, 10, w - this.m_HorizontalPad, 10);
            gx.drawLine(w - this.m_HorizontalPad, 10, w - this.m_HorizontalPad, 15);
            gx.drawString(maxStringC, w - this.m_HorizontalPad - mswc / 2, 15 + hf);
            gx.drawLine(this.m_HorizontalPad, 10, this.m_HorizontalPad, 15);
            whole = (int)Math.abs(this.m_minC);
            decimal = Math.abs(this.m_minC) - (double)whole;
            nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
            int n2 = this.m_precisionC = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_minC)) / Math.log(10.0)) + 2 : 1;
            if (this.m_precisionC > VisualizeUtils.MAX_PRECISION) {
                this.m_precisionC = 1;
            }
            maxStringC = Utils.doubleToString(this.m_minC, nondecimal + 1 + this.m_precisionC, this.m_precisionC);
            mswc = this.m_labelMetrics.stringWidth(maxStringC);
            gx.drawString(maxStringC, this.m_HorizontalPad - mswc / 2, 15 + hf);
            if (w > 3 * tmsc) {
                double mid = this.m_minC + (this.m_maxC - this.m_minC) / 2.0;
                gx.drawLine(this.m_HorizontalPad + (w - 2 * this.m_HorizontalPad) / 2, 10, this.m_HorizontalPad + (w - 2 * this.m_HorizontalPad) / 2, 15);
                whole = (int)Math.abs(mid);
                decimal = Math.abs(mid) - (double)whole;
                nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                int n3 = this.m_precisionC = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(mid)) / Math.log(10.0)) + 2 : 1;
                if (this.m_precisionC > VisualizeUtils.MAX_PRECISION) {
                    this.m_precisionC = 1;
                }
                maxStringC = Utils.doubleToString(mid, nondecimal + 1 + this.m_precisionC, this.m_precisionC);
                mswc = this.m_labelMetrics.stringWidth(maxStringC);
                gx.drawString(maxStringC, this.m_HorizontalPad + (w - 2 * this.m_HorizontalPad) / 2 - mswc / 2, 15 + hf);
            }
        }
    }

    @Override
    public void paintComponent(Graphics gx) {
        super.paintComponent(gx);
        if (this.m_isEnabled) {
            if (this.m_isNumeric) {
                this.m_oldWidth = -9000;
                this.removeAll();
                this.paintNumeric(gx);
            } else if (this.m_Instances != null && this.m_Instances.numInstances() > 0 && this.m_Instances.numAttributes() > 0 && this.m_oldWidth != this.getWidth()) {
                this.removeAll();
                this.m_oldWidth = this.getWidth();
                this.paintNominal(gx);
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.err.println("Usage : weka.gui.visualize.ClassPanel <dataset> [class col]");
                System.exit(1);
            }
            final JFrame jf = new JFrame("Weka Explorer: Class");
            jf.setSize(500, 100);
            jf.getContentPane().setLayout(new BorderLayout());
            ClassPanel p2 = new ClassPanel();
            jf.getContentPane().add((Component)p2, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            if (args.length >= 1) {
                System.err.println("Loading instances from " + args[0]);
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances(r);
                i.setClassIndex(i.numAttributes() - 1);
                p2.setInstances(i);
            }
            if (args.length > 1) {
                p2.setCindex(Integer.parseInt(args[1]) - 1);
            } else {
                p2.setCindex(0);
            }
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    private class NomLabel
    extends JLabel {
        private static final long serialVersionUID = -4686613106474820655L;
        private int m_index;

        public NomLabel(String name, int id) {
            super(name);
            this.m_index = 0;
            this.m_index = id;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Color tmp;
                    if ((e.getModifiers() & 0x10) == 16 && (tmp = JColorChooser.showDialog(ClassPanel.this, "Select new Color", (Color)ClassPanel.this.m_colorList.get(NomLabel.this.m_index))) != null) {
                        int i;
                        ClassPanel.this.m_colorList.set(NomLabel.this.m_index, tmp);
                        ClassPanel.this.m_oldWidth = -9000;
                        ClassPanel.this.repaint();
                        if (ClassPanel.this.m_Repainters.size() > 0) {
                            for (i = 0; i < ClassPanel.this.m_Repainters.size(); ++i) {
                                ((Component)ClassPanel.this.m_Repainters.get(i)).repaint();
                            }
                        }
                        if (ClassPanel.this.m_ColourChangeListeners.size() > 0) {
                            for (i = 0; i < ClassPanel.this.m_ColourChangeListeners.size(); ++i) {
                                ((ActionListener)ClassPanel.this.m_ColourChangeListeners.get(i)).actionPerformed(new ActionEvent(this, 0, ""));
                            }
                        }
                    }
                }
            });
        }
    }
}

