/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.reportng;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.velocity.VelocityContext;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestNGMethod;
import org.testng.Reporter;
import org.testng.xml.XmlSuite;
import org.uncommons.reportng.AbstractReporter;
import org.uncommons.reportng.ReportNGException;
import org.uncommons.reportng.TestMethodComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLReporter
extends AbstractReporter {
    private static final String FRAMES_PROPERTY = "org.uncommons.reportng.frames";
    private static final String TEMPLATES_PATH = "templates/html/";
    private static final String INDEX_FILE = "index.html";
    private static final String SUITES_FILE = "suites.html";
    private static final String OVERVIEW_FILE = "overview.html";
    private static final String GROUPS_FILE = "groups.html";
    private static final String RESULTS_FILE = "results.html";
    private static final String OUTPUT_FILE = "output.html";
    private static final String STYLE_FILE = "reportng.css";
    private static final String CUSTOM_STYLE_FILE = "custom.css";
    private static final String JS_FILE = "reportng.js";
    private static final String SUITE_KEY = "suite";
    private static final String SUITES_KEY = "suites";
    private static final String GROUPS_KEY = "groups";
    private static final String RESULT_KEY = "result";
    private static final String REPORT_DIRECTORY = "html";
    private static final Comparator<ITestNGMethod> METHOD_COMPARATOR = new TestMethodComparator();

    public HTMLReporter() {
        super(TEMPLATES_PATH);
    }

    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectoryName) {
        this.removeEmptyDirectories(new File(outputDirectoryName));
        boolean useFrames = System.getProperty(FRAMES_PROPERTY, "true").equals("true");
        File outputDirectory = new File(outputDirectoryName, REPORT_DIRECTORY);
        outputDirectory.mkdir();
        try {
            if (useFrames) {
                this.createFrameset(outputDirectory);
            }
            this.createOverview(suites, outputDirectory, !useFrames);
            this.createSuiteList(suites, outputDirectory);
            this.createGroups(suites, outputDirectory);
            this.createResults(suites, outputDirectory);
            this.createLog(outputDirectory);
            this.copyResources(outputDirectory);
        }
        catch (Exception ex) {
            throw new ReportNGException("Failed generating HTML report.", ex);
        }
    }

    private void createFrameset(File outputDirectory) throws Exception {
        VelocityContext context = this.createContext();
        this.generateFile(new File(outputDirectory, INDEX_FILE), "index.html.vm", context);
    }

    private void createOverview(List<ISuite> suites, File outputDirectory, boolean isIndex) throws Exception {
        VelocityContext context = this.createContext();
        context.put(SUITES_KEY, suites);
        this.generateFile(new File(outputDirectory, isIndex ? INDEX_FILE : OVERVIEW_FILE), "overview.html.vm", context);
    }

    private void createSuiteList(List<ISuite> suites, File outputDirectory) throws Exception {
        VelocityContext context = this.createContext();
        context.put(SUITES_KEY, suites);
        this.generateFile(new File(outputDirectory, SUITES_FILE), "suites.html.vm", context);
    }

    private void createResults(List<ISuite> suites, File outputDirectory) throws Exception {
        int index = 1;
        for (ISuite suite : suites) {
            int index2 = 1;
            for (ISuiteResult result : suite.getResults().values()) {
                VelocityContext context = this.createContext();
                context.put(RESULT_KEY, (Object)result);
                this.generateFile(new File(outputDirectory, SUITE_KEY + index + "_test" + index2 + '_' + RESULTS_FILE), "results.html.vm", context);
                ++index2;
            }
            ++index;
        }
    }

    private void createGroups(List<ISuite> suites, File outputDirectory) throws Exception {
        int index = 1;
        for (ISuite suite : suites) {
            SortedMap<String, SortedSet<ITestNGMethod>> groups = this.sortGroups(suite.getMethodsByGroups());
            if (!groups.isEmpty()) {
                VelocityContext context = this.createContext();
                context.put(SUITE_KEY, (Object)suite);
                context.put(GROUPS_KEY, groups);
                this.generateFile(new File(outputDirectory, SUITE_KEY + index + "_" + GROUPS_FILE), "groups.html.vm", context);
            }
            ++index;
        }
    }

    private void createLog(File outputDirectory) throws Exception {
        if (!Reporter.getOutput().isEmpty()) {
            VelocityContext context = this.createContext();
            this.generateFile(new File(outputDirectory, OUTPUT_FILE), "output.html.vm", context);
        }
    }

    private SortedMap<String, SortedSet<ITestNGMethod>> sortGroups(Map<String, Collection<ITestNGMethod>> groups) {
        TreeMap<String, SortedSet<ITestNGMethod>> sortedGroups = new TreeMap<String, SortedSet<ITestNGMethod>>();
        for (Map.Entry<String, Collection<ITestNGMethod>> entry : groups.entrySet()) {
            TreeSet<ITestNGMethod> methods = new TreeSet<ITestNGMethod>(METHOD_COMPARATOR);
            methods.addAll(entry.getValue());
            sortedGroups.put(entry.getKey(), methods);
        }
        return sortedGroups;
    }

    private void copyResources(File outputDirectory) throws IOException {
        this.copyClasspathResource(outputDirectory, STYLE_FILE, STYLE_FILE);
        this.copyClasspathResource(outputDirectory, JS_FILE, JS_FILE);
        File customStylesheet = META.getStylesheetPath();
        if (customStylesheet != null) {
            this.copyFile(outputDirectory, customStylesheet, CUSTOM_STYLE_FILE);
        }
    }
}

