/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.reportng;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class ReportMetadata {
    private static final String PROPERTY_KEY_PREFIX = "org.uncommons.reportng.";
    private static final String TITLE_KEY = "org.uncommons.reportng.title";
    private static final String DEFAULT_TITLE = "Test Results Report";
    private static final String COVERAGE_KEY = "org.uncommons.reportng.coverage-report";
    private static final String EXCEPTIONS_KEY = "org.uncommons.reportng.show-expected-exceptions";
    private static final String OUTPUT_KEY = "org.uncommons.reportng.escape-output";
    private static final String XML_DIALECT_KEY = "org.uncommons.reportng.xml-dialect";
    private static final String STYLESHEET_KEY = "org.uncommons.reportng.stylesheet";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEEE dd MMMM yyyy");
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm z");
    private final Date reportTime = new Date();

    public String getReportDate() {
        return DATE_FORMAT.format(this.reportTime);
    }

    public String getReportTime() {
        return TIME_FORMAT.format(this.reportTime);
    }

    public String getReportTitle() {
        return System.getProperty(TITLE_KEY, DEFAULT_TITLE);
    }

    public String getCoverageLink() {
        return System.getProperty(COVERAGE_KEY);
    }

    public File getStylesheetPath() {
        String path = System.getProperty(STYLESHEET_KEY);
        return path == null ? null : new File(path);
    }

    public boolean shouldShowExpectedExceptions() {
        return System.getProperty(EXCEPTIONS_KEY, "false").equalsIgnoreCase("true");
    }

    public boolean shouldEscapeOutput() {
        return System.getProperty(OUTPUT_KEY, "true").equalsIgnoreCase("true");
    }

    public boolean allowSkippedTestsInXML() {
        return !System.getProperty(XML_DIALECT_KEY, "testng").equalsIgnoreCase("junit");
    }

    public String getUser() throws UnknownHostException {
        String user = System.getProperty("user.name");
        String host = InetAddress.getLocalHost().getHostName();
        return user + "@" + host;
    }

    public String getJavaInfo() {
        String version = System.getProperty("java.version");
        String vendor = System.getProperty("java.vendor");
        return "Java " + version + " (" + vendor + ")";
    }

    public String getPlatform() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String architecture = System.getProperty("os.arch");
        return osName + " " + osVersion + " (" + architecture + ")";
    }
}

