/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.reportng;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ResourceBundle;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.testng.IReporter;
import org.uncommons.reportng.ReportMetadata;
import org.uncommons.reportng.ReportNGException;
import org.uncommons.reportng.ReportNGUtils;

public abstract class AbstractReporter
implements IReporter {
    private static final String ENCODING = "UTF-8";
    protected static final String TEMPLATE_EXTENSION = ".vm";
    private static final String META_KEY = "meta";
    protected static final ReportMetadata META = new ReportMetadata();
    private static final String UTILS_KEY = "utils";
    private static final ReportNGUtils UTILS = new ReportNGUtils();
    private static final String MESSAGES_KEY = "messages";
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("org.uncommons.reportng.messages.reportng", META.getLocale());
    private final String classpathPrefix;

    protected AbstractReporter(String classpathPrefix) {
        this.classpathPrefix = classpathPrefix;
        Velocity.setProperty((String)"resource.loader", (Object)"classpath");
        Velocity.setProperty((String)"classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        try {
            Velocity.init();
        }
        catch (Exception ex) {
            throw new ReportNGException("Failed to initialise Velocity.", ex);
        }
    }

    protected VelocityContext createContext() {
        VelocityContext context = new VelocityContext();
        context.put(META_KEY, (Object)META);
        context.put(UTILS_KEY, (Object)UTILS);
        context.put(MESSAGES_KEY, (Object)MESSAGES);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateFile(File file, String templateName, VelocityContext context) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            Velocity.mergeTemplate((String)(this.classpathPrefix + templateName), (String)ENCODING, (Context)context, (Writer)writer);
            ((Writer)writer).flush();
        }
        finally {
            ((Writer)writer).close();
        }
    }

    protected void copyClasspathResource(File outputDirectory, String resourceName, String targetFileName) throws IOException {
        String resourcePath = this.classpathPrefix + resourceName;
        InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        this.copyStream(outputDirectory, resourceStream, targetFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(File outputDirectory, File sourceFile, String targetFileName) throws IOException {
        FileInputStream fileStream = new FileInputStream(sourceFile);
        try {
            this.copyStream(outputDirectory, fileStream, targetFileName);
        }
        finally {
            ((InputStream)fileStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStream(File outputDirectory, InputStream stream, String targetFileName) throws IOException {
        File resourceFile = new File(outputDirectory, targetFileName);
        BufferedReader reader = null;
        Writer writer = null;
        try {
            reader = new BufferedReader(new InputStreamReader(stream, ENCODING));
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(resourceFile), ENCODING));
            String line = reader.readLine();
            while (line != null) {
                writer.write(line);
                writer.write(10);
                line = reader.readLine();
            }
            writer.flush();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected void removeEmptyDirectories(File outputDirectory) {
        for (File file : outputDirectory.listFiles(new EmptyDirectoryFilter())) {
            file.delete();
        }
    }

    private static final class EmptyDirectoryFilter
    implements FileFilter {
        private EmptyDirectoryFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() && file.listFiles().length == 0;
        }
    }
}

