/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.util.id;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.uncommons.util.id.IDSource;
import org.uncommons.util.id.IDSourceExhaustedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongSequenceIDSource
implements IDSource<Long> {
    private static final int SECONDS_IN_DAY = 86400;
    private final Lock lock = new ReentrantLock();
    private final long startTime;
    private long lastID = -1L;

    public LongSequenceIDSource(long firstValue) {
        if (firstValue < 0L) {
            throw new IllegalArgumentException("Initial value must be non-negative.");
        }
        this.lastID = firstValue - 1L;
        this.startTime = System.currentTimeMillis();
    }

    public LongSequenceIDSource() {
        this(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long nextID() {
        this.lock.lock();
        try {
            if (this.lastID == Long.MAX_VALUE) {
                long days = (System.currentTimeMillis() - this.startTime) / 86400L;
                throw new IDSourceExhaustedException("64-bit ID source exhausted after " + days + " days.");
            }
            ++this.lastID;
            Long l = this.lastID;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }
}

