/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.uncommons.watchmaker.framework.AbstractEvolutionEngine;
import org.uncommons.watchmaker.framework.CandidateFactory;
import org.uncommons.watchmaker.framework.EvaluatedCandidate;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;
import org.uncommons.watchmaker.framework.FitnessEvaluationWorker;
import org.uncommons.watchmaker.framework.FitnessEvaluator;
import org.uncommons.watchmaker.framework.FitnessEvalutationTask;
import org.uncommons.watchmaker.framework.NullFitnessEvaluator;
import org.uncommons.watchmaker.framework.SelectionStrategy;
import org.uncommons.watchmaker.framework.interactive.InteractiveSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentEvolutionEngine<T>
extends AbstractEvolutionEngine<T> {
    private static final FitnessEvaluationWorker WORKER = new FitnessEvaluationWorker();

    public ConcurrentEvolutionEngine(CandidateFactory<T> candidateFactory, EvolutionaryOperator<T> evolutionScheme, FitnessEvaluator<? super T> fitnessEvaluator, SelectionStrategy<? super T> selectionStrategy, Random rng) {
        super(candidateFactory, evolutionScheme, fitnessEvaluator, selectionStrategy, rng);
    }

    public ConcurrentEvolutionEngine(CandidateFactory<T> candidateFactory, EvolutionaryOperator<T> evolutionScheme, InteractiveSelection<T> selectionStrategy, Random rng) {
        this(candidateFactory, evolutionScheme, new NullFitnessEvaluator(), selectionStrategy, rng);
    }

    @Override
    protected List<EvaluatedCandidate<T>> evaluatePopulation(List<T> population) {
        ArrayList<EvaluatedCandidate<T>> evaluatedPopulation = new ArrayList<EvaluatedCandidate<T>>(population.size());
        try {
            List<T> unmodifiablePopulation = Collections.unmodifiableList(population);
            ArrayList results = new ArrayList(population.size());
            for (T t : population) {
                results.add(WORKER.submit(new FitnessEvalutationTask(this.getFitnessEvaluator(), t, unmodifiablePopulation)));
            }
            for (Future future : results) {
                evaluatedPopulation.add((EvaluatedCandidate<T>)future.get());
            }
            assert (evaluatedPopulation.size() == population.size()) : "Wrong number of evaluated candidates.";
        }
        catch (ExecutionException ex) {
            throw new IllegalStateException("Fitness evaluation task execution failed.", ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return evaluatedPopulation;
    }
}

