/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.uncommons.watchmaker.framework.CandidateFactory;
import org.uncommons.watchmaker.framework.EvaluatedCandidate;
import org.uncommons.watchmaker.framework.EvolutionEngine;
import org.uncommons.watchmaker.framework.EvolutionObserver;
import org.uncommons.watchmaker.framework.EvolutionUtils;
import org.uncommons.watchmaker.framework.FitnessEvaluationWorker;
import org.uncommons.watchmaker.framework.FitnessEvaluator;
import org.uncommons.watchmaker.framework.FitnessEvalutationTask;
import org.uncommons.watchmaker.framework.PopulationData;
import org.uncommons.watchmaker.framework.TerminationCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEvolutionEngine<T>
implements EvolutionEngine<T> {
    private static FitnessEvaluationWorker concurrentWorker = null;
    private final Set<EvolutionObserver<? super T>> observers = new CopyOnWriteArraySet<EvolutionObserver<? super T>>();
    private final Random rng;
    private final CandidateFactory<T> candidateFactory;
    private final FitnessEvaluator<? super T> fitnessEvaluator;
    private volatile boolean singleThreaded = false;
    private List<TerminationCondition> satisfiedTerminationConditions;

    protected AbstractEvolutionEngine(CandidateFactory<T> candidateFactory, FitnessEvaluator<? super T> fitnessEvaluator, Random rng) {
        this.candidateFactory = candidateFactory;
        this.fitnessEvaluator = fitnessEvaluator;
        this.rng = rng;
    }

    @Override
    public T evolve(int populationSize, int eliteCount, TerminationCondition ... conditions) {
        return this.evolve(populationSize, eliteCount, Collections.emptySet(), conditions);
    }

    @Override
    public T evolve(int populationSize, int eliteCount, Collection<T> seedCandidates, TerminationCondition ... conditions) {
        return this.evolvePopulation(populationSize, eliteCount, seedCandidates, conditions).get(0).getCandidate();
    }

    @Override
    public List<EvaluatedCandidate<T>> evolvePopulation(int populationSize, int eliteCount, TerminationCondition ... conditions) {
        return this.evolvePopulation(populationSize, eliteCount, Collections.emptySet(), conditions);
    }

    @Override
    public List<EvaluatedCandidate<T>> evolvePopulation(int populationSize, int eliteCount, Collection<T> seedCandidates, TerminationCondition ... conditions) {
        if (eliteCount < 0 || eliteCount >= populationSize) {
            throw new IllegalArgumentException("Elite count must be non-negative and less than population size.");
        }
        if (conditions.length == 0) {
            throw new IllegalArgumentException("At least one TerminationCondition must be specified.");
        }
        this.satisfiedTerminationConditions = null;
        int currentGenerationIndex = 0;
        long startTime = System.currentTimeMillis();
        List<T> population = this.candidateFactory.generateInitialPopulation(populationSize, seedCandidates, this.rng);
        List<EvaluatedCandidate<T>> evaluatedPopulation = this.evaluatePopulation(population);
        EvolutionUtils.sortEvaluatedPopulation(evaluatedPopulation, this.fitnessEvaluator.isNatural());
        PopulationData<T> data = EvolutionUtils.getPopulationData(evaluatedPopulation, this.fitnessEvaluator.isNatural(), eliteCount, currentGenerationIndex, startTime);
        this.notifyPopulationChange(data);
        List<TerminationCondition> satisfiedConditions = EvolutionUtils.shouldContinue(data, conditions);
        while (satisfiedConditions == null) {
            evaluatedPopulation = this.nextEvolutionStep(evaluatedPopulation, eliteCount, this.rng);
            EvolutionUtils.sortEvaluatedPopulation(evaluatedPopulation, this.fitnessEvaluator.isNatural());
            data = EvolutionUtils.getPopulationData(evaluatedPopulation, this.fitnessEvaluator.isNatural(), eliteCount, currentGenerationIndex, startTime);
            this.notifyPopulationChange(data);
            satisfiedConditions = EvolutionUtils.shouldContinue(data, conditions);
            ++currentGenerationIndex;
        }
        this.satisfiedTerminationConditions = satisfiedConditions;
        return evaluatedPopulation;
    }

    protected abstract List<EvaluatedCandidate<T>> nextEvolutionStep(List<EvaluatedCandidate<T>> var1, int var2, Random var3);

    protected List<EvaluatedCandidate<T>> evaluatePopulation(List<T> population) {
        ArrayList<EvaluatedCandidate<T>> evaluatedPopulation = new ArrayList<EvaluatedCandidate<T>>(population.size());
        if (this.singleThreaded) {
            for (T candidate : population) {
                evaluatedPopulation.add(new EvaluatedCandidate<T>(candidate, this.fitnessEvaluator.getFitness(candidate, population)));
            }
        } else {
            try {
                List<T> unmodifiablePopulation = Collections.unmodifiableList(population);
                ArrayList<Future<EvaluatedCandidate<? super T>>> results = new ArrayList<Future<EvaluatedCandidate<? super T>>>(population.size());
                for (T t : population) {
                    results.add(AbstractEvolutionEngine.getSharedWorker().submit(new FitnessEvalutationTask<T>(this.fitnessEvaluator, t, unmodifiablePopulation)));
                }
                for (Future future : results) {
                    evaluatedPopulation.add((EvaluatedCandidate<T>)future.get());
                }
            }
            catch (ExecutionException ex) {
                throw new IllegalStateException("Fitness evaluation task execution failed.", ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        return evaluatedPopulation;
    }

    @Override
    public List<TerminationCondition> getSatisfiedTerminationConditions() {
        if (this.satisfiedTerminationConditions == null) {
            throw new IllegalStateException("EvolutionEngine has not terminated.");
        }
        return Collections.unmodifiableList(this.satisfiedTerminationConditions);
    }

    @Override
    public void addEvolutionObserver(EvolutionObserver<? super T> observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeEvolutionObserver(EvolutionObserver<? super T> observer) {
        this.observers.remove(observer);
    }

    private void notifyPopulationChange(PopulationData<T> data) {
        for (EvolutionObserver<T> observer : this.observers) {
            observer.populationUpdate(data);
        }
    }

    public void setSingleThreaded(boolean singleThreaded) {
        this.singleThreaded = singleThreaded;
    }

    private static synchronized FitnessEvaluationWorker getSharedWorker() {
        if (concurrentWorker == null) {
            concurrentWorker = new FitnessEvaluationWorker();
        }
        return concurrentWorker;
    }
}

