/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.uncommons.maths.statistics.DataSet;
import org.uncommons.watchmaker.framework.EvaluatedCandidate;
import org.uncommons.watchmaker.framework.PopulationData;
import org.uncommons.watchmaker.framework.TerminationCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EvolutionUtils {
    private EvolutionUtils() {
    }

    public static <T> List<TerminationCondition> shouldContinue(PopulationData<T> data, TerminationCondition ... conditions) {
        if (Thread.currentThread().isInterrupted()) {
            return Collections.emptyList();
        }
        LinkedList<TerminationCondition> satisfiedConditions = new LinkedList<TerminationCondition>();
        for (TerminationCondition condition : conditions) {
            if (!condition.shouldTerminate(data)) continue;
            satisfiedConditions.add(condition);
        }
        return satisfiedConditions.isEmpty() ? null : satisfiedConditions;
    }

    public static <T> void sortEvaluatedPopulation(List<EvaluatedCandidate<T>> evaluatedPopulation, boolean naturalFitness) {
        if (naturalFitness) {
            Collections.sort(evaluatedPopulation, Collections.reverseOrder());
        } else {
            Collections.sort(evaluatedPopulation);
        }
    }

    public static <T> PopulationData<T> getPopulationData(List<EvaluatedCandidate<T>> evaluatedPopulation, boolean naturalFitness, int eliteCount, int iterationNumber, long startTime) {
        DataSet stats = new DataSet(evaluatedPopulation.size());
        for (EvaluatedCandidate<T> candidate : evaluatedPopulation) {
            stats.addValue(candidate.getFitness());
        }
        return new PopulationData<T>(evaluatedPopulation.get(0).getCandidate(), evaluatedPopulation.get(0).getFitness(), stats.getArithmeticMean(), stats.getStandardDeviation(), naturalFitness, stats.getSize(), eliteCount, iterationNumber, System.currentTimeMillis() - startTime);
    }
}

