/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework;

import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.uncommons.util.concurrent.ConfigurableThreadFactory;
import org.uncommons.util.id.IDSource;
import org.uncommons.util.id.IntSequenceIDSource;
import org.uncommons.util.id.StringPrefixIDSource;
import org.uncommons.watchmaker.framework.EvaluatedCandidate;
import org.uncommons.watchmaker.framework.FitnessEvalutationTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitnessEvaluationWorker {
    private static final IDSource<String> WORKER_ID_SOURCE = new StringPrefixIDSource("FitnessEvaluationWorker", new IntSequenceIDSource());
    private final LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue();
    private final ThreadPoolExecutor executor;

    FitnessEvaluationWorker() {
        this(true);
    }

    private FitnessEvaluationWorker(boolean daemonWorkerThreads) {
        ConfigurableThreadFactory threadFactory = new ConfigurableThreadFactory(WORKER_ID_SOURCE.nextID(), 5, daemonWorkerThreads);
        this.executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, this.workQueue, threadFactory);
        this.executor.prestartAllCoreThreads();
    }

    public <T> Future<EvaluatedCandidate<T>> submit(FitnessEvalutationTask<T> task) {
        return this.executor.submit(task);
    }

    public static void main(String[] args) {
        new FitnessEvaluationWorker(false);
    }

    protected void finalize() throws Throwable {
        this.executor.shutdown();
        super.finalize();
    }
}

