/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.number.ConstantGenerator;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListInversion<T>
implements EvolutionaryOperator<List<T>> {
    private final NumberGenerator<Probability> inversionProbability;

    public ListInversion(Probability inversionProbability) {
        this((NumberGenerator<Probability>)new ConstantGenerator((Number)inversionProbability));
    }

    public ListInversion(NumberGenerator<Probability> inversionProbability) {
        this.inversionProbability = inversionProbability;
    }

    @Override
    public List<List<T>> apply(List<List<T>> selectedCandidates, Random rng) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(selectedCandidates.size());
        for (List<T> candidate : selectedCandidates) {
            if (((Probability)this.inversionProbability.nextValue()).nextEvent(rng)) {
                int offset;
                ArrayList<T> newCandidate = new ArrayList<T>(candidate);
                int length = newCandidate.size();
                int start = rng.nextInt(length);
                int end = (start + (offset = 2 + rng.nextInt(length - 2))) % length;
                int segmentLength = end - start;
                if (segmentLength < 0) {
                    segmentLength += length;
                }
                for (int i = 0; i < segmentLength / 2; ++i) {
                    Collections.swap(newCandidate, (start + i) % length, (end - i + length) % length);
                }
                result.add(newCandidate);
                continue;
            }
            result.add(candidate);
        }
        return result;
    }
}

