/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.selection;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.uncommons.watchmaker.framework.EvaluatedCandidate;
import org.uncommons.watchmaker.framework.SelectionStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StochasticUniversalSampling
implements SelectionStrategy<Object> {
    @Override
    public <S> List<S> select(List<EvaluatedCandidate<S>> population, boolean naturalFitnessScores, int selectionSize, Random rng) {
        double aggregateFitness = 0.0;
        for (EvaluatedCandidate<S> candidate : population) {
            aggregateFitness += this.getAdjustedFitness(candidate.getFitness(), naturalFitnessScores);
        }
        ArrayList<S> selection = new ArrayList<S>(selectionSize);
        double startOffset = rng.nextDouble();
        double cumulativeExpectation = 0.0;
        int index = 0;
        for (EvaluatedCandidate<S> candidate : population) {
            cumulativeExpectation += this.getAdjustedFitness(candidate.getFitness(), naturalFitnessScores) / aggregateFitness * (double)selectionSize;
            while (cumulativeExpectation > startOffset + (double)index) {
                selection.add(candidate.getCandidate());
                ++index;
            }
        }
        return selection;
    }

    private double getAdjustedFitness(double rawFitness, boolean naturalFitness) {
        if (naturalFitness) {
            return rawFitness;
        }
        return rawFitness == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / rawFitness;
    }

    public String toString() {
        return "Stochastic Universal Sampling";
    }
}

