/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.selection;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.number.ConstantGenerator;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.EvaluatedCandidate;
import org.uncommons.watchmaker.framework.SelectionStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TournamentSelection
implements SelectionStrategy<Object> {
    private final NumberGenerator<Probability> selectionProbability;
    private String description = "Tournament Selection";

    public TournamentSelection(NumberGenerator<Probability> selectionProbability) {
        this.selectionProbability = selectionProbability;
    }

    public TournamentSelection(Probability selectionProbability) {
        this((NumberGenerator<Probability>)new ConstantGenerator((Number)selectionProbability));
        if (selectionProbability.doubleValue() <= 0.5) {
            throw new IllegalArgumentException("Selection threshold must be greater than 0.5.");
        }
        this.description = "Tournament Selection (p = " + selectionProbability.toString() + ')';
    }

    @Override
    public <S> List<S> select(List<EvaluatedCandidate<S>> population, boolean naturalFitnessScores, int selectionSize, Random rng) {
        ArrayList<S> selection = new ArrayList<S>(selectionSize);
        for (int i = 0; i < selectionSize; ++i) {
            EvaluatedCandidate<S> candidate1 = population.get(rng.nextInt(population.size()));
            EvaluatedCandidate<S> candidate2 = population.get(rng.nextInt(population.size()));
            boolean selectFitter = ((Probability)this.selectionProbability.nextValue()).nextEvent(rng);
            if (selectFitter == naturalFitnessScores) {
                selection.add(candidate2.getFitness() > candidate1.getFitness() ? candidate2.getCandidate() : candidate1.getCandidate());
                continue;
            }
            selection.add(candidate2.getFitness() > candidate1.getFitness() ? candidate1.getCandidate() : candidate2.getCandidate());
        }
        return selection;
    }

    public String toString() {
        return this.description;
    }
}

