/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework;

import java.util.List;
import java.util.Random;
import org.uncommons.watchmaker.framework.AbstractEvolutionEngine;
import org.uncommons.watchmaker.framework.CandidateFactory;
import org.uncommons.watchmaker.framework.EvaluatedCandidate;
import org.uncommons.watchmaker.framework.EvolutionUtils;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;
import org.uncommons.watchmaker.framework.FitnessEvaluator;
import org.uncommons.watchmaker.framework.SelectionStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SteadyStateEvolutionEngine<T>
extends AbstractEvolutionEngine<T> {
    private final EvolutionaryOperator<T> evolutionScheme;
    private final FitnessEvaluator<? super T> fitnessEvaluator;
    private final SelectionStrategy<? super T> selectionStrategy;
    private final int selectionSize;
    private final boolean forceSingleCandidateUpdate;

    public SteadyStateEvolutionEngine(CandidateFactory<T> candidateFactory, EvolutionaryOperator<T> evolutionScheme, FitnessEvaluator<? super T> fitnessEvaluator, SelectionStrategy<? super T> selectionStrategy, int selectionSize, boolean forceSingleCandidateUpdate, Random rng) {
        super(candidateFactory, fitnessEvaluator, rng);
        this.fitnessEvaluator = fitnessEvaluator;
        this.evolutionScheme = evolutionScheme;
        this.selectionStrategy = selectionStrategy;
        this.selectionSize = selectionSize;
        this.forceSingleCandidateUpdate = forceSingleCandidateUpdate;
    }

    @Override
    protected List<EvaluatedCandidate<T>> nextEvolutionStep(List<EvaluatedCandidate<T>> evaluatedPopulation, int eliteCount, Random rng) {
        EvolutionUtils.sortEvaluatedPopulation(evaluatedPopulation, this.fitnessEvaluator.isNatural());
        List selectedCandidates = this.selectionStrategy.select(evaluatedPopulation, this.fitnessEvaluator.isNatural(), this.selectionSize, rng);
        List<EvaluatedCandidate<T>> offspring = this.evaluatePopulation(this.evolutionScheme.apply(selectedCandidates, rng));
        this.doReplacement(evaluatedPopulation, offspring, eliteCount, rng);
        return evaluatedPopulation;
    }

    protected void doReplacement(List<EvaluatedCandidate<T>> existingPopulation, List<EvaluatedCandidate<T>> newCandidates, int eliteCount, Random rng) {
        assert (newCandidates.size() < existingPopulation.size() - eliteCount) : "Too many new candidates for replacement.";
        if (newCandidates.size() > 1 && this.forceSingleCandidateUpdate) {
            existingPopulation.set(rng.nextInt(existingPopulation.size() - eliteCount) + eliteCount, newCandidates.get(rng.nextInt(newCandidates.size())));
        } else {
            for (EvaluatedCandidate<T> candidate : newCandidates) {
                existingPopulation.set(rng.nextInt(existingPopulation.size() - eliteCount) + eliteCount, candidate);
            }
        }
    }
}

