/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.operators.AbstractCrossover;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleArrayCrossover
extends AbstractCrossover<double[]> {
    public DoubleArrayCrossover() {
        this(1);
    }

    public DoubleArrayCrossover(int crossoverPoints) {
        super(crossoverPoints);
    }

    public DoubleArrayCrossover(int crossoverPoints, Probability crossoverProbability) {
        super(crossoverPoints, crossoverProbability);
    }

    public DoubleArrayCrossover(NumberGenerator<Integer> crossoverPointsVariable) {
        super(crossoverPointsVariable);
    }

    public DoubleArrayCrossover(NumberGenerator<Integer> crossoverPointsVariable, NumberGenerator<Probability> crossoverProbabilityVariable) {
        super(crossoverPointsVariable, crossoverProbabilityVariable);
    }

    @Override
    protected List<double[]> mate(double[] parent1, double[] parent2, int numberOfCrossoverPoints, Random rng) {
        if (parent1.length != parent2.length) {
            throw new IllegalArgumentException("Cannot perform cross-over with different length parents.");
        }
        double[] offspring1 = new double[parent1.length];
        System.arraycopy(parent1, 0, offspring1, 0, parent1.length);
        double[] offspring2 = new double[parent2.length];
        System.arraycopy(parent2, 0, offspring2, 0, parent2.length);
        double[] temp = new double[parent1.length];
        for (int i = 0; i < numberOfCrossoverPoints; ++i) {
            int crossoverIndex = 1 + rng.nextInt(parent1.length - 1);
            System.arraycopy(offspring1, 0, temp, 0, crossoverIndex);
            System.arraycopy(offspring2, 0, offspring1, 0, crossoverIndex);
            System.arraycopy(temp, 0, offspring2, 0, crossoverIndex);
        }
        ArrayList<double[]> result = new ArrayList<double[]>(2);
        result.add(offspring1);
        result.add(offspring2);
        return result;
    }
}

