/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.operators.AbstractCrossover;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListCrossover<T>
extends AbstractCrossover<List<T>> {
    public ListCrossover() {
        this(1);
    }

    public ListCrossover(int crossoverPoints) {
        super(crossoverPoints);
    }

    public ListCrossover(int crossoverPoints, Probability crossoverProbability) {
        super(crossoverPoints, crossoverProbability);
    }

    public ListCrossover(NumberGenerator<Integer> crossoverPointsVariable) {
        super(crossoverPointsVariable);
    }

    public ListCrossover(NumberGenerator<Integer> crossoverPointsVariable, NumberGenerator<Probability> crossoverProbabilityVariable) {
        super(crossoverPointsVariable, crossoverProbabilityVariable);
    }

    @Override
    protected List<List<T>> mate(List<T> parent1, List<T> parent2, int numberOfCrossoverPoints, Random rng) {
        ArrayList<T> offspring1 = new ArrayList<T>(parent1);
        ArrayList<T> offspring2 = new ArrayList<T>(parent2);
        for (int i = 0; i < numberOfCrossoverPoints; ++i) {
            int max = Math.min(parent1.size(), parent2.size());
            if (max <= 1) continue;
            int crossoverIndex = 1 + rng.nextInt(max - 1);
            for (int j = 0; j < crossoverIndex; ++j) {
                Object temp = offspring1.get(j);
                offspring1.set(j, offspring2.get(j));
                offspring2.set(j, temp);
            }
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>(2);
        result.add(offspring1);
        result.add(offspring2);
        return result;
    }
}

