/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.operators;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.operators.AbstractCrossover;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayCrossover<T>
extends AbstractCrossover<T[]> {
    public ObjectArrayCrossover() {
        this(1);
    }

    public ObjectArrayCrossover(int crossoverPoints) {
        super(crossoverPoints);
    }

    public ObjectArrayCrossover(int crossoverPoints, Probability crossoverProbability) {
        super(crossoverPoints, crossoverProbability);
    }

    public ObjectArrayCrossover(NumberGenerator<Integer> crossoverPointsVariable) {
        super(crossoverPointsVariable);
    }

    public ObjectArrayCrossover(NumberGenerator<Integer> crossoverPointsVariable, NumberGenerator<Probability> crossoverProbabilityVariable) {
        super(crossoverPointsVariable, crossoverProbabilityVariable);
    }

    @Override
    protected List<T[]> mate(T[] parent1, T[] parent2, int numberOfCrossoverPoints, Random rng) {
        if (parent1.length != parent2.length) {
            throw new IllegalArgumentException("Cannot perform cross-over with different length parents.");
        }
        Object[] offspring1 = (Object[])Array.newInstance(parent1.getClass().getComponentType(), parent1.length);
        System.arraycopy(parent1, 0, offspring1, 0, parent1.length);
        Object[] offspring2 = (Object[])Array.newInstance(parent2.getClass().getComponentType(), parent2.length);
        System.arraycopy(parent2, 0, offspring2, 0, parent2.length);
        Object[] temp = new Object[parent1.length];
        for (int i = 0; i < numberOfCrossoverPoints; ++i) {
            int crossoverIndex = 1 + rng.nextInt(parent1.length - 1);
            System.arraycopy(offspring1, 0, temp, 0, crossoverIndex);
            System.arraycopy(offspring2, 0, offspring1, 0, crossoverIndex);
            System.arraycopy(temp, 0, offspring2, 0, crossoverIndex);
        }
        ArrayList<T[]> result = new ArrayList<T[]>(2);
        result.add(offspring1);
        result.add(offspring2);
        return result;
    }
}

